local assets=
{
	Asset("ANIM", "anim/flute_flame.zip"),
	Asset("ATLAS", "images/inventoryimages/flute_flame.xml")
}

local function Recharge(inst)
if GetClock():GetMoonPhase() == "full" then
if inst.components.finiteuses:GetUses() < 2 then
if SaveGameIndex:GetCurrentMode() ~= "cave" then
inst.components.finiteuses:Use(-1)
inst.SoundEmitter:PlaySound("dontstarve/HUD/repair_clothing")
end
end
end
end 

local function onfinished(inst)
    inst:Remove()
end

local function HearFlameFlute(inst, musician, instrument)
if inst.components.sanity then
inst.components.sanity:DoDelta(-30)
end
if inst.components.health and inst.components.burnable and inst:HasTag("monster") and not inst:HasTag("companion") then

local fx = SpawnPrefab("sparklefx")
fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
inst.components.burnable:Ignite()
    if inst and inst.components.burnable and inst.components.burnable:IsBurning() then
    inst.components.burnable:Extinguish()
	end
else

end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddSoundEmitter()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    inst.AnimState:SetBank("flute_flame")
    inst.AnimState:SetBuild("flute_flame")
    inst.AnimState:PlayAnimation("idle")
	MakeInventoryPhysics(inst)
	
	inst:AddTag("flute")
	inst:AddTag("flute_flame")
	
    inst:AddComponent("inspectable")
    inst:AddComponent("instrument")
    inst.components.instrument.range = 15
    inst.components.instrument:SetOnHeardFn(HearFlameFlute)
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/flute_flame.xml"
	
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.PLAY)
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(10)
    inst.components.finiteuses:SetUses(10)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.PLAY, 1)
	
	inst:ListenForEvent("nighttime", function() Recharge(inst) end, GetWorld())
    return inst
end

STRINGS.NAMES.FLUTE_FLAME = ""
STRINGS.RECIPE_DESC.FLUTE_FLAME = "."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FLUTE_FLAME = "Ƿ."

return Prefab( "common/inventory/flute_flame", fn, assets)