local assets=
{
	Asset("ANIM", "anim/flute_frost.zip"),
	Asset("ATLAS", "images/inventoryimages/flute_frost.xml")
}

local function Recharge(inst)
if GetClock():GetMoonPhase() == "full" then
if inst.components.finiteuses:GetUses() < 2 then
if SaveGameIndex:GetCurrentMode() ~= "cave" then
inst.components.finiteuses:Use(-1)
inst.SoundEmitter:PlaySound("dontstarve/HUD/repair_clothing")
end
end
end
end 

local function onfinished(inst)
    inst:Remove()
end

local function HearFrostFlute(inst, musician, instrument)
if inst.components.sanity then
inst.components.sanity:DoDelta(-50)
end
if inst.components.health and inst.components.freezable and inst:HasTag("monster") and not inst:HasTag("companion") then

local fx = SpawnPrefab("splash")
fx.Transform:SetPosition(inst.Transform:GetWorldPosition())

inst.components.freezable:AddColdness(4)
inst.components.freezable:SpawnShatterFX()
if inst.components.fueled then
inst.components.fueled:StartConsuming()        
end
end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddSoundEmitter()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    inst.AnimState:SetBank("flute_frost")
    inst.AnimState:SetBuild("flute_frost")
    inst.AnimState:PlayAnimation("idle")
	MakeInventoryPhysics(inst)
	
	inst:AddTag("flute")
	inst:AddTag("flute_frost")
	
    inst:AddComponent("inspectable")
    inst:AddComponent("instrument")
    inst.components.instrument.range = 10
    inst.components.instrument:SetOnHeardFn(HearFrostFlute)
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/flute_frost.xml"
	
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.PLAY)
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(10)
    inst.components.finiteuses:SetUses(10)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.PLAY, 1)
	
	inst:ListenForEvent("nighttime", function() Recharge(inst) end, GetWorld())
    return inst
end

STRINGS.NAMES.FLUTE_FROST = ""
STRINGS.RECIPE_DESC.FLUTE_FROST = "˪."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FLUTE_FROST = "Ƿ."

return Prefab( "common/inventory/flute_frost", fn, assets)