local assets=
{
    Asset("ANIM", "anim/foxmask.zip"),
	Asset("ANIM", "anim/swap_foxmask.zip"), 
	Asset("ATLAS", "images/inventoryimages/foxmask.xml")
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function stopusingbush(inst, data)
        local equippedArmor = inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if equippedArmor and not (data.statename == "hide_idle" or data.statename == "hide") then
        equippedArmor.components.armor:SetAbsorption(.6)
    else
        equippedArmor.components.armor:SetAbsorption(1)
        equippedArmor.components.useableitem:StopUsingItem()
    end
	
end

local function onequipbush(inst, owner)
     owner.AnimState:OverrideSymbol("swap_hat", "swap_foxmask", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		inst:ListenForEvent("blocked", OnBlocked, owner)
        inst:ListenForEvent("newstate", stopusingbush, owner) 
end
	
local function onunequipbush(inst, owner)
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAIR")
        end
		inst:RemoveEventCallback("blocked", OnBlocked, owner)
		if inst.task then inst.task:Cancel() inst.task = nil end
		    inst:RemoveEventCallback("newstate", stopusingbush, owner)
end
	
 local function onusebush(inst)
        local owner = inst.components.inventoryitem.owner
        if owner then
            owner.sg:GoToState("hide")
        end
    end
	
local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("hat")
    inst.AnimState:SetBank("foxmask")
    inst.AnimState:SetBuild("foxmask")
    inst.AnimState:PlayAnimation("idle",true)
	
    inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 2, .5 )
	
    inst:AddComponent("inspectable")

	inst:AddComponent("tradable")
	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/foxmask.xml"

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(1500, 0)
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/bushhat"
	
    inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(onusebush)
    inst.components.equippable:SetOnEquip( onequipbush )
    inst.components.equippable:SetOnUnequip( onunequipbush )
--[[
if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.2)
	else
end
]]   
    return inst
end

STRINGS.NAMES.FOXMASK = ""
STRINGS.RECIPE_DESC.FOXMASK = "ֹ˺."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FOXMASK = "һЦ."

return Prefab( "common/inventory/foxmask", fn, assets ) 