local assets=
{
	Asset("ANIM", "anim/foxtail1.zip"),
	Asset("ANIM", "anim/swap_foxtail1.zip"),
	Asset("ATLAS", "images/inventoryimages/foxtail1.xml")
}

    local function foxtail1_proc(inst, owner)
        inst:AddTag("forcefield")
        inst.components.armor:SetAbsorption(TUNING.FULL_ABSORPTION)
        local fx = SpawnPrefab("forcefieldfx")
        fx.entity:SetParent(owner.entity)
        fx.Transform:SetPosition(0, 0.2, 0)
        local fx_hitanim = function()
            fx.AnimState:PlayAnimation("hit")
            fx.AnimState:PushAnimation("idle_loop")
        end
        fx:ListenForEvent("blocked", fx_hitanim, owner)

        inst.components.armor.ontakedamage = function(inst, damage_amount)
            if owner then
                local sanity = owner.components.sanity
                if sanity then
                    local unsaneness = damage_amount * TUNING.ARMOR_RUINSHAT_DMG_AS_SANITY
                    sanity:DoDelta(-unsaneness, false)
                end
            end
        end

        inst.active = true

        owner:DoTaskInTime(--[[Duration]] TUNING.ARMOR_RUINSHAT_DURATION, function()
            fx:RemoveEventCallback("blocked", fx_hitanim, owner)
            fx.kill_fx(fx)
            if inst:IsValid() then
                inst:RemoveTag("forcefield")
                inst.components.armor.ontakedamage = nil
                inst.components.armor:SetAbsorption(TUNING.ARMOR_RUINSHAT_ABSORPTION)
                owner:DoTaskInTime(--[[Cooldown]] TUNING.ARMOR_RUINSHAT_COOLDOWN, function() inst.active = false end)
            end
        end)
    end

	local foxtail1_proc_chance = .05
	
    local function tryproc(inst, owner)
        if not inst.active and math.random() < foxtail1_proc_chance then
           foxtail1_proc(inst, owner)
        end
    end

--[[local firefox = .05

local function OnBlocked(owner, data) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
    if math.random() < firefox and data.attacker and data.attacker.components.burnable and not data.attacker:HasTag("thorny") then
    data.attacker.components.burnable:Ignite()
end
    if data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then
    data.attacker.components.burnable:Extinguish()
end
end]]

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_body", "swap_foxtail1", "backpack")
	owner.AnimState:OverrideSymbol("swap_body", "swap_foxtail1", "swap_body")
	owner:AddTag("gumi1")
	owner:RemoveTag("notgumi")
	inst.procfn = function() tryproc(inst, owner) end
	owner:ListenForEvent("attacked", inst.procfn)
	--inst:ListenForEvent("blocked", OnBlocked, owner)
    --inst:ListenForEvent("attacked", OnBlocked, owner)
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
end

local function onunequip(inst, owner)
	owner.AnimState:ClearOverrideSymbol("swap_body")
	owner.AnimState:ClearOverrideSymbol("backpack")
	owner:AddTag("notgumi")
	owner:RemoveTag("gumi1")
	owner:RemoveEventCallback("attacked", inst.procfn)
    --inst:RemoveEventCallback("blocked", OnBlocked, owner)
    --inst:RemoveEventCallback("attacked", OnBlocked, owner)
end

local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 1, .5 )
    
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("foxtail1.tex")
	
	inst:AddTag("foxtail")
	
    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wharang")
	
    inst.AnimState:SetBank("foxtail1")
    inst.AnimState:SetBuild("foxtail1")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/foxtail1.xml"
	
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(100, .15)
	inst.components.armor.SetCondition = function () end

	inst:AddComponent("insulator")
	inst.components.insulator.insulation = 30
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
    return inst
end

STRINGS.NAMES.FOXTAIL1 = "1β"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FOXTAIL1 = "! Iҵβ! ôС!"

return Prefab( "common/inventory/foxtail1", fn, assets) 