local assets=
{
	Asset("ANIM", "anim/grainflour.zip"),
	Asset("ATLAS", "images/inventoryimages/grainflour.xml")
}

local prefabs =
{
    "spoiled_food",
}  

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("grainflour")
    inst.AnimState:SetBuild("grainflour")
    inst.AnimState:PlayAnimation("idle")
	inst.Transform:SetScale(1.5,1.5,1.5)
    
	inst:AddComponent("tradable")
	inst:AddComponent("edible")
	inst.components.edible.hungervalue = (6)
	inst.components.edible.healthvalue = (2)
    inst.components.edible.sanityvalue = (0)
	
	inst:AddComponent("perishable")

	inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/grainflour.xml"

	inst:AddComponent("inspectable")
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = 40
    
    return inst
end

STRINGS.NAMES.GRAINFLOUR = ""
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GRAINFLOUR = "."

return Prefab( "common/inventory/grainflour", fn, assets)