local assets=
{
	Asset("ANIM", "anim/miregg.zip"),
	Asset("IMAGE", "images/inventoryimages/miregg.tex"),
	Asset("ATLAS", "images/inventoryimages/miregg.xml"),
	Asset("IMAGE", "images/inventoryimages/miregg_cracked.tex"),
	Asset("ATLAS", "images/inventoryimages/miregg_cracked.xml"),
}

local prefabs = 
{
	"mir",
	"miregg_cracked",
}

local loot_hot = 
{
    "miregg",
}

local loot_cold = 
{
    "miregg",
}

local function Hatch(inst)
    --print("tallbirdegg - Hatch")
   
	local fx = SpawnPrefab("collapse_small")
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    local mir = SpawnPrefab("mir")
    mir.Transform:SetPosition(inst.Transform:GetWorldPosition())
    mir.sg:GoToState("hatch")

    inst:Remove()
end

local function CheckHatch(inst)
    --print("tallbirdegg - CheckHatch")
    if inst.playernear and inst.components.hatchable.state == "hatch" then
        Hatch(inst)
    end
end

local function PlayUncomfySound(inst)
    inst.SoundEmitter:KillSound("uncomfy")
    if inst.components.hatchable.toohot then
        inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hot_steam_LP", "uncomfy")
    elseif inst.components.hatchable.toocold then
        inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_cold_shiver_LP", "uncomfy")
    end
end

local function OnNear(inst)
    --print("tallbirdegg - OnNear")
    inst.playernear = true
    CheckHatch(inst)
end

local function OnFar(inst)
    --print("tallbirdegg - OnFar")
    inst.playernear = false
end

local function OnDropped(inst)
    --print("tallbirdegg - OnDropped")
    inst.components.hatchable:StartUpdating()
    CheckHatch(inst)
    PlayUncomfySound(inst)
end

local function OnPutInInventory(inst)
    --print("tallbirdegg - OnPutInInventory")
    inst.components.hatchable:StopUpdating()
    inst.SoundEmitter:KillSound("uncomfy")
end

local function GetStatus(inst)
    if inst.components.hatchable then
        local state = inst.components.hatchable.state
        if state == "uncomfy" then
            if inst.components.hatchable.toohot then
                return "HOT"
            elseif inst.components.hatchable.toocold then
                return "COLD"
            end
        end
    end
end

local function DropLoot(inst)
    --print("tallbirdegg - DropLoot")
    
    inst:AddComponent("lootdropper")
    if inst.components.hatchable.toohot then
        inst.components.lootdropper:SetLoot(loot_hot)
    else
        inst.components.lootdropper:SetLoot(loot_cold)
    end
    inst.components.lootdropper:DropLoot()
end

local function OnHatchState(inst, state)
    --print("tallbirdegg - OnHatchState", state)
    
    inst.SoundEmitter:KillSound("uncomfy")

    if state == "crack" then
        local cracked = SpawnPrefab("miregg_cracked")
        cracked.Transform:SetPosition(inst.Transform:GetWorldPosition())
        cracked.AnimState:PlayAnimation("crack")
        cracked.AnimState:PushAnimation("idle_happy", true)
        cracked.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hatch_crack")
        inst:Remove()
    elseif state == "uncomfy" then
        if inst.components.hatchable.toohot then
            inst.AnimState:PlayAnimation("idle_hot", true)
        elseif inst.components.hatchable.toocold then
            inst.AnimState:PlayAnimation("idle_cold", true)
        end
        PlayUncomfySound(inst)
    elseif state == "comfy" then
        inst.AnimState:PlayAnimation("idle_happy", true)
    elseif state == "hatch" then
        CheckHatch(inst)
    elseif state == "dead" then
        --print("   ACK! *splat*")
        if inst.components.hatchable.toohot then
            inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hot_jump")
            inst:DoTaskInTime(20*FRAMES, function() inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_hot_explo") end)
            inst:DoTaskInTime(20*FRAMES, DropLoot)
            inst.AnimState:PlayAnimation("toohot")
        elseif inst.components.hatchable.toocold then
            inst:DoTaskInTime(15*FRAMES, function() inst.SoundEmitter:PlaySound("dontstarve/creatures/egg/egg_cold_freeze") end)
            inst:DoTaskInTime(30*FRAMES, DropLoot)
            inst.AnimState:PlayAnimation("toocold")
        end
        
        inst:ListenForEvent("animover", function(inst) inst:Remove() end)
    end
end

local function commonfn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    MakeInventoryPhysics(inst)
	
    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "miregg.tex" )
	
    inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 1.5, 1.5 )
    
    inst.AnimState:SetBuild("miregg")
    inst.AnimState:SetBank("miregg")
    inst.AnimState:PlayAnimation("egg")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	
    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wharang")

    --inst:AddTag("cattoy")
    --inst:AddComponent("tradable")
    
    return inst
end

local function defaultfn()
	local inst = commonfn()
	inst.components.inventoryitem.atlasname = "images/inventoryimages/miregg.xml"

	inst.entity:AddSoundEmitter()

    inst.AnimState:PlayAnimation("egg")

    inst:AddComponent("hatchable")
    inst.components.hatchable:SetOnState(OnHatchState)
    inst.components.hatchable:SetCrackTime(TUNING.SMALLBIRD_HATCH_CRACK_TIME)
    inst.components.hatchable:SetHatchTime(TUNING.SMALLBIRD_HATCH_TIME/1.5)
    inst.components.hatchable:SetHatchFailTime(TUNING.SMALLBIRD_HATCH_FAIL_TIME)
    inst.components.hatchable:StartUpdating()

    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)

    inst.components.inspectable.getstatus = GetStatus

    inst.playernear = false

	return inst
end

local function crackedfn()
    local inst = defaultfn()
	inst.components.inventoryitem.atlasname = "images/inventoryimages/miregg_cracked.xml"
    
    inst.components.hatchable.state = "comfy"
    inst.AnimState:PlayAnimation("idle_happy")

    inst:AddComponent("playerprox")
    inst.components.playerprox:SetDist(4, 6)
    inst.components.playerprox:SetOnPlayerNear(OnNear)
    inst.components.playerprox:SetOnPlayerFar(OnFar)

    return inst
end

STRINGS.NAMES.MIREGG = ""
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MIREGG = "صɫ."
STRINGS.NAMES.MIREGG_CRACKED = ""
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MIREGG_CRACKED = "ɫĵ"

return Prefab( "common/inventory/miregg", defaultfn, assets, prefabs),
         Prefab( "common/inventory/miregg_cracked", crackedfn, assets)