local assets=
{
	Asset("ANIM", "anim/peppertreeroot.zip"),
	Asset("ATLAS", "images/inventoryimages/peppertreeroot.xml")
}

local prefabs =
{
	"reddrake",
}  

local function root_oneaten(inst, eater)
local pepper = SpawnPrefab("reddrake")
pepper.Transform:SetPosition(inst.Transform:GetWorldPosition())
inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/decidous/drake_pop_large")
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("peppertreeroot")
    inst.AnimState:SetBuild("peppertreeroot")
    inst.AnimState:PlayAnimation("idle")
    
	inst:AddComponent("edible")
	inst.components.edible.hungervalue = (0)
	inst.components.edible.healthvalue = (5)
    inst.components.edible.sanityvalue = (-100)
    inst.components.edible:SetOnEatenFn(root_oneaten)
	
    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
	
    inst:AddComponent("fertilizer")
    inst.components.fertilizer.fertilizervalue = TUNING.GUANO_FERTILIZE
    inst.components.fertilizer.soil_cycles = TUNING.GUANO_SOILCYCLES
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/peppertreeroot.xml"

	inst:AddComponent("inspectable")
    
    return inst
end

STRINGS.NAMES.PEPPERTREEROOT = ""
STRINGS.RECIPE_DESC.PEPPERTREEROOT = "ֻ."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PEPPERTREEROOT = "ǻ."

return Prefab( "common/inventory/peppertreeroot", fn, assets)