local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUNDPACKAGE" , "sound/foxpointup.fev" ),
        Asset( "SOUND" , "sound/foxpointup.fsb" ),
		
        Asset( "ANIM", "anim/wharang.zip" ),
        Asset( "ANIM", "anim/wharang_gumi.zip" ),
        Asset( "ANIM", "anim/wharang_evil.zip" ),
		
}

local prefabs =
{
	 "wharang_spirit",
	 "wharang_spirit_evil",
}

local start_inv = 
{
	 "mihobell",
	 "handfan",
	 "foxtail1",
	 "sakurahat",
}

local function RandomTalk(sayings) 
    return sayings[math.random(#sayings)]
end

local function FoxUPgrades(inst)
	local max_upgrades = 500
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (85 + upgrades * .2) --185
	inst.components.sanity.max = math.ceil (200 + upgrades * .5) --450
	inst.components.health.maxhealth = math.ceil (80 + upgrades * .6) --280
	inst.components.talker:Say("ռ\n".. (inst.level))
	if inst.level > 499 then
		inst.components.talker:Say("ռеĻ")
	end
	
	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)

end

local function SanityFn(inst)
	local x,y,z = inst.Transform:GetWorldPosition()	
	local delta = 0
	local max_rad = 10
	local ents = TheSim:FindEntities(x,y,z, max_rad, {"fire"})
    for k,v in pairs(ents) do 
    	if v.components.burnable and v.components.burnable.burning then
    		local sz = TUNING.SANITYAURA_TINY
    		local rad = v.components.burnable:GetLargestLightRadius() or 1
    		sz = sz * ( math.min(max_rad, rad) / max_rad )
			local distsq = inst:GetDistanceSqToInst(v)
			delta = delta + sz/math.max(1, distsq)
    	end
    end
    
    return delta
end

local function MonsterAttackAura(target)
	if (target:HasTag("monster") and not target:HasTag("shadowcreature")) then
		return true
	end
	return false
end

local function EvilAura(inst, dt)
	if inst.strength == "evil_fox" then
    local auraRange = 2.5
	local hits = inst.components.combat:DoAreaAttack(inst, auraRange, inst, MonsterAttackAura)
end
	
end

local function StormCaller(inst)
	if inst.components.sanity.current <= 25 and not GetSeasonManager():IsRaining() then
		GetSeasonManager():StartPrecip()
		if inst.components.sanity.current <= 25 then
		end
	end
	if inst.components.sanity.current >= 50 and GetSeasonManager():IsRaining() and inst.rainstartedatsanity <= 25 then
		GetSeasonManager():StopPrecip()
	end
	if not GetSeasonManager():IsRaining() then
	end
end

local function OnKill(inst, data)
local shadow_spawn = .01

	if data.cause == inst.prefab 
	and data.inst:HasTag("monster") 
	and not data.inst:HasTag("veggie")
	and not data.inst:HasTag("structure")
	and not data.inst:HasTag("companion") then
	if math.random() < shadow_spawn and data.inst:HasTag("monster") then
	local shadowbeak = SpawnPrefab("shadowbeak")
	shadowbeak.Transform:SetPosition(inst.Transform:GetWorldPosition())
	local shadowbeak2 = SpawnPrefab("sanity_raise")
	shadowbeak2.Transform:SetPosition(inst.Transform:GetWorldPosition())
	end
end
	if data.cause == inst.prefab
	and not data.inst:HasTag("prey")
	and not data.inst:HasTag("veggie")
	and not data.inst:HasTag("insect")
	and not data.inst:HasTag("structure")
	and not data.inst:HasTag("companion") then
	if math.random() < .1 and not data.inst.components.health.nofadeout then
	local time = data.inst.components.health.destroytime or 2
	inst:DoTaskInTime(time, function()
	inst.level = inst.level + 1
	FoxUPgrades(inst)	
	inst.components.sanity:DoDelta(inst.components.sanity.max*.2)
	inst.components.health:DoDelta(inst.components.health.maxhealth*.2)
	inst.SoundEmitter:PlaySound("foxpointup/foxpoint/pointup")
	inst.HUD.controls.status.heart:PulseGreen()
	inst.HUD.controls.status.stomach:PulseGreen()
	inst.HUD.controls.status.brain:PulseGreen()
	inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
	inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
	inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	local fx = SpawnPrefab("sparklefx")
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	local fx2 = SpawnPrefab("wharang_multifireworkfx")
	fx2.Transform:SetPosition(inst.Transform:GetWorldPosition())
	if data.inst:HasTag("smallcreature") and not data.inst:HasTag("monster") then
	local fx = SpawnPrefab("wharang_spiritfx")
	fx.Transform:SetPosition(data.inst:GetPosition():Get())
	fx.Transform:SetScale(.5,.5,.5)
	elseif data.inst:HasTag("largecreature") and not data.inst:HasTag("monster") then
	local fx = SpawnPrefab("wharang_spiritfx")
	fx.Transform:SetPosition(data.inst:GetPosition():Get())
	fx.Transform:SetScale(1.2,1.2,1.2)
	elseif data.inst:HasTag("monster") then
	local fx = SpawnPrefab("wharang_spirit_evilfx")
	fx.Transform:SetPosition(data.inst:GetPosition():Get())
	fx.Transform:SetScale(.7,.7,.7)
	else
	local fx = SpawnPrefab("wharang_spiritfx")
	fx.Transform:SetPosition(data.inst:GetPosition():Get())
	fx.Transform:SetScale(.7,.7,.7)
	end
	end)
	end
	end
end

local function OnEat(inst, food)
	local eat_point = .1
    if math.random() < eat_point and food and food.components.edible.foodtype == "MEAT" then
		inst.level = inst.level + 1
		FoxUPgrades(inst)
		inst.components.sanity:DoDelta(inst.components.sanity.max*0.5)
		inst.components.health:DoDelta(inst.components.health.maxhealth*0.5)
		inst.SoundEmitter:PlaySound("foxpointup/foxpoint/pointup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
		
		local fx = SpawnPrefab("sparklefx")
		fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
		local fx2 = SpawnPrefab("wharang_multifireworkfx")
		fx2.Transform:SetPosition(inst.Transform:GetWorldPosition())
		local pos = Vector3(inst.Transform:GetWorldPosition())
		pos.y = pos.y + 1
		
		if inst.components.eater and (food.prefab == "monstermeat" or food.prefab == "cookedmonstermeat" or food.prefab == "monstermeat_dried" or food.prefab == "monsterlasagna") then
		local spirit_evil = SpawnPrefab("wharang_spirit_evilfx")
		spirit_evil.Transform:SetPosition(pos:Get())
		spirit_evil.Transform:SetScale(.5,.5,.5)
		
		else
		local spirit = SpawnPrefab("wharang_spiritfx")
		spirit.Transform:SetPosition(pos:Get())
		spirit.Transform:SetScale(.5,.5,.5)
		end
	end
	
	if inst.components.eater and food.prefab == "drumstick" then
		inst.components.talker:Say("ϲ!")
		
	elseif inst.components.eater and food.prefab == "drumstick_cooked" then
		inst.components.talker:Say("Ұ!")
		
	elseif inst.components.eater and food.prefab == "turkeydinner" then
		inst.components.talker:Say("ζ!")
		
	end
	
	local eat_prank_1 = .03 --Animal!
	local eat_prank_2 = .04 --Nature!
	local eat_prank_3 = .05 --BOOOO-!
	local eat_prank_4 = .02 --Food!
	local eat_prank_5 = .01 --Nightmare!
	
	if inst.level > 99 then
	if math.random() < eat_prank_1 and food and food.components.edible.foodtype == "MEAT" then
	local pos = Vector3(inst.Transform:GetWorldPosition())
	pos.z = pos.z + math.random()*3
	pos.x = pos.x + math.random()*3
	local fx = SpawnPrefab("collapse_small")
	local item = {"crow","feather_crow","spider","fish","froglegs","rabbit","bee","eel","butterfly","pigskin","tentaclespots","stinger"}
	local randomitem = item[math.random(#item)]
	local prank = SpawnPrefab(randomitem)
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	prank.Transform:SetPosition(pos:Get())
	end
end

	if inst.level > 199 then
	if math.random() < eat_prank_2 and food and food.components.edible.foodtype == "MEAT" then
	inst.components.talker:Say("Nature's gift... It's a miracle!")
	local pos = Vector3(inst.Transform:GetWorldPosition())
	pos.z = pos.z + math.random()*3
	pos.x = pos.x + math.random()*3
	local fx = SpawnPrefab("collapse_small")
	local item = {"rope","cutstone","boards","papyrus","charcoal","ash","twigs","rocks","cutgrass","cutreeds","logs","nitre"}
	local randomitem = item[math.random(#item)]
	local prank = SpawnPrefab(randomitem)
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	prank.Transform:SetPosition(pos:Get())
	end
end

	if inst.level > 299 then
	if math.random() < eat_prank_3 and food and food.components.edible.foodtype == "MEAT" then
	local pos = Vector3(inst.Transform:GetWorldPosition())
	pos.z = pos.z + math.random()*3
	pos.x = pos.x + math.random()*3
	local fx = SpawnPrefab("collapse_small")
	local item = {"silk","beefalowool","manrabbit_tail","beardhair","slurper_pelt","slurtleslime","honeycomb"}
	local randomitem = item[math.random(#item)]
	local prank = SpawnPrefab(randomitem)
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	prank.Transform:SetPosition(pos:Get())
	end
end

	if inst.level > 349 then
	if math.random() < eat_prank_4 and food and food.components.edible.foodtype == "MEAT" then
	inst.components.talker:Say("it's cooking time!")
	local pos = Vector3(inst.Transform:GetWorldPosition())
	pos.z = pos.z + math.random()*3
	pos.x = pos.x + math.random()*3
	local fx = SpawnPrefab("collapse_small")
	local item = {"spoiled_food","wetgoop","powcake","monsterlasagna","meatballs","honeyham","honeycomb","taffy","unagi","honey","cutlichen"}
	local randomitem = item[math.random(#item)]
	local prank = SpawnPrefab(randomitem)
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	prank.Transform:SetPosition(pos:Get())
	end
end

	if inst.level > 499 then
	if math.random() < eat_prank_5 and food and food.components.edible.foodtype == "MEAT" then
	inst.components.talker:Say("I love the gift shop because it is making me happy!")
	local pos = Vector3(inst.Transform:GetWorldPosition())
	pos.z = pos.z + math.random()*3
	pos.x = pos.x + math.random()*3
	local fx = SpawnPrefab("collapse_small")
	local item = {"gears","petals_evil","foliage","nightmarefuel","goldnugget","thulecite","thulecite_pieces","redgem","bluegem","yellowgem"}
	local randomitem = item[math.random(#item)]
	local prank = SpawnPrefab(randomitem)
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	prank.Transform:SetPosition(pos:Get())
	end
end

end

-------------------------------------------Party
local function Show_Party(inst, dt)
	if inst:HasTag("FireFoxAttack") then
		if not inst:HasTag("PartyEnd") then
			inst.party_time = inst.party_time - dt

			if inst.party_time <= 0 then
				inst.party_time = .35
				local nightmare = SpawnPrefab("wharang_ground_firefx")
				nightmare.Transform:SetPosition(inst.Transform:GetWorldPosition())
				nightmare.Transform:SetScale(.25,.25,.25)
	    	end
	    else
	    end
	end
end

local function PartyEnd(inst)
	if inst.PartyTime > 0 then
		inst.PartyTime = inst.PartyTime-1
	else
		inst:RemoveTag("PartyEnd")
		inst.components.talker:Say("Surprise!\nI can restart the New party! NOW!")
		if inst.party_task then inst.party_task:Cancel() inst.party_task = nil end
	end
end

local function Start_Fire_Party(inst)
	if inst:HasTag("FireFoxAttack") then
		if not inst:HasTag("PartyEnd") then
			inst.components.sanity:DoDelta(-50)
			inst.components.playercontroller:ShakeCamera(inst, "FULL", 0.5, 0.02, 1.5, 20)
			inst.components.groundpounderds.numRings = 4
			inst.components.groundpounderds.burner = false
			inst.components.groundpounderds.groundpoundfx = "wharang_ground_firefx"
			inst.components.groundpounderds.groundpounddamagemult = 2.5
			inst.components.groundpounderds.groundpoundringfx = "wharang_ringfx"
			inst.components.groundpounderds:GroundPound()
			inst:AddTag("PartyEnd")
			inst:RemoveTag("FireFoxAttack")
			inst.PartyTime = 480
			inst.party_task = inst:DoPeriodicTask(1, function() PartyEnd(inst) end)
		elseif inst:HasTag("PartyEnd") then
		end
	end
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			FoxUPgrades(inst)

			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
	if data.timeout then
        inst.PartyTime = data.timeout
		if inst.PartyTime > 0 then
			if not inst.party_task then
				inst.party_task = inst:DoPeriodicTask(1, function() PartyEnd(inst) end)
				inst:AddTag("PartyEnd")
			end
		else
			if inst.party_task then inst.party_task:Cancel() inst.party_task = nil end
			inst:RemoveTag("PartyEnd")
		end
    end
end

local function onsave(inst, data)
	data.level = inst.level
	data.timeout = (inst.PartyTime)
end

local function TheEvilWhite(inst, dt)

    if inst.strength == "evil_fox" then
    	inst.nightmare_time = inst.nightmare_time - dt

    	if inst.nightmare_time <= 0 then
    		inst.nightmare_time = 1
			local pos = Vector3(inst.Transform:GetWorldPosition())
			pos.y = pos.y + .5
			local nightmare = SpawnPrefab("statue_transition_2")
			nightmare.Transform:SetPosition(pos:Get())
			--nightmare.Transform:SetScale(.8,.8,.8)
    	end
    end

end

local function GumiStats(inst)
local health_percent = inst.components.health:GetPercent()

if GetClock():IsDay() then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------#################################
if inst.strength == "full_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .73
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")
	
--[[
if inst.costumeSetting == "kor" then
	inst.AnimState:SetBuild("wharang")
elseif inst.costumeSetting == "jap" then
	inst.AnimState:SetBuild("wharang_jap")
elseif inst.costumeSetting == "chi" then
	inst.AnimState:SetBuild("wharang_chi")
end

if inst.costumeSetting == "kor" then
	inst.AnimState:SetBuild("wharang_gumi")
elseif inst.costumeSetting == "jap" then
	inst.AnimState:SetBuild("wharang_gumi_jap")
elseif inst.costumeSetting == "chi" then
	inst.AnimState:SetBuild("wharang_gumi_chi")
end
]]			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .76
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.8
	inst.components.locomotor.runspeed = 8.8
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .79
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 7
	inst.components.locomotor.runspeed = 9
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .82
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "super_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 6.2
	inst.components.locomotor.runspeed = 8.2
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .7
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .73
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .76
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 6.8
	inst.components.locomotor.runspeed = 8.8
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .79
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "power_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .67
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.2
	inst.components.locomotor.runspeed = 8.2
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .7
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .73
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .76
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "low_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 5.8
	inst.components.locomotor.runspeed = 7.8
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .64
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .67
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.2
	inst.components.locomotor.runspeed = 8.2
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .7
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .73
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "evil_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.2
	inst.components.locomotor.runspeed = 9.2
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .4
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.4
	inst.components.locomotor.runspeed = 9.4
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .4
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.6
	inst.components.locomotor.runspeed = 9.6
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .4
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.8
	inst.components.locomotor.runspeed = 9.8
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .4
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
end
end

elseif GetClock():IsDusk() then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------#################################
if inst.strength == "full_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 6.5
	inst.components.locomotor.runspeed = 8.5
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .74
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.7
	inst.components.locomotor.runspeed = 8.7
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .77
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.9
	inst.components.locomotor.runspeed = 8.9
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .8
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 7.1
	inst.components.locomotor.runspeed = 9.1
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .83
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "super_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 6.3
	inst.components.locomotor.runspeed = 8.3
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .71
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.5
	inst.components.locomotor.runspeed = 8.5
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .74
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()

	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.7
	inst.components.locomotor.runspeed = 8.7
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .77
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.7
	inst.components.locomotor.runspeed = 8.7
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .8
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "power_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 6.1
	inst.components.locomotor.runspeed = 8.1
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .68
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.3
	inst.components.locomotor.runspeed = 8.3
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .71
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.5
	inst.components.locomotor.runspeed = 8.5
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .74
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 6.7
	inst.components.locomotor.runspeed = 8.7
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .77
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "low_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 5.9
	inst.components.locomotor.runspeed = 8.9
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .65
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.1
	inst.components.locomotor.runspeed = 8.1
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .68
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.3
	inst.components.locomotor.runspeed = 8.3
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .71
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 6.5
	inst.components.locomotor.runspeed = 8.5
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .74
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "evil_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.2
	inst.components.locomotor.runspeed = 9.2
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .43
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.4
	inst.components.locomotor.runspeed = 9.4
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .43
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.6
	inst.components.locomotor.runspeed = 9.6
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .43
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)
	inst.components.locomotor.walkspeed = 7.8
	inst.components.locomotor.runspeed = 9.8
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .43
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
end
end


elseif GetClock():IsNight() then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------#################################
if GetClock():GetMoonPhase() == "full" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 8
	inst.components.locomotor.runspeed = 10
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = 1
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 10
	inst.components.locomotor.runspeed = 12
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = 1
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")

elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 10
	inst.components.locomotor.runspeed = 12
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = 1
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 10
	inst.components.locomotor.runspeed = 12
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = 1
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("notgumi")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")

end
elseif inst.strength == "full_fox" then	-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .75
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.8
	inst.components.locomotor.runspeed = 8.8
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .78
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 7
	inst.components.locomotor.runspeed = 9
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .81
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 7.2
	inst.components.locomotor.runspeed = 9.2
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .84
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "super_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .72
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .75
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.8
	inst.components.locomotor.runspeed = 8.8
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .78
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 7
	inst.components.locomotor.runspeed = 9
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .81
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "power_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.2
	inst.components.locomotor.runspeed = 8.2
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .69
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .76
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .8
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "low_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.2
	inst.components.locomotor.runspeed = 8.2
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .7
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .76
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .8
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "evil_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 7
	inst.components.locomotor.runspeed = 9
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 7.2
	inst.components.locomotor.runspeed = 9.2
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 7.4
	inst.components.locomotor.runspeed = 9.4
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")

elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 7.6
	inst.components.locomotor.runspeed = 9.6
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")		
end
end
end

if GetWorld():IsCave() then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------#################################
if inst.strength == "full_fox" then	-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .75
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.8
	inst.components.locomotor.runspeed = 8.8
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .78
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 7
	inst.components.locomotor.runspeed = 9
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .81
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 7.2
	inst.components.locomotor.runspeed = 9.2
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .84
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "super_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .72
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .75
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.8
	inst.components.locomotor.runspeed = 8.8
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .78
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 50/255, 50/255)
	inst.components.locomotor.walkspeed = 7
	inst.components.locomotor.runspeed = 9
	inst.components.temperature.hurtrate = .3
	inst.components.combat.damagemultiplier = .81
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "power_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.2
	inst.components.locomotor.runspeed = 8.2
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .69
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .76
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .8
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "low_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 6.2
	inst.components.locomotor.runspeed = 8.2
	inst.components.temperature.hurtrate = .6
	inst.components.combat.damagemultiplier = .7
	inst.components.health:StopRegen()
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("notgumi")
	inst:RemoveTag("gumiform")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang.tex")
	inst.AnimState:SetBuild("wharang")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 160/255, 160/255)
	inst.components.locomotor.walkspeed = 6.4
	inst.components.locomotor.runspeed = 8.4
	inst.components.temperature.hurtrate = .5
	inst.components.combat.damagemultiplier = .76
	inst.components.health:StartRegen(1, 60)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "winnie"
	inst.components.talker.colour = Vector3(255/255, 100/255, 100/255)
	inst.components.locomotor.walkspeed = 6.6
	inst.components.locomotor.runspeed = 8.6
	inst.components.temperature.hurtrate = .4
	inst.components.combat.damagemultiplier = .8
	inst.components.health:StartRegen(1, 50)
	inst.components.eater:SetOmnivore()
	
	inst:AddTag("gumiform")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_gumi.tex")
	inst.AnimState:SetBuild("wharang_gumi")
end

elseif inst.strength == "evil_fox" then -----------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (inst:HasTag("notgumi")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 9
	inst.components.locomotor.runspeed = 10
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")			

elseif (inst:HasTag("gumi1")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 9.2
	inst.components.locomotor.runspeed = 10.2
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")
	
elseif (inst:HasTag("gumi2")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 9.4
	inst.components.locomotor.runspeed = 10.4
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")

elseif (inst:HasTag("gumi3")) then
	inst.soundsname = "wharang_evilwhite"
	inst.components.talker.colour = Vector3(255/255, 255/255, 255/255)	
	inst.components.locomotor.walkspeed = 9.6
	inst.components.locomotor.runspeed = 10.6
	inst.components.temperature.hurtrate = 0
	inst.components.combat.damagemultiplier = .46
	inst.components.health:StopRegen()
	inst.components.eater:SetCarnivore()
	
	inst:AddTag("white")
	inst:RemoveTag("notgumi")
	inst:RemoveTag("white")
	inst.MiniMapEntity:SetIcon("wharang_evil.tex")
	inst.AnimState:SetBuild("wharang_evil")	
end	
end
end

end

local function FormChange(inst)
	SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
end

local function WharangChange(inst, data)

	if inst.strength == "full_fox" then
		if inst.components.sanity:GetPercent() < .70 then
			inst.strength = "super_fox"
			FormChange(inst)
			inst.components.talker:Say("70% Sanity: Power Down...")
		end
		
	elseif inst.strength == "super_fox" then
		if inst.components.sanity:GetPercent() < .50 then
			inst.strength = "power_fox"
			FormChange(inst)
			inst.components.talker:Say("50% Sanity: Power Down...")
		elseif inst.components.sanity:GetPercent() > .80 then
			inst.strength = "full_fox"
			FormChange(inst)
			inst.components.talker:Say("FULL Sanity: Power UP!")
		end
		
	elseif inst.strength == "power_fox" then
		if inst.components.sanity:GetPercent() < .30 then
			inst.strength = "low_fox"
			FormChange(inst)
			inst.components.talker:Say("30% Sanity: Power Down...")
		elseif inst.components.sanity:GetPercent() > .69 then
			inst.strength = "super_fox"
			FormChange(inst)
			inst.components.talker:Say("70% Sanity: Power UP!")
		end
		
	elseif inst.strength == "low_fox" then
		if inst.components.sanity:GetPercent() < .20 then
			inst.strength = "evil_fox"
			FormChange(inst)
			inst.components.talker:Say("Don't touch me...")
		elseif inst.components.sanity:GetPercent() > .49 then
			inst.strength = "power_fox"
			FormChange(inst)
			inst.components.talker:Say("50% Sanity: Power UP!")
		end
		
	elseif inst.strength == "evil_fox" then
		if inst.components.sanity:GetPercent() > .29 then
			inst.strength = "low_fox"
			FormChange(inst)
			inst.components.talker:Say("Will you play with me?")
		end
		
		
	else
		if inst.components.sanity:GetPercent() < .80 then
			inst.strength = "full_fox"
		elseif inst.components.sanity:GetPercent() < .70 then
			inst.strength = "super_fox"
		elseif inst.components.sanity:GetPercent() < .50 then
			inst.strength = "power_fox"
		elseif inst.components.sanity:GetPercent() < .30 then
			inst.strength = "low_fox"
		elseif inst.components.sanity:GetPercent() < .20 then
			inst.strength = "evil_fox"
		elseif inst.components.sanity:GetPercent() > .79 then
			inst.strength = "full_fox"
	end
end
	GumiStats(inst)
end

local function FlameBody1(inst, data)
local firefox = 1 -- 100%
if inst.strength == "full_fox" then
	if math.random() < firefox and data.attacker and data.attacker.components.burnable and not data.attacker:HasTag("thorny") then
	inst.components.talker:Say(RandomTalk(FLAMEHURT))
	inst.components.sanity:DoDelta(-4)
	data.attacker.components.burnable:Ignite()
	local foxfire = SpawnPrefab("foxfire")
	foxfire.Transform:SetPosition(data.attacker.Transform:GetWorldPosition())
	end
	if data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then
    data.attacker.components.burnable:Extinguish()
	end
end
end
local function FlameBody2(inst, data)
local firefox = 1 -- 100%
if inst.strength == "super_fox" or inst.strength == "power_fox" then
	if math.random() < firefox and data.attacker and data.attacker.components.burnable and not data.attacker:HasTag("thorny") then
	inst.components.talker:Say(RandomTalk(FLAMEHURT))
	inst.components.sanity:DoDelta(-2)
	data.attacker.components.health:DoDelta(-2)
	data.attacker.components.burnable:Ignite()
	local foxfire = SpawnPrefab("foxfire")
	foxfire.Transform:SetPosition(inst.Transform:GetWorldPosition())
	end
	if data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then
    data.attacker.components.burnable:Extinguish()
	end
end
end
local function FlameBody3(inst, data)
local firefox = 1 -- 100%
if inst.strength == "low_fox" then
	if math.random() < firefox and data.attacker and data.attacker.components.burnable and not data.attacker:HasTag("thorny") then
	inst.components.talker:Say(RandomTalk(FLAMEHURT))
	inst.components.sanity:DoDelta(-1)
	data.attacker.components.health:DoDelta(-3)
	data.attacker.components.burnable:Ignite()
	local foxfire = SpawnPrefab("foxfire")
	foxfire.Transform:SetPosition(inst.Transform:GetWorldPosition())
	end
	if data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then
    data.attacker.components.burnable:Extinguish()
	end
end
end
local function FrozenBody(inst, data)
local icefox = 1 -- 100%
if inst.strength == "evil_fox" then
    if math.random() < icefox and data.attacker and data.attacker.components.freezable and not data.attacker:HasTag("thorny") then
	inst.components.talker:Say(RandomTalk(FRZOENHURT))
	inst.components.sanity:DoDelta(-1)
	data.attacker.components.health:DoDelta(-1)
    data.attacker.components.freezable:AddColdness(1)
    data.attacker.components.freezable:SpawnShatterFX()
	local foxfire = SpawnPrefab("foxfire")
	foxfire.Transform:SetPosition(inst.Transform:GetWorldPosition())
    end
    if inst.components.fueled then
    inst.components.fueled:StartConsuming()        
    end
end
end

-------------------------------------------Light
local function HungerFire(inst, data)
if GetClock():IsNight() or GetWorld():IsCave() then
if (inst:HasTag("notgumi")) then
if inst.components.hunger:GetPercent() < .8 then
	inst.entity:AddLight()
	inst.Light:SetRadius(1.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(false)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
elseif inst.components.hunger:GetPercent() > .8 then
	inst.entity:AddLight()
	inst.Light:SetRadius(1.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(true)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
	end
elseif (inst:HasTag("gumi1")) then
if inst.components.hunger:GetPercent() < .75 then
	inst.entity:AddLight()
	inst.Light:SetRadius(1.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(false)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
elseif inst.components.hunger:GetPercent() > .75 then
	inst.entity:AddLight()
	inst.Light:SetRadius(1.5)
    inst.Light:SetFalloff(.75)
    inst.Light:SetIntensity(.6)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(true)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
	end
elseif (inst:HasTag("gumi2")) then
if inst.components.hunger:GetPercent() < .7 then
	inst.entity:AddLight()
	inst.Light:SetRadius(1.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(false)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
elseif inst.components.hunger:GetPercent() > .7 then
	inst.entity:AddLight()
	inst.Light:SetRadius(2)
    inst.Light:SetFalloff(.8)
    inst.Light:SetIntensity(.7)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(true)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
	end
elseif (inst:HasTag("gumi3")) then
if inst.components.hunger:GetPercent() < .65 then
	inst.entity:AddLight()
	inst.Light:SetRadius(1.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(false)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
elseif inst.components.hunger:GetPercent() > .65 then
	inst.entity:AddLight()
	inst.Light:SetRadius(3)
    inst.Light:SetFalloff(.9)
    inst.Light:SetIntensity(.8)
    inst.Light:SetColour(255/255,20/255,20/255)
	inst.Light:Enable(true)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
	end
end

else
	inst.entity:AddLight()
	inst.Light:SetRadius(1.1)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(255/255,20/255,20/255)
    inst.Light:Enable(false)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)

end
end
-------------------------------------------
local fn = function(inst)
	
	inst.soundsname = "winnie"
    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "wharang.tex" )
	-------------------Fox Point
	inst.level = 0
	FoxUPgrades(inst)
	table.insert(inst.components.eater.foodprefs, "MEAT")
	-------------------Strength
	inst.strength = "full_fox"
	-------------------Eater
	inst:AddComponent("eater")
    inst.components.eater:SetCanEatHorrible() 
    inst.components.eater:SetOnEatFn(OnEat)
	--inst.components.eater.strongstomach = true
	--[[
	local MeatEat = inst.components.eater.Eat
	inst.components.eater.Eat = function(self, food)
	if self:CanEat(food) then
		if food.prefab == "meat"
		or food.prefab == "smallmeat"
		or food.prefab == "batwing"
		or food.prefab == "froglegs"
		or food.prefab == "plantmeat" then
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue + 10
		
	elseif food.prefab == "monstermeat" then
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue - 40
		food.components.edible.healthvalue =
			food.components.edible.healthvalue + 20
			
	elseif food.prefab == "cookedmonstermeat" then
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue - 20
		food.components.edible.healthvalue =
			food.components.edible.healthvalue + 3
			
	elseif food.prefab == "monstermeat_dried" then
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue - 10
		food.components.edible.healthvalue =
			food.components.edible.healthvalue + 3
			
	elseif food.prefab == "drumstick" then
		--food.components.edible.hungervalue =
			--food.components.edible.hungervalue * 1.25
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue + 15
		food.components.edible.healthvalue =
			food.components.edible.healthvalue + 2
			
	elseif food.prefab == "drumstick_cooked" then
		--food.components.edible.hungervalue =
			--food.components.edible.hungervalue * 1.25
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue + 7
		food.components.edible.healthvalue =
			food.components.edible.healthvalue + 4
			
	elseif food.prefab == "turkeydinner" then
		--food.components.edible.hungervalue =
			--food.components.edible.hungervalue * 1.25
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue + 5
		food.components.edible.healthvalue =
			food.components.edible.healthvalue + 20
			
	elseif food.prefab == "monsterlasagna" then
		food.components.edible.sanityvalue =
			food.components.edible.sanityvalue + -40
		food.components.edible.healthvalue =
			food.components.edible.healthvalue + 20
		end
	end
	return MeatEat(self, food)
	end
]]

	inst.components.eater.EatMEAT = inst.components.eater.Eat
	function inst.components.eater:Eat( food )
		if self:CanEat(food) then
			if food.prefab == "meat"
				or food.prefab == "smallmeat"
				or food.prefab == "batwing"
				or food.prefab == "froglegs"
				or food.prefab == "plantmeat" then
					food.components.edible.sanityvalue = 0
			elseif food.prefab == "monstermeat" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -60
			elseif food.prefab == "cookedmonstermeat" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -30
			elseif food.prefab == "monstermeat_dried" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -15
			elseif food.prefab == "drumstick" then
					food.components.edible.healthvalue = 2
					food.components.edible.hungervalue = 15
					food.components.edible.sanityvalue = 5
			elseif food.prefab == "drumstick_cooked" then
					food.components.edible.healthvalue = 5
					food.components.edible.hungervalue = 18
					food.components.edible.sanityvalue = 5
			elseif food.prefab == "turkeydinner" then
					food.components.edible.healthvalue = 40
					food.components.edible.sanityvalue = 10
			elseif food.prefab == "monsterlasagna" then
				food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -60
	end
	end
	return inst.components.eater:EatMEAT(food)
	end
	-------------------MAX
	inst.components.health:SetMaxHealth(80)
	inst.components.hunger:SetMax(85)
	inst.components.sanity:SetMax(150)
	-------------------
	--inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
	inst.components.health.fire_damage_scale = 0
	inst.components.sanity.night_drain_mult = 0
	inst.components.sanity.neg_aura_mult = 2
	inst.components.sanity.custom_rate_fn = SanityFn
	inst.components.builder.magic_bonus = 2
	-------------------Tag
	inst:AddTag("notgumi")
	inst:AddTag("wharang")
	-------------------Save&Load
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	-------------------Rain
	inst.rainstartedatsanity = 150
	--inst:ListenForEvent("rainstart", function()
	--inst.rainstartedatsanity = inst.components.sanity.current
	--end, GetWorld())
	--inst:DoPeriodicTask(1/10, function() StormCaller(inst) end)
	inst:DoPeriodicTask(1/10, function() TheEvilWhite(inst, 1/10) end)
	inst:DoPeriodicTask(1/10, function() Show_Party(inst, 1/10) end)
	inst.nightmare_time = 1
	inst.party_time = .35
	-------------------Event
	inst:ListenForEvent( "entity_death", function(wrld, data) OnKill(inst, data) end, GetWorld())--KILL!
	inst:ListenForEvent( "equip", function() GumiStats(inst) end)
	inst:ListenForEvent( "unequip", function() GumiStats(inst) end)
    inst:ListenForEvent( "daytime", function() GumiStats(inst) end , GetWorld())
	inst:ListenForEvent( "dusktime", function() GumiStats(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() GumiStats(inst) end , GetWorld())
	inst:ListenForEvent( "daytime", function() HungerFire(inst) end , GetWorld())--Light Day
	inst:ListenForEvent( "nighttime", function() HungerFire(inst) end , GetWorld())--Light Night
	inst:ListenForEvent( "sanitydelta", WharangChange)
	inst:ListenForEvent( "hungerdelta", HungerFire)--Light
	inst:ListenForEvent( "attacked", FlameBody1)--Hurt
	inst:ListenForEvent( "attacked", FlameBody2)--Hurt
	inst:ListenForEvent( "attacked", FlameBody3)--Hurt
	inst:ListenForEvent( "attacked", FrozenBody)--E.W Hurt
	inst:ListenForEvent( "onhitother", Start_Fire_Party)
	-------------------
    GumiStats(inst)
	-------------------
	inst:AddComponent("reader")
	inst:AddComponent("colourtweener")
	inst.components.colourtweener:StartTween({255/255,255/255,255/255,255/255}, 0.5)
	-------------------
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(4)
    inst.updateTask = inst:DoPeriodicTask(1, EvilAura, nil, 1)
	-------------------
	inst:AddComponent("groundpounderds")
	-------------------
	RECIPETABS['YINYANG'] = {str = "YINYANG", sort= 99998123, icon = "yinyangtab.tex", icon_atlas = "images/tabs/yinyangtab.xml"}
	TUNING.SANITY_TINY = 2.5
	TUNING.HOUND_DAMAGE = 30
	TUNING.FIREHOUND_DAMAGE = 40
	TUNING.ICEHOUND_DAMAGE = 40
	TUNING.DEERCLOPS_DAMAGE = 100
	-------------------
	STRINGS.CHARACTERS.WHARANG = require "speech_wharang"
	-------------------
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	print("RoG support enabled")
	TUNING.MOOSE_DAMAGE = 100
	TUNING.MOSSLING_DAMAGE = 30
	TUNING.DRAGONFLY_DAMAGE = 100
	TUNING.BEARGER_DAMAGE = 230
	TUNING.BEARGER_HEALTH = 3500
	-------------------
	inst.components.temperature.overheattemp = 90
	end

end

FLAMEHURT = {
"Ow! ˺!",
"!",
"Ouch! ͣ!",
"˵!",
"ɱ?!",
"Ҫ!",
"һ㶼!",
"!",
"ͣ!",
"Oww!",
}

FRZOENHURT = {
"...",
"˵...",
"ڿ...",
"Ū...",
"Ҳ...",
"ÿ!",
"Զ!",
"...",
"Ϊʲô...?",
"Һ...",
}

STRINGS.CHARACTER_TITLES.wharang = "ǧ"
STRINGS.CHARACTER_NAMES.wharang = ""
STRINGS.CHARACTER_DESCRIPTIONS.wharang = "* Miho 㡣\n*ֵõģ\n*ʱǧ"
STRINGS.CHARACTER_QUOTES.wharang = "\"?\""
--STRINGS.CHARACTERS.WHARANG = {}
--STRINGS.CHARACTERS.WHARANG.DESCRIBE = {}

return MakePlayerCharacter("wharang", prefabs, assets, fn, start_inv)