require("stategraphs/commonstates")


local actionhandlers = 
{
    ActionHandler(ACTIONS.EAT, "eat"),
    ActionHandler(ACTIONS.GOHOME, "idle_blink"),
}

local events=
{
    CommonHandlers.OnStep(),
    CommonHandlers.OnSleep(),
    CommonHandlers.OnLocomote(false,true),
    EventHandler("attacked", function(inst)
        if not inst.components.health:IsDead() then
            inst.sg:GoToState("hit")
        end
    end),
    EventHandler("doattack", function(inst) 
        if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then 
            inst.sg:GoToState("attack") 
        end 
    end),

    EventHandler("death", function(inst) inst.sg:GoToState("death") end),
}

local states=
{
    State{
        name = "idle",
        tags = {"idle", "canrotate"},
        
        onenter = function(inst, pushanim)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("idle", true)
            inst.sg:SetTimeout(6)
        end,
		
        ontimeout = function(inst)
            --print("smallbird - idle timeout")
            if math.random() < .1 then
                inst.sg:GoToState("idle_blink")
				else
				inst.sg:GoToState("idle")
            end
        end,

        events=
        { },
    },

    State{
        name = "idle_blink",
        tags = {"idle", "canrotate"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("idle_blink")
        end,
       
        timeline = 
        {
            TimeEvent(20*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/cute") end),
        },

        events=
        {
            EventHandler("animover", 
                function(inst,data) 
                    if math.random() < .05 then
                        inst.sg:GoToState("idle_blink")
                    else
                        inst.sg:GoToState("idle")
                    end
                end
            ),
        },
    },

    State{
        name = "hatch",
        tags = {"busy"},
        onenter = function(inst)
            inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/egg_hatch_crack")
            inst.AnimState:PlayAnimation("sleep_pst")
        end,
        timeline = 
        {
			TimeEvent(0*FRAMES, function(inst) inst.Transform:SetScale(.7, .7, .7) end),
			TimeEvent(1*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/egg_hatch") end),
			TimeEvent(2*FRAMES, function(inst) inst.Transform:SetScale(.71, .71, .71) end),
			TimeEvent(3*FRAMES, function(inst) inst.Transform:SetScale(.72, .72, .72) end),
			TimeEvent(4*FRAMES, function(inst) inst.Transform:SetScale(.73, .73, .73) end),
			TimeEvent(5*FRAMES, function(inst) inst.Transform:SetScale(.74, .74, .74) end),
			TimeEvent(6*FRAMES, function(inst) inst.Transform:SetScale(.75, .75, .75) end),
			TimeEvent(7*FRAMES, function(inst) inst.Transform:SetScale(.76, .76, .76) end),
			TimeEvent(8*FRAMES, function(inst) inst.Transform:SetScale(.77, .77, .77) end),
			TimeEvent(9*FRAMES, function(inst) inst.Transform:SetScale(.78, .78, .78) end),
			TimeEvent(10*FRAMES, function(inst) inst.Transform:SetScale(.79, .79, .79) end),
			TimeEvent(11*FRAMES, function(inst) inst.Transform:SetScale(.8, .8, .8) end),
        },
        events=
        {
            EventHandler("animover", function(inst)
                inst.sg:GoToState("idle")
                inst.userfunctions.FollowPlayer(inst)
            end),
        },
    },

    State{
        name = "growup",
        tags = {"busy"},
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("sleep_pre")
        end,
        timeline = 
        {
            --TimeEvent(28*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/leg_sproing") end),
        },
        events=
        {
            EventHandler("animover", function(inst)
                inst.userfunctions.SpawnMir2(inst)
            end),
        },
    },
	
    State{
        name = "growstop",
        tags = {"busy"},
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("sleep_pst")
        end,
        timeline = 
        {
            TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/cute") end),
        },
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
        },
    },

    State{
        name = "eat",
        tags = {"busy", "canrotate"},
        
        onenter = function(inst)
            inst.Physics:Stop()            
            inst.AnimState:PlayAnimation("eat")
            inst.SoundEmitter:PlaySound("dontstarve/wilson/eat", "eating")
        end,
        
        timeline=
        {
            TimeEvent(7*FRAMES, function(inst) 
                inst:PerformBufferedAction() 
            end),
			
            TimeEvent(30*FRAMES, function(inst) 
	            inst.SoundEmitter:KillSound("eating")    
	        end),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
        },        
    },
}

CommonStates.AddCombatStates(states,
{
	hittimeline = {},
	attacktimeline = 
	{
		TimeEvent(5*FRAMES, function(inst) 
			inst.SoundEmitter:PlaySound("mir/mir/attack")
			inst.components.combat:DoAttack() 
		end)
	},
	deathtimeline = 
	{
		TimeEvent(10*FRAMES, function(inst) 
            inst.components.locomotor:StopMoving()
            RemovePhysicsColliders(inst)            
            --inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition()))
			inst.SoundEmitter:PlaySound("mir/mir/death") 
		end),
	},
})

CommonStates.AddWalkStates(states, {
    walktimeline = 
    { 
        --TimeEvent(0*FRAMES, function(inst)  end),
        TimeEvent(0*FRAMES, function(inst) 
            --inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/boing")
			inst.SoundEmitter:PlaySound("dontstarve/movement/run_marble_small")
            inst.components.locomotor:RunForward() 
        end),
        --TimeEvent(12*FRAMES, function(inst) PlayFootstep(inst) end),
        TimeEvent(0*FRAMES, function(inst) 
            PlayFootstep(inst)
            inst.components.locomotor:WalkForward()
        end),
    }
}, nil, true)

CommonStates.AddSleepStates(states,
{
    starttimeline = 
    {
        TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/sleep") end)
    },
	
	sleeptimeline = {
        TimeEvent(15*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/sleep") end),
	},
	
    waketimeline = 
    {
        TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/sleep") end)
    },
})

return StateGraph("mir", states, events, "idle", actionhandlers)