local PetStay = Class(function(self, inst)
	self.inst = inst
	self.stay = false
	self.locations = {}

end)

function PetStay:CollectSceneActions(doer, actions, rightclick)
	if rightclick and self.inst.components.follower and self.inst.components.follower.leader == GetPlayer() then
		if not self.inst.components.petstay:IsCurrentlyStaying() then
			table.insert(actions, ACTIONS.PETSTAY)
		else
			table.insert(actions, ACTIONS.PETSTAY_CANCEL)
		end
	end
end

function PetStay:IsCurrentlyStaying()
	return self.stay
end

function PetStay:SetStaying(stay)
	self.stay = stay
end


function PetStay:RememberStayPos(name, pos)
    self.locations[name] = pos
end

function PetStay:OnSave()
	if self.stay == true then
		local data = 
			{ 
				stay = self.stay,
				varx = self.locations.stayspos["x"], 
				vary = self.locations.stayspos["y"], 
				varz = self.locations.stayspos["z"]
			}
		return data
	end
end   
   
function PetStay:OnLoad(data)

	if data then 
		self.stay = data.stay
		self.locations.stayspos = { }
		self.locations.stayspos["x"] = data.varx
		self.locations.stayspos["y"] = data.vary
		self.locations.stayspos["z"] = data.varz
	end
end

return PetStay