local assets=
{
	Asset("ANIM", "anim/flute_healing.zip"),
	Asset("ATLAS", "images/inventoryimages/flute_healing.xml")
}

local function Recharge(inst)
if GetClock():GetMoonPhase() == "full" then
if inst.components.finiteuses:GetUses() < 2 then
if SaveGameIndex:GetCurrentMode() ~= "cave" then
inst.components.finiteuses:Use(-1)
inst.SoundEmitter:PlaySound("dontstarve/HUD/repair_clothing")
end
end
end
end 

local function onfinished(inst)
    inst:Remove()
end

local function HearHealingHorn(inst, musician, instrument)

if inst.components.sanity then
inst.components.sanity:DoDelta(-20)
end
if inst.components.health and inst:HasTag("companion") then
local fx = SpawnPrefab("sparklefx")
fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
local fx2 = SpawnPrefab("sparks_fx")
fx2.Transform:SetPosition(inst.Transform:GetWorldPosition())
fx2.Transform:SetScale(1.5,1.5,1.5)

inst.components.health:DoDelta(100)

elseif inst.components.health and inst:HasTag("character") and not inst:HasTag("monster") and not inst:HasTag("guard") then
local fx = SpawnPrefab("sparklefx")
fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
local fx2 = SpawnPrefab("sparks_fx")
fx2.Transform:SetPosition(inst.Transform:GetWorldPosition())
fx2.Transform:SetScale(1.5,1.5,1.5)

inst.components.health:DoDelta(30)
end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddSoundEmitter()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    inst.AnimState:SetBank("flute_healing")
    inst.AnimState:SetBuild("flute_healing")
    inst.AnimState:PlayAnimation("idle")
	MakeInventoryPhysics(inst)
	
	inst:AddTag("horn")
	inst:AddTag("flute_healing")
	
    inst:AddComponent("inspectable")
    inst:AddComponent("instrument")
    inst.components.instrument.range = 15
    inst.components.instrument:SetOnHeardFn(HearHealingHorn)
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/flute_healing.xml"
	
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.PLAY)
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(10)
    inst.components.finiteuses:SetUses(10)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.PLAY, 1)
	
	inst:ListenForEvent("nighttime", function() Recharge(inst) end, GetWorld())
    return inst
end

STRINGS.NAMES.FLUTE_HEALING = "Healing Trumpet"
STRINGS.RECIPE_DESC.FLUTE_HEALING = "Play healing music to companion."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FLUTE_HEALING = "This is a very old trumpet."

return Prefab( "common/inventory/flute_healing", fn, assets)