require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/gumipot.zip"),
	Asset("ANIM", "anim/ui_chester_shadow_3x4.zip"),
	Asset("ANIM", "anim/ui_chest_4x4.zip"),
	
	Asset("IMAGE", "images/inventoryimages/gumipot.tex"),
	Asset("ATLAS", "images/inventoryimages/gumipot.xml"),
}

local prefabs =
{
	"collapse_small"
}

local function onopen(inst) 
	inst.AnimState:PlayAnimation("open") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("close") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")		
end 

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.components.container:DropEverything()
	inst.AnimState:PushAnimation("closed", false)
	inst.components.container:Close()
end

local slotpos = {}

for y = 2.5, -.5, -1 do
    for x = 0, 3 do
        table.insert(slotpos, Vector3(75*x-93*2+75, 75*y-75*2+75,0))
    end
end
		
local function fn(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		
		local minimap = inst.entity:AddMiniMapEntity()
		minimap:SetIcon( "gumipot.tex" )

		inst:AddTag("fridge")
		inst:AddTag("structure")
		inst:AddTag("gumipot")
		
		inst.AnimState:SetBank("gumipot")
		inst.AnimState:SetBuild("gumipot")
		inst.AnimState:PlayAnimation("closed")
		
		inst:AddComponent("inspectable")
		inst:AddComponent("container")
		inst.components.container:SetNumSlots(#slotpos)
		
		inst.components.container.onopenfn = onopen
		inst.components.container.onclosefn = onclose
		
		inst.components.container.widgetslotpos = slotpos
		inst.components.container.widgetanimbank = "ui_chest_4x4"
		inst.components.container.widgetanimbuild = "ui_chest_4x4"
		inst.components.container.widgetpos = Vector3(0,200,0)
		inst.components.container.side_align_tip = 160
		
		inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(5)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit)
		
		inst:ListenForEvent( "onbuilt", function()
		inst.AnimState:PlayAnimation("place")
		inst.AnimState:PushAnimation("closed", false)
		end)
	
		MakeSnowCovered(inst, .01)
		return inst
end

STRINGS.NAMES.GUMIPOT = "OngGi"
STRINGS.RECIPE_DESC.GUMIPOT = "Asia style fridge. Generated on the spot."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GUMIPOT = "This pot is very cold."
	
return  Prefab( "common/gumipot", fn, assets, prefabs),
    MakePlacer("common/gumipot_placer", "gumipot", "gumipot", "closed")