require "prefabutil"

local assets = 
{
	Asset("ANIM", "anim/reddrake.zip"),
	
	Asset( "SOUND" , "sound/decidous.fsb" ),
	Asset( "SOUNDPACKAGE" , "sound/dontstarve_DLC001.fev" ),
}

local orange_assets = 
{
	Asset("ANIM", "anim/orangedrake.zip"),

	Asset( "SOUND" , "sound/decidous.fsb" ),
	Asset( "SOUNDPACKAGE" , "sound/dontstarve_DLC001.fev" ),
}

local gold_assets = 
{
	Asset("ANIM", "anim/golddrake.zip"),
	
	Asset( "SOUND" , "sound/decidous.fsb" ),
	Asset( "SOUNDPACKAGE" , "sound/dontstarve_DLC001.fev" ),
}

local prefabs =
{
	"berries",
	"cutgrass",
	"orangedrake_build",
	"golddrake_build",
}

local function RedSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return ---TUNING.SANITYAURA_TINY
	end
	
	return 0
end

local function OrangeSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return ---TUNING.SANITYAURA_TINY
	end
	
	return 0
end

local function GoldSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return -TUNING.SANITYAURA_TINY
	end
	
	return 0
end

local function OnNewTarget(inst, data)
    if data.target and data.target:HasTag("player") then
end
end

local function OnAttacked(inst, data)
--print("난 더이상 네가 필요하지 않아.")
    local attacker = data and data.attacker
    if attacker and attacker:HasTag("player") then
        inst.components.health:SetVal(0)
    else
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 15, function(dude) return dude:HasTag("companion") end, 10)
end
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function KeepTarget(inst, target)
    return inst.components.combat:CanTarget(target) and (not inst:HasTag("companion") or inst:IsNear(target, 20))
end


local function GetSmallGrowTime(inst)
	return TUNING.SMALLBIRD_GROW_TIME
end

local function GetTallGrowTime(inst)
	return TUNING.TEENBIRD_GROW_TIME
end


local function SetOrange(inst)
    inst.sg:GoToState("growup")
end

local function SpawnOrange(inst)

    local orangedrake = SpawnPrefab("orangedrake")
    orangedrake.Transform:SetPosition(inst.Transform:GetWorldPosition())
    orangedrake.sg:GoToState("enter")

    if inst.components.follower.leader then
        orangedrake.components.follower:SetLeader(inst.components.follower.leader)
    end

    inst:Remove()
end

local function SetGold(inst)
    inst.sg:GoToState("growup")
end

local function SpawnGold(inst)

    local golddrake = SpawnPrefab("golddrake")
    golddrake.Transform:SetPosition(inst.Transform:GetWorldPosition())
    golddrake.sg:GoToState("enter")
	
    if inst.components.follower.leader then
        golddrake.components.follower:SetLeader(inst.components.follower.leader)
    end

    inst:Remove()
end

local function create_common(inst)
	inst:AddTag("peppertree")
	inst:AddTag("scarytoprey")
	inst:AddTag("noauradamage")
    inst:AddTag("companion")
    inst:AddTag("character")

	inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
	
	MakeCharacterPhysics(inst, 1, .25)
    
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)

    inst.Transform:SetFourFaced()	

    inst.userfunctions = 
    {
        FollowPlayer = FollowPlayer,
        SpawnOrange = SpawnOrange,
        SpawnGold = SpawnGold,
    }

    inst:AddComponent("health")
	
    inst:AddComponent("knownlocations")
    MakeSmallBurnableCharacter(inst)

    inst:AddComponent("combat")
    inst.components.combat:SetRange(2.5, 3)
    inst.components.combat:SetAttackPeriod(2)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	inst.components.combat:SetHurtSound("dontstarve_DLC001/creatures/decidous/drake_hit")
	
	inst:ListenForEvent("attacked", OnAttacked)
    inst:ListenForEvent("newcombattarget", OnNewTarget)

    inst:AddComponent("inspectable")

    inst:AddComponent("locomotor")
	
	inst:AddComponent("lootdropper")

    inst:AddComponent("follower")
	
	inst:AddComponent("talker")
	inst.components.talker.font = TALKINGFONT

	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
	
	local brain = require "brains/reddrakebrain"
    inst:SetBrain(brain)
	
    return inst
end

local function create_reddrake()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize(1.25, .75)
	inst.Transform:SetScale(.6,.6,.6)
	
	create_common(inst)
	inst:SetStateGraph("SGreddrake")

	anim:SetBank("treedrake")
	anim:SetBuild("reddrake")
	--anim:PlayAnimation("exit")

	inst:AddTag("reddrake")
	
	inst.components.lootdropper.numrandomloot = 1
	inst.components.lootdropper:AddRandomLoot("berries", .4)
	inst.components.lootdropper:AddRandomLoot("cutgrass", .6)

    inst.components.locomotor.walkspeed = 6
	
    inst.components.combat:SetDefaultDamage(10)

    inst.components.health:SetMaxHealth(150)
	inst.components.health:StartRegen(10, 2)

    inst.components.talker.fontsize = 20
    inst.components.talker.offset = Vector3(0,-400,0)
	
    --inst:AddComponent("sanityaura")
    --inst.components.sanityaura.aurafn = RedSanityAura
	
    local growth_stages = {
        {name="red", time = GetSmallGrowTime, fn = function() end },
        {name="orange", fn = SetOrange}
    }
	
	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StartGrowing()

	return inst
end

local function create_orangedrake()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize(1.5, 1)
	inst.Transform:SetScale(.8,.8,.8)
	
	create_common(inst)
	inst:SetStateGraph("SGorangedrake")

	anim:SetBank("treedrake")
	anim:SetBuild("orangedrake")
	--anim:PlayAnimation("exit")

	inst:AddTag("orangedrake")
	
	inst.components.lootdropper.numrandomloot = 1
	inst.components.lootdropper:AddRandomLoot("berries", .4)
	inst.components.lootdropper:AddRandomLoot("cutgrass", .6)
	inst.components.lootdropper:AddRandomLoot("pinecone", .8)
	inst.components.lootdropper:AddRandomLoot("livinglog", .2)

    inst.components.locomotor.walkspeed = 6
	
    inst.components.combat:SetDefaultDamage(15)

    inst.components.health:SetMaxHealth(350)
	inst.components.health:StartRegen(10, 4)

    inst.components.talker.fontsize = 23
    inst.components.talker.offset = Vector3(0,-350,0)
	
    --inst:AddComponent("sanityaura")
    --inst.components.sanityaura.aurafn = OrangeSanityAura
	
    local growth_stages = {
        {name="orange", time = GetTallGrowTime, fn = function() end },
        {name="gold", fn = SetGold}
    }
	
	inst:AddComponent("growable")
    inst.components.growable.stages = growth_stages
    inst.components.growable:SetStage(1)
    inst.components.growable:StartGrowing()

	return inst
end

local function create_golddrake()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize(1.75, 1.25)
	inst.Transform:SetScale(1,1,1)
	
	create_common(inst)
	inst:SetStateGraph("SGgolddrake")

	anim:SetBank("treedrake")
	anim:SetBuild("golddrake")
	--anim:PlayAnimation("exit")

	inst:AddTag("golddrake")
	
	inst.components.lootdropper.numrandomloot = 1
	inst.components.lootdropper:AddRandomLoot("berries", .4)
	inst.components.lootdropper:AddRandomLoot("cutgrass", .6)
	inst.components.lootdropper:AddRandomLoot("pinecone", .8)
	inst.components.lootdropper:AddRandomLoot("livinglog", .2)
	inst.components.lootdropper:AddRandomLoot("plantmeat", .3)
	inst.components.lootdropper:AddRandomLoot("peppertreeroot", .1)

    inst.components.locomotor.walkspeed = 6
	
    inst.components.combat:SetDefaultDamage(20)

    inst.components.health:SetMaxHealth(600)
	inst.components.health:StartRegen(10, 6)

    inst.components.talker.fontsize = 26
    inst.components.talker.offset = Vector3(0,-300,0)
	
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = GoldSanityAura

	return inst
end

STRINGS.NAMES.REDDRAKE = "Chili Pepper Tree"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.REDDRAKE = "You're really cute tree monster."

STRINGS.NAMES.ORANGEDRAKE = "Orange Pepper Tree"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ORANGEDRAKE = "I think this tree is growing."

STRINGS.NAMES.GOLDDRAKE = "Gold Pepper Tree"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GOLDDRAKE = "This tree don't grow anymore."

return Prefab( "common/reddrake", create_reddrake, assets, prefabs),
	      Prefab( "common/orangedrake", create_orangedrake, orange_assets),
	      Prefab( "common/golddrake", create_golddrake, gold_assets)