require("stategraphs/commonstates")


local actionhandlers = 
{
    ActionHandler(ACTIONS.EAT, "eat"),
    ActionHandler(ACTIONS.GOHOME, "idle_blink"),
}

local events=
{
    CommonHandlers.OnStep(),
    CommonHandlers.OnSleep(),
    CommonHandlers.OnLocomote(false,true),
    EventHandler("attacked", function(inst)
        if not inst.components.health:IsDead() then
            inst.sg:GoToState("hit")
        end
    end),
    EventHandler("doattack", function(inst) 
        if not inst.components.health:IsDead() and not inst.sg:HasStateTag("busy") then 
            inst.sg:GoToState("attack") 
        end 
    end),

    EventHandler("death", function(inst) inst.sg:GoToState("death") end),
}

local states=
{
    State{
        name = "idle",
        tags = {"idle", "canrotate"},
        
        onenter = function(inst, pushanim)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("idle", true)
            inst.sg:SetTimeout(4 + 4*math.random())
        end,
		
        ontimeout = function(inst)
            --print("smallbird - idle timeout")
            if math.random() < .2 then
                inst.sg:GoToState("idle_blink")
				else
				inst.sg:GoToState("idle")
            end
        end,

        events=
        { },
    },

    State{
        name = "idle_blink",
        tags = {"idle", "canrotate"},
        
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("idle_blink")
        end,
       
        timeline = 
        {
            TimeEvent(20*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/cute") end),
        },

        events=
        {
            EventHandler("animover", 
                function(inst,data) 
                    if math.random() < .05 then
                        inst.sg:GoToState("idle_blink")
                    else
                        inst.sg:GoToState("idle")
                    end
                end
            ),
        },
    },

    State{
        name = "growup",
        tags = {"busy"},
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("sleep_pre")
        end,
        timeline = 
        {
            --TimeEvent(28*FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/creatures/smallbird/leg_sproing") end),
        },
        events=
        {
            EventHandler("animover", function(inst)
                inst.userfunctions.SpawnMir3(inst)
            end),
        },
    },
	
    State{
        name = "growstop",
        tags = {"busy"},
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("sleep_pst")
        end,
        timeline = 
        {
            TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/cute") end),
        },
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
        },
    },

    State{
        name = "eat",
        tags = {"busy", "canrotate"},
        
        onenter = function(inst)
            inst.Physics:Stop()            
            inst.AnimState:PlayAnimation("eat")
            inst.SoundEmitter:PlaySound("dontstarve/wilson/eat", "eating")
        end,
        
        timeline=
        {
            TimeEvent(7*FRAMES, function(inst) 
                inst:PerformBufferedAction() 
            end),
			
            TimeEvent(30*FRAMES, function(inst) 
	            inst.SoundEmitter:KillSound("eating")    
	        end),
        },
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end ),
        },        
    },
}

CommonStates.AddCombatStates(states,
{
	hittimeline = {},
	attacktimeline = 
	{
		TimeEvent(5*FRAMES, function(inst) 
			inst.SoundEmitter:PlaySound("mir/mir/attack")
			inst.components.combat:DoAttack() 
		end)
	},
	deathtimeline = 
	{
		TimeEvent(10*FRAMES, function(inst) 
            inst.components.locomotor:StopMoving()
            RemovePhysicsColliders(inst)            
            --inst.components.lootdropper:DropLoot(Vector3(inst.Transform:GetWorldPosition()))
			inst.SoundEmitter:PlaySound("mir/mir/death") 
		end),
	},
})

CommonStates.AddWalkStates(states, {
    walktimeline = 
    { 
        --TimeEvent(0*FRAMES, function(inst)  end),
        TimeEvent(0*FRAMES, function(inst) 
            --inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/boing")
			inst.SoundEmitter:PlaySound("dontstarve/movement/run_marble_small")
            inst.components.locomotor:RunForward() 
        end),
        --TimeEvent(12*FRAMES, function(inst) PlayFootstep(inst) end),
        TimeEvent(0*FRAMES, function(inst) 
            PlayFootstep(inst)
            inst.components.locomotor:WalkForward()
        end),
    }
}, nil, true)

CommonStates.AddSleepStates(states,
{
    starttimeline = 
    {
        TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/sleep") end)
    },
	
	sleeptimeline = {
        TimeEvent(15*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/sleep") end),
	},
	
    waketimeline = 
    {
        TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound("mir/mir/sleep") end)
    },
})

return StateGraph("mir2", states, events, "idle", actionhandlers)