local assets =
{
	Asset("ANIM", "anim/driedcroaker.zip"),
    Asset("ATLAS", "images/inventoryimages/driedcroaker.xml"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)
	MakeSmallPropagator(inst)

	inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 1.5, 2 )
	
	inst.AnimState:SetBank("driedcroaker")
	inst.AnimState:SetBuild("driedcroaker")
	inst.AnimState:PlayAnimation("idle", false)
	
	inst:AddTag("preparedfood")

	inst:AddComponent("edible")
	inst.components.edible.foodtype = "MEAT"
	inst.components.edible.hungervalue = (80)
	inst.components.edible.healthvalue = (40)
    inst.components.edible.sanityvalue = (5)

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/driedcroaker.xml"

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"

	inst:AddComponent("bait")
	
	inst:AddComponent("tradable")
	inst:AddTag("cattoy")
	inst.components.tradable.goldvalue = 1
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = 20
    
    return inst
end

STRINGS.NAMES.DRIEDCROAKER = "Salt-dried Croaker"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DRIEDCROAKER = "Many salt and dried fish."

return Prefab( "common/inventory/driedcroaker", fn, assets )