local assets=
{
    Asset("ANIM", "anim/handfan.zip"),
    Asset("ANIM", "anim/swap_handfan.zip"),
    Asset("ATLAS", "images/inventoryimages/handfan.xml"),
}

local prefabs = {}

local function onperish(inst)			
inst:Remove()
end

local function onattack(inst, attacker, target)

if math.random() < 1 and target.components.burnable and target.sg and not target.sg:HasStateTag("frozen") and not target:HasTag("wall") and not target:HasTag("structure") and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
        target.components.burnable:Ignite()
end
if target.components.burnable and target.components.burnable:IsBurning() then
        target.components.burnable:Extinguish()
end
if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
end
if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
end
if target.components.freezable then
        target.components.freezable:AddColdness(-1)
		
if target.components.freezable:IsFrozen() then
        target.components.freezable:Unfreeze()            
end
end
end

local function OnEquip(inst, owner)
        inst.fire = SpawnPrefab( "foxlight_red" )
        local follower = inst.fire.entity:AddFollower()
        follower:FollowSymbol( owner.GUID, "swap_object", 0, -100, 1 )
			
		owner.AnimState:OverrideSymbol("swap_object", "", "")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
		inst.components.fueled:StartConsuming()
end
 
local function OnUnequip(inst, owner)
        inst.fire:Remove()
        inst.fire = nil
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
		inst.components.fueled:StopConsuming()
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
	
    MakeInventoryPhysics(inst)
	
    anim:SetBank("handfan")
    anim:SetBuild("handfan")
    anim:PlayAnimation("idle")
	
    inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(0)
	inst.components.weapon:SetRange(4, 10)
	inst.components.weapon:SetOnAttack(onattack)
	inst.components.weapon:SetProjectile("fire_projectile")
	inst:AddTag("sharp")
 
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/handfan.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst:AddComponent("fueled")
    --inst.components.fueled.fueltype = "USAGE"
    inst.components.fueled:SetDepletedFn(onperish)
	
	inst.components.fueled:InitializeFuelLevel(TUNING.TOTAL_DAY_TIME/2) 
 
    return inst
end

STRINGS.NAMES.FOXBEAD_RED = "Hand Fan"
STRINGS.RECIPE_DESC.FOXBEAD_RED = "Round Fan for Children."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FOXBEAD_RED = "What? I'm not a child!"

return  Prefab("common/inventory/foxbead_red", fn, assets)