local assets=
{
    Asset("ANIM", "anim/handfan.zip"),
    Asset("ANIM", "anim/swap_handfan.zip"),
    Asset("ATLAS", "images/inventoryimages/handfan.xml"),
}

local prefabs = {}

local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_handfan", "swap_handfan")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
		owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
end
 
local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
	
    MakeInventoryPhysics(inst)
    
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("handfan.tex")
	
    anim:SetBank("handfan")
    anim:SetBuild("handfan")
    anim:PlayAnimation("idle")
	
    inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(30)
	inst:AddTag("sharp")
	inst:AddTag("handfan")
 
    inst:AddComponent("inspectable")
	
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/handfan.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
    inst:AddComponent("talker")
    --inst.components.talker.ontalk = ontalk

    inst.components.talker.fontsize = 26
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(.9, .4, .4, 1)
    inst.components.talker.offset = Vector3(0,0,0)
    inst.components.talker.symbol = "swap_object"

	if GetPlayer().prefab == "wharang" then
	
    inst:AddComponent("sentientfan")
    
    inst:ListenForEvent("donetalking", function() inst.SoundEmitter:KillSound("talk") end)
    inst:ListenForEvent("ontalk", function() 
		if inst.components.sentientfan.sound_override then
			inst.SoundEmitter:KillSound("talk")
			inst.SoundEmitter:PlaySound(inst.components.sentientfan.sound_override, "special")
		else
			if not inst.SoundEmitter:PlayingSound("special") then
				inst.SoundEmitter:PlaySound("wharangfan/fan/fan_LP", "talk")
			end
		end
	end)
	end
 
    return inst
end

STRINGS.NAMES.HANDFAN = "Hand Fan"
STRINGS.RECIPE_DESC.HANDFAN = "Round Fan for Children."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HANDFAN = "This fan is my only friend!"

return  Prefab("common/inventory/handfan", fn, assets)