local assets=
{ 
    Asset("ANIM", "anim/sakurahat.zip"),
    Asset("ANIM", "anim/swap_sakurahat.zip"), 
    Asset("ATLAS", "images/inventoryimages/sakurahat.xml"),
}

local prefabs =
{
    "petals",
}  

local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_hat", "swap_sakurahat", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst:AddTag("hat")
	
    anim:SetBank("sakurahat")
    anim:SetBuild("sakurahat")
    anim:PlayAnimation("idle")
	
	inst:AddTag("irreplaceable")
	inst:AddComponent("inspectable")
	
	inst:AddComponent("tradable")
	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sakurahat.xml"

    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.DAPPERNESS_MED
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable.insulation = 30
	inst.components.equippable.dapperness = 5/60
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
    --inst:AddComponent("armor")
    --inst.components.armor:InitCondition(100, .1)
	--inst.components.armor.SetCondition = function () end

	inst:AddTag("show_spoilage")
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "petals"
	--[[
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.35)
	else
end
]]
    return inst
end

STRINGS.NAMES.SAKURAHAT = "Cherry Blossom Hairpin"
STRINGS.RECIPE_DESC.SAKURAHAT = "Cherry Blossom Garland."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SAKURAHAT = "Oh, I love the cherry blossom."

return Prefab( "common/inventory/sakurahat", fn, assets ) 