/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.net.DownloadEngine;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MemoryCache {
    private static Map loadedResource;
    protected static ReferenceQueue refQueue;
    static Thread cleanupThread;

    static synchronized void reset() {
        loadedResource.clear();
    }

    public static Object addLoadedResource(String string, Object object) {
        LoadedResourceReference loadedResourceReference;
        LoadedResourceReference loadedResourceReference2 = new LoadedResourceReference(object);
        if (!(object instanceof CacheEntry)) {
            loadedResourceReference2.registerReference(new CachedResourceReference(object, refQueue, string));
        }
        if ((loadedResourceReference = loadedResource.put(string.toString(), loadedResourceReference2)) != null) {
            return loadedResourceReference.get();
        }
        return null;
    }

    public static Object getLoadedResource(String string) {
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
        if (loadedResourceReference == null) {
            return null;
        }
        Object object = loadedResourceReference.get();
        if (object != null) {
            MemoryCache.addResourceReference(object, string);
        }
        return object;
    }

    public static Object removeLoadedResource(String string) {
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.remove(string);
        return loadedResourceReference == null ? null : loadedResourceReference.get();
    }

    public static void clearLoadedResources() {
        loadedResource.clear();
        DownloadEngine.clearUpdateCheckDoneList();
        DownloadEngine.clearNoCacheJarFileList();
    }

    static void addResourceReference(Object object, String string) {
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
        if (loadedResourceReference != null) {
            loadedResourceReference.registerReference(new CachedResourceReference(object, refQueue, string));
        }
    }

    static boolean contains(String string) {
        return loadedResource.containsKey(string);
    }

    static {
        refQueue = new ReferenceQueue();
        loadedResource = new HashMap();
        cleanupThread = new LoadedResourceCleanupThread("CacheMemoryCleanUpThread");
        cleanupThread.start();
    }

    protected static class CachedResourceReference
    extends WeakReference {
        String url;

        public CachedResourceReference(Object object, ReferenceQueue referenceQueue, String string) {
            super(object, referenceQueue);
            this.url = string;
        }

        public String getURL() {
            return this.url;
        }
    }

    static class LoadedResourceCleanupThread
    extends Thread {
        LoadedResourceCleanupThread(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CachedResourceReference cachedResourceReference = (CachedResourceReference)refQueue.remove();
                        Map map = loadedResource;
                        synchronized (map) {
                            String string = cachedResourceReference.getURL();
                            LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
                            if (loadedResourceReference != null && loadedResourceReference.deregisterReference(cachedResourceReference)) {
                                MemoryCache.removeLoadedResource(string);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    protected static class LoadedResourceReference {
        private Set resourceRefs = new HashSet();
        private int refcnt = 0;
        Object o;

        LoadedResourceReference(Object object) {
            this.o = object;
        }

        Object get() {
            return this.o;
        }

        synchronized void registerReference(Reference reference) {
            this.resourceRefs.add(reference);
            ++this.refcnt;
        }

        synchronized boolean deregisterReference(Reference reference) {
            --this.refcnt;
            this.resourceRefs.remove(reference);
            return this.refcnt == 0;
        }
    }
}

