/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.awt.AWTSecurityManager;
import sun.awt.AppContext;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.security.util.SecurityConstants;

public class Applet2SecurityManager
extends AWTSecurityManager {
    private AppContext mainAppContext;
    private static Field facc = null;
    private static Field fcontext = null;
    private HashSet restrictedPackages = new HashSet();
    private boolean inThreadGroupCheck = false;

    public Applet2SecurityManager() {
        this.reset();
        this.mainAppContext = AppContext.getAppContext();
    }

    public void reset() {
        this.restrictedPackages.clear();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.startsWith("package.restrict.access.") || (string = System.getProperty(string2)) == null || !string.equalsIgnoreCase("true")) continue;
                    String string3 = string2.substring(24);
                    Applet2SecurityManager.this.restrictedPackages.add(string3);
                }
                return null;
            }
        });
    }

    private Plugin2ClassLoader currentAppletClassLoader() {
        int n;
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null || classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)classLoader;
        }
        Class[] classArray = this.getClassContext();
        for (n = 0; n < classArray.length; ++n) {
            classLoader = classArray[n].getClassLoader();
            if (!(classLoader instanceof Plugin2ClassLoader)) continue;
            return (Plugin2ClassLoader)classLoader;
        }
        for (n = 0; n < classArray.length; ++n) {
            final ClassLoader classLoader2 = classArray[n].getClassLoader();
            if (!(classLoader2 instanceof URLClassLoader) || (classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessControlContext accessControlContext = null;
                    ProtectionDomain[] protectionDomainArray = null;
                    try {
                        accessControlContext = (AccessControlContext)facc.get(classLoader2);
                        if (accessControlContext == null) {
                            return null;
                        }
                        protectionDomainArray = (ProtectionDomain[])fcontext.get(accessControlContext);
                        if (protectionDomainArray == null) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        throw new UnsupportedOperationException(exception);
                    }
                    for (int i = 0; i < protectionDomainArray.length; ++i) {
                        ClassLoader classLoader = protectionDomainArray[i].getClassLoader();
                        if (!(classLoader instanceof Plugin2ClassLoader)) continue;
                        return classLoader;
                    }
                    return null;
                }
            })) == null) continue;
            return (Plugin2ClassLoader)classLoader;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)classLoader;
        }
        return null;
    }

    protected boolean inThreadGroup(ThreadGroup threadGroup) {
        if (this.currentAppletClassLoader() == null) {
            return false;
        }
        return this.getThreadGroup().parentOf(threadGroup);
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    public void checkAccess(Thread thread) {
        if (!Applet2SecurityManager.isThreadTerminated(thread) && !this.inThreadGroup(thread)) {
            this.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    private static boolean isThreadTerminated(Thread thread) {
        try {
            return thread.getState() == Thread.State.TERMINATED;
        }
        catch (Throwable throwable) {
            return !thread.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(ThreadGroup threadGroup) {
        if (this.inThreadGroupCheck) {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                this.inThreadGroupCheck = true;
                if (!this.inThreadGroup(threadGroup)) {
                    this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
                Object var3_2 = null;
                this.inThreadGroupCheck = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.inThreadGroupCheck = false;
                throw throwable;
            }
        }
    }

    public void checkPackageAccess(String string) {
        super.checkPackageAccess(string);
        Iterator iterator = this.restrictedPackages.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            this.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    public void checkAwtEventQueueAccess() {
        try {
            AppContext appContext = AppContext.getAppContext();
            Plugin2ClassLoader plugin2ClassLoader = this.currentAppletClassLoader();
            if (appContext == this.mainAppContext && plugin2ClassLoader != null) {
                super.checkAwtEventQueueAccess();
            }
            return;
        }
        catch (SecurityException securityException) {
            this.checkSecurityAccess("accessEventQueue");
            return;
        }
    }

    public void checkSecurityAccess(String string) {
        if (string != null && string.equals("java")) {
            return;
        }
        super.checkSecurityAccess(string);
    }

    public ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup;
        Plugin2ClassLoader plugin2ClassLoader = this.currentAppletClassLoader();
        ThreadGroup threadGroup2 = threadGroup = plugin2ClassLoader == null ? null : plugin2ClassLoader.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup;
        }
        return super.getThreadGroup();
    }

    public AppContext getAppContext() {
        Plugin2ClassLoader plugin2ClassLoader = this.currentAppletClassLoader();
        if (plugin2ClassLoader == null) {
            return null;
        }
        AppContext appContext = plugin2ClassLoader.getAppContext();
        if (appContext == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return appContext;
    }

    public void checkPrintJobAccess() {
        try {
            super.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            new CheckPrint_1_2();
            return;
        }
    }

    void showPrintDialog() {
        AppContext appContext = AppContext.getAppContext();
        String string = ResourceManager.getString((String)"plugin.print.title");
        String string2 = ResourceManager.getString((String)"plugin.print.message");
        String string3 = ResourceManager.getString((String)"plugin.print.always");
        String string4 = (String)appContext.get("sun.plugin.security.printDialog");
        int n = 0;
        if (!Trace.isAutomationEnabled() && string4 == null) {
            n = UIFactory.showApiDialog(null, null, (String)string, (String)string2, null, null, (String)string3, (boolean)false);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            n = 0;
        }
        if (n == 2) {
            appContext.put("sun.plugin.security.printDialog", "skip");
        } else if (n != 0) {
            throw new SecurityException("checkPrintJobAccess");
        }
    }

    public void checkConnect(String string, int n) {
        if (CrossDomainXML.quickCheck((String)string)) {
            return;
        }
        try {
            super.checkConnect(string, n);
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((String)string)) {
                return;
            }
            throw securityException;
        }
    }

    public void checkConnect(String string, int n, Object object) {
        if (CrossDomainXML.quickCheck((String)string)) {
            return;
        }
        try {
            super.checkConnect(string, n, object);
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((String)string)) {
                return;
            }
            throw securityException;
        }
    }

    static {
        try {
            facc = URLClassLoader.class.getDeclaredField("acc");
            facc.setAccessible(true);
            fcontext = AccessControlContext.class.getDeclaredField("context");
            fcontext.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new UnsupportedOperationException(noSuchFieldException);
        }
    }

    private class CheckPrint_1_2
    implements PrivilegedAction {
        CheckPrint_1_2() {
            AccessController.doPrivileged(this);
        }

        public Object run() {
            Applet2SecurityManager.this.showPrintDialog();
            return null;
        }
    }
}

