PrefabFiles = {
	"sunny",
    "sunnyhat",
    "sunnyweapon",
    "sunnybackpack",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/sunny.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/sunny.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/sunny.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/sunny.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/sunny_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/sunny_silho.xml" ),

    Asset( "IMAGE", "bigportraits/sunny.tex" ),
    Asset( "ATLAS", "bigportraits/sunny.xml" ),
	
	Asset( "IMAGE", "images/map_icons/sunny.tex" ),
	Asset( "ATLAS", "images/map_icons/sunny.xml" ),

    Asset( "IMAGE", "images/inventoryimages/sunnyhat.tex" ),
    Asset( "ATLAS", "images/inventoryimages/sunnyhat.xml" ),

    Asset( "IMAGE", "images/inventoryimages/sunnyweapon.tex" ),
    Asset( "ATLAS", "images/inventoryimages/sunnyweapon.xml" ),

    Asset( "IMAGE", "images/inventoryimages/sunnybackpack.tex" ),
    Asset( "ATLAS", "images/inventoryimages/sunnybackpack.xml" ),

}

local require = GLOBAL.require

-- The character select screen lines
GLOBAL.STRINGS.CHARACTER_TITLES.sunny = "Sunny"
GLOBAL.STRINGS.CHARACTER_NAMES.sunny = "Sunny"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.sunny = "*Stronger with sunshine\n*Picky eater\n*Fight to upgrade"
GLOBAL.STRINGS.CHARACTER_QUOTES.sunny = "\"Sunny streaming @ douyutv.com\""

GLOBAL.STRINGS.NAMES.SUNNYHAT = "Sunny's hair hoop"
GLOBAL.STRINGS.RECIPE_DESC.SUNNYHAT = "Wow, so cute!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUNNYHAT = "Special hair hoop"

GLOBAL.STRINGS.NAMES.SUNNYBACKPACK = "Sunny's backpack"
GLOBAL.STRINGS.RECIPE_DESC.SUNNYBACKPACK = "Bling bling"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUNNYBACKPACK = "It is shining!"

GLOBAL.STRINGS.NAMES.SUNNYWEAPON = "Sunny's weapon"
GLOBAL.STRINGS.RECIPE_DESC.SUNNYWEAPON = "mua mua"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUNNYWEAPON = "Lovely bat"

-- Custom speech strings
GLOBAL.STRINGS.CHARACTERS.ESCTEMPLATE = require "speech_sunny"

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "sunny")

function AddMap(inst)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( inst.prefab .. ".tex" )
end
AddPrefabPostInit("sunnyweapon", AddMap)
AddMinimapAtlas("images/inventoryimages/sunnyweapon.xml")
AddPrefabPostInit("sunnyhat", AddMap)
AddMinimapAtlas("images/inventoryimages/sunnyhat.xml")
AddPrefabPostInit("sunnybackpack", AddMap)
AddMinimapAtlas("images/inventoryimages/sunnybackpack.xml")

AddMinimapAtlas("images/map_icons/sunny.xml")
AddModCharacter("sunny")

