local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/sunny.zip" ),
}
local prefabs = {}
local start_inv = {
    -- Custom starting items
    --"sunnyhat",
}

--upgrade function
--level up

local max_upgrades = 10
local function applyupgrades(inst)

    local upgrades = math.min(inst.level, max_upgrades)

    --local hunger_percent = inst.components.hunger:GetPercent()
    local health_percent = inst.components.health:GetPercent()
    local sanity_percent = inst.components.sanity:GetPercent()

    inst.components.hunger.max = math.ceil (100 + upgrades * 5)
    inst.components.sanity.max = math.ceil (100 + upgrades * 10)
    inst.components.health.maxhealth = math.ceil (100 + upgrades * 10)
    --inst.components.talker:Say("current speed : ".. (inst.components.locomotor.walkspeed))
    inst.components.talker:Say("current level : ".. (inst.level))
    
    if inst.level > 9 then
        inst.components.talker:Say("Level Max!")
    end

    --inst.components.hunger:SetPercent(hunger_percent)
    inst.components.health:SetPercent(health_percent)
    inst.components.sanity:SetPercent(sanity_percent)
end

---
local normalchance = 0.01
local largechance = 0.05

local function onkill(inst, data)

    local iflevelup = false
    if data.cause == inst.prefab and not data.inst:HasTag("companion") then
        if math.random() < normalchance and data.inst:HasTag("prey") then
            iflevelup = true
        elseif math.random() < largechance and not data.inst:HasTag("prey") and not data.inst:HasTag("eyeplant") and not data.inst:HasTag("insect") then
            iflevelup = true
        end
    end

    if iflevelup and inst.level < max_upgrades then
        inst.level = inst.level + 1
        applyupgrades(inst) 
        inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")

        --icon pulse while upgrading
        inst.HUD.controls.status.heart:PulseGreen()
        inst.HUD.controls.status.stomach:PulseGreen()
        inst.HUD.controls.status.brain:PulseGreen()
            
        inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
    end
end

local function onpreload(inst, data)
    if data then
        if data.level then
            inst.level = data.level
            applyupgrades(inst)
            --re-set these from the save data, because of load-order clipping issues
            if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
            if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
            if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
            inst.components.health:DoDelta(0)
            inst.components.hunger:DoDelta(0)
            inst.components.sanity:DoDelta(0)
        end
    end
end

local function onsave(inst, data)
    data.level = inst.level
end

---

local function onhungerchange(inst, data)

    if inst.components.hunger.current <= inst.components.hunger.max * 0.3 then
        inst.damage_hunger_mult = 0.5
    elseif inst.components.hunger.current <= inst.components.hunger.max * 0.7 then
        inst.damage_hunger_mult = 1
    else
        inst.damage_hunger_mult = 1.5
    end

    inst.components.combat.damagemultiplier = inst.damage_hunger_mult * inst.damage_time_mult

end

local function updatestats(inst)
    if GetClock():IsDay() and not GetWorld():IsCave() then
        inst.damage_time_mult = 1.2
        inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED * 1.2
        inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 1.2
    elseif GetClock():IsDusk() and not GetWorld():IsCave() then
        inst.damage_time_mult = 1
        inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
        inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
    elseif GetClock():IsNight() and not GetWorld():IsCave() then
        inst.damage_time_mult = 0.75
        inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED * 0.9
        inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 0.9
    end

    if GetWorld():IsCave() then
        --inst.components.health:StartRegen(0, 0)
        inst.damage_time_mult = 0.75
        inst.components.locomotor.walkspeed = TUNING.WILSON_RUN_SPEED * 0.9
        inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 0.9
        --TUNING.SANITY_NIGHT_LIGHT = -5/60
        --TUNING.SANITY_NIGHT_MID = -5/60
        --TUNING.SANITY_NIGHT_DARK = -5/60        
    end

    inst.components.combat.damagemultiplier = inst.damage_hunger_mult * inst.damage_time_mult
end


local function sanityfn(inst)
    local delta = 0
    if GetSeasonManager() and GetSeasonManager():IsRaining() then
        delta = delta - 5/60
        --inst.components.talker:Say("I don't like rain!")
    end 
    return delta
end

local function oneat(inst, food)
    if food then
        if food.components.edible.foodtype == "MEAT" then
            inst.components.sanity:DoDelta(5)
        else
            inst.components.sanity:DoDelta(-3)
        end
    end
end

local fn = function(inst)
    
    -- choose which sounds this character will play
    inst.soundsname = "willow"

    -- Minimap icon
    inst.MiniMapEntity:SetIcon( "sunny.tex" )
    
    -- Stats    
    inst.level = 0
    applyupgrades(inst)

    inst.damage_hunger_mult = 1
    inst.damage_time_mult = 1
    
    -- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
    
    -- Hunger rate (optional)
    inst.components.hunger.hungerrate = 1.25 * TUNING.WILSON_HUNGER_RATE

    -- sanity gain at day time
    TUNING.SANITY_DAY_GAIN = 3/60

    -- Sanity decrease
    inst.components.sanity.night_drain_mult = 1.2
    --inst.components.sanity.dusk_drain_mult = 1.2
    inst.components.sanity.neg_aura_mult = 1.1

    --Sanity decrease when raining
    inst.components.sanity.custom_rate_fn = sanityfn

    -- be afraid of cold
    inst.components.temperature.hurtrate = TUNING.WILSON_HEALTH / TUNING.FREEZING_KILL_TIME * 1.25
    --inst.components.temperature.inherentinsulation = -5
    
    -- Movement speed (optional)
    inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED

    inst.OnSave = onsave
    inst.OnPreLoad = onpreload

    -- lower profit from non-meat food
    inst.components.eater:SetOnEatFn(oneat)

    inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())

    inst:ListenForEvent("hungerdelta", onhungerchange)

    inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
    inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())

    updatestats(inst)

    local sunnyweapon = Recipe("sunnyweapon", {Ingredient("carrot", 4), Ingredient("lightbulb", 4), Ingredient("tentaclespike", 1)}, RECIPETABS.WAR, {SCIENCE = 1})
	sunnyweapon.atlas = "images/inventoryimages/sunnyweapon.xml"
	sunnyweapon.sortkey = 1
	local sunnybackpack = Recipe("sunnybackpack", {Ingredient("manrabbit_tail", 10), Ingredient("purplegem",5), Ingredient("wormlight", 5)}, RECIPETABS.SURVIVAL, {SCIENCE = 2})
	sunnybackpack.atlas = "images/inventoryimages/sunnybackpack.xml"
	sunnybackpack.sortkey = 1
	local sunnyhat = Recipe("sunnyhat", {Ingredient("petals", 5), Ingredient("silk", 2), Ingredient("cutgrass", 5)}, RECIPETABS.DRESS, {SCIENCE = 0})
	sunnyhat.atlas = "images/inventoryimages/sunnyhat.xml"
	sunnyhat.sortkey = 1

end

return MakePlayerCharacter("sunny", prefabs, assets, fn, start_inv)
