local assets=
{
	Asset("ANIM", "anim/sunnyhat.zip"),
	Asset("IMAGE", "images/inventoryimages/sunnyhat.tex"),
	Asset("ATLAS", "images/inventoryimages/sunnyhat.xml"),
}

--[[
local function onusehat(inst)
    local owner = inst.components.inventoryitem.owner
    if owner then
        owner.sg:GoToState("hide")
    end
end
--]]

--[[
local function stopusinghat(inst, data)
        local hat = inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if hat and not (data.statename == "hide_idle" or data.statename == "hide") then
            hat.components.useableitem:StopUsingItem()
        end
end
--]]

--[[
local function ShouldAcceptItem(inst, item)
	if GetPlayer().components.inventory:Has("goldnugget", 5) then
		if item.prefab == "goldnugget" then
			return true
		end
	end
		return false
end

local function OnGetItemFromPlayer(inst, giver, item)
	if item.prefab == "goldnugget" then
    giver.components.inventory:ConsumeByName("goldnugget", 4)
	end
	local player = GetPlayer()
	player.components.talker:Say("Everyone in my hat ! ! ! !", 4, false) 
    SpawnPrefab("book_fx").Transform:SetPosition(player.Transform:GetWorldPosition())
	local pos = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 15)
	for k,v in pairs(ents) do
		if v.components.pickable and v.prefab ~= "flower" then
			v.components.pickable:Pick(GetPlayer())
		end
		if v.components.crop then
			v.components.crop:Harvest(GetPlayer())
		end
	end
end
--]]

local function onequiphat(inst, owner)
    owner.AnimState:OverrideSymbol("swap_hat", "sunnyhat", "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")
        
    if owner:HasTag("player") then
        owner.AnimState:Hide("HEAD")
        owner.AnimState:Show("HEAD_HAIR")
    end

	if inst.components.fueled then
		inst.components.fueled:StartConsuming()        
	end
	
	--[[
	inst.damagefn = function(attacked, data)
		SpawnPrefab("collapse_big").Transform:SetPosition(owner.Transform:GetWorldPosition())
		if data and data.attacker and data.attacker.components.health then
			data.attacker.components.health:DoDelta(-34)
		end 
	end
	--]]
	--inst:ListenForEvent("attacked", inst.damagefn, owner)
    --inst:ListenForEvent("newstate", stopusinghat, owner) 
end

local function onunequiphat(inst, owner)
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")
	
    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAIR")
    end

	if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	end
	
	--GetPlayer().components.health.absorb = 0
	--inst:RemoveEventCallback("attacked", inst.damagefn, owner)
    --inst:RemoveEventCallback("newstate", stopusinghat, owner)
end

local function onfinished(inst)
    inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("spiderhat")
    anim:SetBuild("sunnyhat")
    anim:PlayAnimation("anim")
    
    inst:AddTag("sharp")
	inst:AddTag("hat")
	inst:AddTag("hide")
    
	--inst:AddComponent("waterproofer")
    --inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_LARGE)
	
	--inst:AddComponent("useableitem")
    --inst.components.useableitem:SetOnUseFn(onusehat)
	
    inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/sunnyhat.xml"
	--inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/bushhat"
    
    inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequiphat )
    inst.components.equippable:SetOnUnequip( onunequiphat )

   	--inst:AddComponent("dapperness")
    inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED

    --cold resistance
    --inst:AddComponent("insulator")
    --inst.components.insulator.insulation = TUNING.INSULATION_MED

    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "USAGE"
    inst.components.fueled:InitializeFuelLevel(TUNING.TOTAL_DAY_TIME * 5)
    inst.components.fueled:SetDepletedFn(onfinished)
	
	--inst:AddComponent("trader")
    --inst.components.trader.onaccept = OnGetItemFromPlayer
    --inst.components.trader:SetAcceptTest(ShouldAcceptItem)
	
    return inst
end

return Prefab( "common/inventory/sunnyhat", fn, assets, prefabs) 