local assets=
{
	Asset("ANIM", "anim/sunnyweapon.zip"),
	Asset("ANIM", "anim/swap_sunnyweapon.zip"),
	Asset("IMAGE", "images/inventoryimages/sunnyweapon.tex"),
	Asset("ATLAS", "images/inventoryimages/sunnyweapon.xml"),
}

local function onfinished(inst)
    inst:Remove()
end

local function onattack(inst, owner, target)
    local summonchance = 0.03
    if math.random() < summonchance then 
        local pt = target:GetPosition()
        local st_pt =  FindWalkableOffset(pt or owner:GetPosition(), math.random()*2*PI, 2, 3)
        local ores = {"rabbit"}
        local ore = ores[math.random(#ores)]
        if st_pt then
            st_pt = st_pt + pt
            local st1 = SpawnPrefab(ore)
            local st2 = SpawnPrefab("collapse_small")
            st1.Transform:SetPosition(st_pt.x, st_pt.y, st_pt.z)
            st2.Transform:SetPosition(pt.x, pt.y, pt.z)
        end
    end
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_sunnyweapon", "swap_sunnyweapon")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("sunnyweapon")
    anim:SetBuild("sunnyweapon")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(45)
    inst.components.weapon:SetRange(2)
    inst.components.weapon.onattack = onattack
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sunnyweapon.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
    
    return inst
end

return Prefab( "common/inventory/sunnyweapon", fn, assets, prefabs) 