
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/qiuhaizi.zip" ),
        Asset( "ANIM", "anim/ghost_qiuhaizi_build.zip" ),
		Asset("SOUNDPACKAGE", "sound/qiuqiu.fev"),
	    Asset("SOUND", "sound/qiuqiu.fsb"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
"bangbangtang"
}

local function applyupgrades(inst)
	local max_upgrades = 99999999999999997000
	local upgrades = math.min(inst.level, max_upgrades)
	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()
    local currentscale = inst.Transform:GetScale()
if inst.level  then
	inst.components.health.maxhealth = math.ceil (100 +(inst.level)*2.5)
	inst.components.sanity.max = math.ceil (150+1.875*(inst.level))
	inst.components.combat.damagemultiplier=0.75+(inst.level)*0.015
	inst.components.hunger.max =math.ceil (150+(inst.level)*2.5)
end
	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
end
----采集农作物
local function HearPanFlute(inst)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 30)
	local num=0
    for k,v in pairs(ents) do
        if v.components.pickable and v.prefab ~= "flower"  then
           v.components.pickable:Pick(inst)
            num=num+1
        end
        if v.components.crop then
           v.components.crop:Harvest(inst)
		   num=num+1
        end    
    end
	if num>=30 then
	inst.SoundEmitter:PlaySound("qiuqiu/shouji/shouji")
	end
	num=0
	--inst.SoundEmitter:PlaySound("dontstarve/common/staff_dissassemble")
end

local function oneat(inst, food)
	
	if food and food.components.edible and math.random() < .45-inst.level*0.005 and inst.level < 80 then
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.components.talker:Say("LV：".. (inst.level))
	elseif food and  inst.level == 80 then
	inst.components.talker:Say("MAX!")
	end
    if  food and food.prefab == "bonestew"  and inst.level>=25 then--
    HearPanFlute(inst)
    end

end
--掉落园艺书
local function onkilledother(inst, data)
	local victim = data.victim
		if victim.components.freezable or victim:HasTag("monster") then
		if math.random() < 0.01 then
			if victim.components.lootdropper then
				victim.components.lootdropper:SpawnLootPrefab("book_gardening")
			end
		end 
	end 
end


local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end

end

local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end
-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6

end


-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst:AddTag("qiuhaizi")
	inst.MiniMapEntity:SetIcon( "qiuhaizi.tex" )
	inst.transformed = false 
	inst:AddComponent("keyhandler")
    inst.components.keyhandler:AddActionListener("qiuhaizi", TUNING.qiuhaizi.KEYTHREE, "IRIS")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	inst:AddComponent("reader")
	inst:AddTag("qiuhaizi")
	inst:AddTag("player")
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	inst.Transform:SetScale(1.5,1.5,1.5)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 0.75
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 0.25
	inst.level = 0
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	inst:ListenForEvent("death", function(inst) inst.transformed = not inst.transformed end)
		-- 增加击杀掉落
	inst:ListenForEvent("killed", onkilledother)
	 inst:ListenForEvent("attacked",function()
	 if math.random()<0.02 then
     inst.SoundEmitter:PlaySound("qiuqiu/zhandou/zhandou1")
	 end
    end)
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("qiuhaizi", prefabs, assets, common_postinit, master_postinit, start_inv)
