
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua")
}
local prefabs = {
        "genos_ghost_flower"
}

local start_inv = {
	-- Custom starting items
	"genos_ghost_flower"
}


local function updatestats(inst)

	if TheWorld.state.phase == "day" then
	

		inst.components.locomotor.walkspeed = (8)
		inst.components.locomotor.runspeed = (12)

		inst.components.sanity.dapperness = (TUNING.DAPPERNESS_SMALL * 1.25)
		
		inst.components.combat.damagemultiplier = 1.2
		
	   -- DAPPERNESS_TINY = 100/(day_time*15),
       -- DAPPERNESS_SMALL = 100/(day_time*10),
       -- DAPPERNESS_MED = 100/(day_time*6),
       -- DAPPERNESS_LARGE = 100/(day_time*3),
       -- DAPPERNESS_HUGE = 100/(day_time),
	   -- daytime is 300
	   
	elseif TheWorld.state.phase == "dusk" then

		inst.components.locomotor.walkspeed = (7)
		inst.components.locomotor.runspeed = (11)
		
		inst.components.sanity.dapperness = (TUNING.DAPPERNESS_SMALL * -0.5)
		
		inst.components.combat.damagemultiplier = 1.2
		


	elseif TheWorld.state.phase == "night" then

		inst.components.locomotor.walkspeed = (6)
		inst.components.locomotor.runspeed = (10)
		

		inst.components.combat.damagemultiplier = 1.2
		
    elseif tempCaveVar == true then
		
		inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 2.75)
		inst.components.locomotor.runspeed = (TUNING.WILSON_WALK_SPEED * 3.5)
		
		inst.components.sanity.dapperness = (TUNING.DAPPERNESS_SMALL * -1.5)
		
		inst.components.combat.damagemultiplier = 1
		

			
	end


end

local function hungerdelta(inst)
  if inst.components.hunger.current >= 100 then
  inst.components.sanity.dapperness = (         TUNING.DAPPERNESS_MED * 0.5 )
  elseif inst.components.hunger.current < 100 then
        inst.components.sanity.dapperness = (         TUNING.DAPPERNESS_MED * -1.2 )
  elseif inst.components.hunger.current < 50 then
        inst.components.sanity.dapperness = (         TUNING.DAPPERNESS_MED * -1.5) 
  elseif inst.components.hunger.current < 30 then
         inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -2)

     end
end



-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "saitama.tex" )
        inst:AddTag("saitama")
end

local function fn()
	inst:AddComponent("sanityaura")
	inst.components.sanityaura.aura = TUNING.SANITYAURA_LARGE

end


local function OnDespawn(inst)
    if inst.genos_ghost ~= nil then
        inst.genos_ghost.components.lootdropper:SetLoot(nil)
        inst.genos_ghost.components.health:SetInvincible(true)
        inst.genos_ghost:PushEvent("death")
        --in case the state graph got interrupted somehow, just force
        --removal after the dissipate animation should've finished
        inst.genos_ghost:DoTaskInTime(25 * FRAMES, inst.genos_ghost.Remove)
    end
end
 
local function OnSave(inst, data)
    if inst.genos_ghost ~= nil then
        data.genos_ghost = inst.genos_ghost:GetSaveRecord()
    end
end
 
local function OnLoad(inst, data)
    if data.genos_ghost ~= nil and inst.genos_ghost == nil then
        local genos_ghost = SpawnSaveRecord(data.genos_ghost)
        if genos_ghost ~= nil then
           genos_ghost.SoundEmitter:PlaySound("dontstarve/common/ghost_spawn")
            genos_ghost:LinkToPlayer(inst)
        end
    end
end


-- This initializes for the host only
local master_postinit = function(inst)
        inst:AddComponent("sanityaura")
	inst.components.sanityaura.aura = TUNING.SANITYAURA_LARGE
	-- choose which sounds this character will play
	inst.soundsname = "wilson"
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(200)
	inst.components.health.fire_damage_scale = 0
        inst:ListenForEvent("hungerdelta", hungerdelta)
	
        inst.components.grue:AddImmunity()
       
	inst.components.temperature.inherentinsulation = TUNING.INSULATION_MED

	inst.ghostbuild = "ghost_saitama_build"
        
        
        inst:AddComponent("reader")	
    inst.genos_ghost = nil
    inst.genos_ghost_flowers = {}
 
    inst.OnDespawn = OnDespawn
    inst.OnSave = OnSave
    inst.OnLoad = OnLoad
		
	-- Damage multiplier (optional)
	inst.components.combat:SetDefaultDamage(9999999999*9)
	inst.components.combat:SetAttackPeriod(0.5)
	
		inst.components.eater.Eat_orig = inst.components.eater.Eat
function inst.components.eater:Eat( food )
	if self:CanEat(food) then
		if food.components.edible.healthvalue < 0 then
		food.components.edible.healthvalue = 1
	end
end
return inst.components.eater:Eat_orig(food)
end

        inst:WatchWorldState( "startday", function(inst) updatestats(inst) end )
	inst:WatchWorldState( "startdusk", function(inst) updatestats(inst) end )
	inst:WatchWorldState( "startnight", function(inst) updatestats(inst) end )	
	updatestats(inst)
	return inst
	
end


return MakePlayerCharacter("saitama", prefabs, assets, common_postinit, master_postinit, start_inv, fn)
