using System;

using TaleWorlds.Core;
using TaleWorlds.MountAndBlade;
using TaleWorlds.CampaignSystem;
using TaleWorlds.CampaignSystem.Actions;
using TaleWorlds.CampaignSystem.GameMenus;
using TaleWorlds.ObjectSystem;
using TaleWorlds.Localization;

namespace keyRoyalArmoury
{
    public class Main : MBSubModuleBase
    {
        protected override void OnSubModuleLoad()
        {
            base.OnSubModuleLoad();
        }

        protected override void OnBeforeInitialModuleScreenSetAsRoot()
        {
            base.OnBeforeInitialModuleScreenSetAsRoot();
            InformationManager.DisplayMessage(new InformationMessage("key's Royal Armoury [v1.0]"));
        }

        protected override void OnGameStart(Game game, IGameStarter gameStarterObject)
        {
            if (!(game.GameType is Campaign))
                return;
            CampaignGameStarter gameInitializer = (CampaignGameStarter)gameStarterObject;

            gameInitializer.AddBehavior(new keyRoyalArmoury_Behaviour());
        }
    }

    public class keyRoyalArmoury_Behaviour : CampaignBehaviorBase
    {
        private void OnSessionLaunched(CampaignGameStarter campaignGameStarter)
        {
            campaignGameStarter.AddGameMenuOption("town_keep", "armoury", "Access The Royal Armoury", generic_access_on_condition, armory_on_consequence);

        }
        
        private bool generic_access_on_condition(MenuCallbackArgs args) 
        {
            
            args.optionLeaveType = GameMenuOption.LeaveType.Trade;
            return true;
        }

        private void armory_on_consequence(MenuCallbackArgs args)
        {
            Clan OwnerClan = Settlement.CurrentSettlement.OwnerClan;
            bool bShowEntryOption = true;

            string sDisplayMessageTitle = "", sDisplayMessageBody = "";
            float fMaxCostOfAdmissionGold = Math.Max(3000, Settlement.CurrentSettlement.Prosperity);

            float fMaxCostOfAdmissionInfluence = Math.Max(20, Settlement.CurrentSettlement.Prosperity / 100);

            float fCostOfAdmissionStepGold = fMaxCostOfAdmissionGold / 100;
            float fMaxCostOfAdmissionStepInfluence = fMaxCostOfAdmissionInfluence / 100;

            int iCostOfAdmissionGold = 0;
            int iCostOfAdmissionInfluence = 0;

            if (OwnerClan.Leader == Hero.MainHero && Clan.PlayerClan.Kingdom==null) // fix for main quest interregnum
            {
                sDisplayMessageTitle = "Welcome to The Armoury, sir!";
            }
            else
            if (OwnerClan.Kingdom == Clan.PlayerClan.Kingdom) 
            {
                if (Hero.MainHero == OwnerClan.Kingdom.Leader || OwnerClan.Leader == Hero.MainHero) 
                {
                    sDisplayMessageTitle = "Welcome to The Royal Armoury, sir!";
                }
                else
                {
                    if (Clan.PlayerClan.IsUnderMercenaryService)
                    {
                        iCostOfAdmissionGold = (int)(Math.Max(100 - (int)OwnerClan.Leader.GetRelationWithPlayer()*5, 0) * fCostOfAdmissionStepGold / 3);
                        iCostOfAdmissionGold -= iCostOfAdmissionGold % 100;
                        sDisplayMessageTitle = new TextObject("{=N06wk0dB}As a mercenary, accessing The Royal Armoury costs ") + iCostOfAdmissionGold.ToString() + " gold";
                    }
                    else
                    {
                        iCostOfAdmissionInfluence = (int)(Math.Max(100 - (int)OwnerClan.Leader.GetRelationWithPlayer(), 0) * fMaxCostOfAdmissionStepInfluence); ;
                        sDisplayMessageTitle = new TextObject("{=N06wk0dB}As a vassal, accessing The Royal Armoury costs ") + iCostOfAdmissionInfluence.ToString() + " influence";
                    }
                }

            }
            else
            {
                iCostOfAdmissionGold = (int)(Math.Max(100 - (int)OwnerClan.Leader.GetRelationWithPlayer(), 0) * fCostOfAdmissionStepGold);
                iCostOfAdmissionGold -= iCostOfAdmissionGold % 100;
                sDisplayMessageTitle = new TextObject("{=N06wk0dB}Accessing The Royal Armoury costs ") + iCostOfAdmissionGold.ToString() + " gold";
            }

            if (iCostOfAdmissionGold > 0 || iCostOfAdmissionInfluence>0) 
            {
                sDisplayMessageBody = "To lower the costs (gold or influence) improve your relations with " 
                    + OwnerClan.Leader.Name + " of clan " + OwnerClan.Name + " (currently at " + OwnerClan.Leader.GetRelationWithPlayer().ToString() 
                    + "). Further significant discounts are available to mercenaries, while as a vassal, you would pay with influence. Town prosperity affects the entry fee and selection variety. Ultimately, ruling the town grants free entry and unlimited selection. ";
            }
            if ((Hero.MainHero.Gold < iCostOfAdmissionGold && iCostOfAdmissionGold>0) || (Hero.MainHero.Clan.Influence < iCostOfAdmissionInfluence && iCostOfAdmissionInfluence>0))
            {
                bShowEntryOption = false;
            }

            InformationManager.ShowInquiry(
                new InquiryData(
                sDisplayMessageTitle,
                sDisplayMessageBody,
                bShowEntryOption, true,
                new TextObject("{=Y94H6XnK}Enter").ToString(),
                new TextObject("{=cOgmdp9e}Leave").ToString(),
                () =>
                {    
                    Hero.MainHero.ChangeHeroGold(-iCostOfAdmissionGold);
                    Hero.MainHero.Clan.Influence -= iCostOfAdmissionInfluence;

                    int iLowestValueItemInArmory = 10001;
                    float fLowestAppearanceItemInArmory = (float)1.1;

                    int iMaxProsperityForGuaranteedItem = 7000;

                    ItemRoster armoury = new ItemRoster();
                    Random random = new Random();

                    foreach (ItemObject item in ItemObject.All)
                    {
                        if (item.Culture == Settlement.CurrentSettlement.Culture && (item.Value >= iLowestValueItemInArmory || item.Appearance >= fLowestAppearanceItemInArmory))
                        {
                           if (iCostOfAdmissionGold == 0 && iCostOfAdmissionInfluence == 0) //If the entry is free, there's no point in limiting/randomizing the stock as it's not persistent anyway
                           {
                                armoury.AddToCounts(item, 99);
                            }
                           else
                           if (Settlement.CurrentSettlement.Prosperity >= random.Next(0,iMaxProsperityForGuaranteedItem))
                            {
                                armoury.AddToCounts(item, random.Next(1,4));
                            }
                        }
                    }

                    InventoryManager.OpenScreenAsTrade(armoury, Settlement.CurrentSettlement.Town);

                },
                null,
                    ""),
                true);
        
        }

        public override void RegisterEvents()
        {
            CampaignEvents.OnSessionLaunchedEvent.AddNonSerializedListener(this, new Action<CampaignGameStarter>(this.OnSessionLaunched));
        }
        public override void SyncData(IDataStore dataStore)
        {
        }
    }
}
