'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../hooks/index.js');
require('../../../utils/index.js');
var badge = require('./badge.js');
var pluginVue_exportHelper = require('../../../_virtual/plugin-vue_export-helper.js');
var index = require('../../../hooks/use-namespace/index.js');
var types = require('../../../utils/types.js');
var style = require('../../../utils/dom/style.js');
var index$1 = require('../../../hooks/use-deprecated/index.js');

const _hoisted_1 = ["textContent"];
const __default__ = vue.defineComponent({
  name: "ElBadge"
});
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: badge.badgeProps,
  setup(__props, { expose }) {
    const props = __props;
    const ns = index.useNamespace("badge");
    const content = vue.computed(() => {
      if (props.isDot)
        return "";
      if (types.isNumber(props.value) && types.isNumber(props.max)) {
        if (props.max < props.value) {
          return `${props.max}+`;
        }
        return props.value === 0 && !props.showZero ? "" : `${props.value}`;
      }
      return `${props.value}`;
    });
    const style$1 = vue.computed(() => {
      var _a, _b, _c, _d, _e, _f;
      return [
        {
          backgroundColor: props.color,
          marginRight: style.addUnit(-((_b = (_a = props.offset) == null ? void 0 : _a[0]) != null ? _b : 0)),
          marginTop: style.addUnit((_d = (_c = props.offset) == null ? void 0 : _c[1]) != null ? _d : 0)
        },
        (_e = props.dotStyle) != null ? _e : {},
        (_f = props.badgeStyle) != null ? _f : {}
      ];
    });
    index$1.useDeprecated({
      from: "dot-style",
      replacement: "badge-style",
      version: "2.8.0",
      scope: "el-badge",
      ref: "https://element-plus.org/en-US/component/badge.html"
    }, vue.computed(() => !!props.dotStyle));
    index$1.useDeprecated({
      from: "dot-class",
      replacement: "badge-class",
      version: "2.8.0",
      scope: "el-badge",
      ref: "https://element-plus.org/en-US/component/badge.html"
    }, vue.computed(() => !!props.dotClass));
    expose({
      content
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("div", {
        class: vue.normalizeClass(vue.unref(ns).b())
      }, [
        vue.renderSlot(_ctx.$slots, "default"),
        vue.createVNode(vue.Transition, {
          name: `${vue.unref(ns).namespace.value}-zoom-in-center`,
          persisted: ""
        }, {
          default: vue.withCtx(() => [
            vue.withDirectives(vue.createElementVNode("sup", {
              class: vue.normalizeClass([
                vue.unref(ns).e("content"),
                vue.unref(ns).em("content", _ctx.type),
                vue.unref(ns).is("fixed", !!_ctx.$slots.default),
                vue.unref(ns).is("dot", _ctx.isDot),
                _ctx.dotClass,
                _ctx.badgeClass
              ]),
              style: vue.normalizeStyle(vue.unref(style$1)),
              textContent: vue.toDisplayString(vue.unref(content))
            }, null, 14, _hoisted_1), [
              [vue.vShow, !_ctx.hidden && (vue.unref(content) || _ctx.isDot)]
            ])
          ]),
          _: 1
        }, 8, ["name"])
      ], 2);
    };
  }
});
var Badge = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["__file", "badge.vue"]]);

exports["default"] = Badge;
//# sourceMappingURL=badge2.js.map
