'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var timePicker = require('./src/time-picker.js');
var picker = require('./src/common/picker.js');
var panelTimePick = require('./src/time-picker-com/panel-time-pick.js');
var utils = require('./src/utils.js');
var constants = require('./src/constants.js');
var props = require('./src/common/props.js');

const _TimePicker = timePicker["default"];
_TimePicker.install = (app) => {
  app.component(_TimePicker.name, _TimePicker);
};
const ElTimePicker = _TimePicker;

exports.CommonPicker = picker["default"];
exports.TimePickPanel = panelTimePick["default"];
exports.buildTimeList = utils.buildTimeList;
exports.dateEquals = utils.dateEquals;
exports.extractDateFormat = utils.extractDateFormat;
exports.extractTimeFormat = utils.extractTimeFormat;
exports.formatter = utils.formatter;
exports.makeList = utils.makeList;
exports.parseDate = utils.parseDate;
exports.rangeArr = utils.rangeArr;
exports.valueEquals = utils.valueEquals;
exports.DEFAULT_FORMATS_DATE = constants.DEFAULT_FORMATS_DATE;
exports.DEFAULT_FORMATS_DATEPICKER = constants.DEFAULT_FORMATS_DATEPICKER;
exports.DEFAULT_FORMATS_TIME = constants.DEFAULT_FORMATS_TIME;
exports.timeUnits = constants.timeUnits;
exports.timePickerDefaultProps = props.timePickerDefaultProps;
exports.ElTimePicker = ElTimePicker;
exports["default"] = _TimePicker;
//# sourceMappingURL=index.js.map
