/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.compat;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.misc.Constants;
import net.minecraft.world.World;
import sereneseasons.api.season.SeasonHelper;

public abstract class SereneSeasonsCompat {
    private static boolean registered;
    private static String[] seasonWhiteList;

    private SereneSeasonsCompat() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        SereneSeasonsCompat.preInit();
    }

    private static void preInit() {
        if (!SereneSeasonsCompat.hasDefaultConfig()) {
            return;
        }
        RoughConfig.getConfig().addCustomCategoryComment("SereneSeasons", "Configuration options for enabling/disabling Serene Seasons support.\nThe mod Serene Seasons must be installed for these features to work.\n");
        seasonWhiteList = RoughConfig.getStringArray("SereneSeasons", "_WhiteList", Constants.SEASONS, "Whitelist of all seasons that Rough Mobs can spawn in.");
    }

    private static boolean hasDefaultConfig() {
        return true;
    }

    public static String getSeason(World world) {
        if (registered) {
            return SeasonHelper.getSeasonState((World)world).getSeason().toString();
        }
        return null;
    }

    public static String[] getSeasonWhitelist() {
        if (registered) {
            return seasonWhiteList;
        }
        return null;
    }
}

