/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.ai.combat.RoughAIWeaponSwitch;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAISunlightBurn;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.misc.Constants;
import com.p1ut0nium.roughmobsrevamped.misc.EquipHelper;
import com.p1ut0nium.roughmobsrevamped.misc.MountHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SkeletonFeatures
extends EntityFeatures {
    private boolean changeWeapons;
    private int horseChance;
    private int horseMinY;
    private int bowCooldown;
    private boolean helmetBurn;
    private EquipHelper.EquipmentApplier equipApplier;
    private BossHelper.BossApplier bossApplier;

    public SkeletonFeatures() {
        super("skeleton", EntitySkeleton.class, EntityStray.class, EntityWitherSkeleton.class);
    }

    @Override
    public void preInit() {
        this.equipApplier = new EquipHelper.EquipmentApplier(this.name, 1, 4, 8, 0.5f, 0.085f);
        this.bossApplier = new BossHelper.BossApplier(this.name, 200, 1.0f, 0.2f, new String[]{"Lich King", "Skeleton Lord", "Stallord", "Skeletron", "Skeletron Prime", "Krosis", "Wolnir", "Stalmaster"}){

            @Override
            public void addBossFeatures(EntityLiving entity) {
            }
        };
    }

    @Override
    public void postInit() {
        this.equipApplier.createPools();
        this.bossApplier.postInit();
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.changeWeapons = RoughConfig.getBoolean(this.name, "ChangeWeapons", true, "Set this to false to prevent %ss from switching their weapons");
        this.horseChance = RoughConfig.getInteger(this.name, "HorseChance", 10, 0, Short.MAX_VALUE, "Chance (1 in X) that a %s spawns riding a %s horse\nSet to 0 to disable this feature");
        this.horseMinY = RoughConfig.getInteger(this.name, "HorseMinY", 63, 0, Short.MAX_VALUE, "Minimal Y position above %s horses may spawn");
        this.bowCooldown = RoughConfig.getInteger(this.name, "BowCooldown", 0, 0, Short.MAX_VALUE, "Bow cooldown of %ss in ticks (The vanilla default is 20)");
        this.helmetBurn = RoughConfig.getBoolean(this.name, "HelmetBurn", false, "Set this to true to make all %ss burn in sunlight even if they wear a helmet");
        this.equipApplier.initConfig(Constants.SKELETON_MAINHAND, Constants.DEFAULT_MAINHAND, Constants.DEFAULT_HELMETS, Constants.DEFAULT_CHESTPLATES, Constants.DEFAULT_LEGGINGS, Constants.DEFAULT_BOOTS, Constants.DEFAULT_WEAPON_ENCHANTS, Constants.DEFAULT_ARMOR_ENCHANTS, false);
        this.bossApplier.initConfig();
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        EntityAIAttackRangedBow ai;
        if (this.changeWeapons && entity instanceof EntityLiving) {
            targetTasks.func_75776_a(1, (EntityAIBase)new RoughAIWeaponSwitch((EntityLiving)entity, 12.0));
        }
        if (this.helmetBurn) {
            tasks.func_75776_a(0, (EntityAIBase)new RoughAISunlightBurn((EntityLiving)entity, true));
        }
        if (entity instanceof AbstractSkeleton && (ai = (EntityAIAttackRangedBow)ReflectionHelper.getPrivateValue(AbstractSkeleton.class, (Object)((AbstractSkeleton)entity), (int)1)) != null) {
            ai.func_189428_b(this.bowCooldown);
        }
    }

    @Override
    public void addFeatures(EntityJoinWorldEvent event, Entity entity, Boolean bossesEnabled) {
        if (entity instanceof EntitySkeleton && entity.func_130014_f_().field_73011_w.getDimension() == -1) {
            this.changeToWither(event, (EntitySkeleton)entity);
        } else if (entity instanceof EntityLiving) {
            if (bossesEnabled.booleanValue()) {
                EntityLiving boss = this.bossApplier.trySetBoss((EntityLiving)entity);
                if (boss != null) {
                    entity = boss;
                    event.setCanceled(true);
                } else {
                    this.equipApplier.equipEntity((EntityLiving)entity);
                }
            }
            MountHelper.tryMountHorse(entity, MountHelper.HorseType.SKELETON, this.horseChance, this.horseMinY);
        }
    }

    private void changeToWither(EntityJoinWorldEvent event, EntitySkeleton entity) {
        EntityWitherSkeleton newSkeleton = new EntityWitherSkeleton(entity.func_130014_f_());
        newSkeleton.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        newSkeleton.func_180482_a(event.getWorld().func_175649_E(entity.func_180425_c()), null);
        entity.func_130014_f_().func_72838_d((Entity)newSkeleton);
        entity.func_70106_y();
        event.setCanceled(true);
    }
}

