/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.features;

import com.p1ut0nium.roughmobsrevamped.ai.combat.RoughAILeapAtTargetChanced;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAIBreakBlocks;
import com.p1ut0nium.roughmobsrevamped.ai.misc.RoughAISunlightBurn;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.features.EntityFeatures;
import com.p1ut0nium.roughmobsrevamped.misc.BossHelper;
import com.p1ut0nium.roughmobsrevamped.misc.Constants;
import com.p1ut0nium.roughmobsrevamped.misc.EquipHelper;
import com.p1ut0nium.roughmobsrevamped.misc.FeatureHelper;
import com.p1ut0nium.roughmobsrevamped.misc.MountHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.MobEffects;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class ZombieFeatures
extends EntityFeatures {
    public static final String BOSS_MINION = Constants.unique("bossMinion");
    private float leapHeight;
    private int leapChance;
    private int hungerDuration;
    private int hungerChance;
    private int horseChance;
    private int horseMinY;
    private boolean babyBurn;
    private boolean helmetBurn;
    private EquipHelper.EquipmentApplier equipApplier;
    private BossHelper.BossApplier bossApplier;
    private String[] breakBlocks;
    private List<Block> allowedBreakBlocks;

    public ZombieFeatures() {
        super("zombie", EntityZombie.class, EntityZombieVillager.class, EntityHusk.class, EntityPigZombie.class);
    }

    @Override
    public void preInit() {
        this.equipApplier = new EquipHelper.EquipmentApplier(this.name, 3, 4, 8, 0.5f, 0.085f);
        this.bossApplier = new BossHelper.BossApplier(this.name, 200, 1.0f, 0.2f, new String[]{"Zombie King", "Flesh King", "Dr. Zomboss", "Azog", "Zon-Goku", "Amy", "Z0mb3y"}){

            @Override
            public void addBossFeatures(EntityLiving entity) {
                for (int i = 0; i < 4; ++i) {
                    EntityZombie zombieMinion = new EntityZombie(entity.func_130014_f_());
                    zombieMinion.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    zombieMinion.func_180482_a(entity.func_130014_f_().func_175649_E(entity.func_180425_c()), null);
                    zombieMinion.func_82227_f(true);
                    zombieMinion.getEntityData().func_74757_a(BOSS_MINION, true);
                    entity.field_70170_p.func_72838_d((Entity)zombieMinion);
                }
            }
        };
    }

    @Override
    public void postInit() {
        this.equipApplier.createPools();
        this.bossApplier.postInit();
        this.allowedBreakBlocks = FeatureHelper.getBlocksFromNames(this.breakBlocks);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.leapChance = RoughConfig.getInteger(this.name, "LeapChance", 5, 0, Short.MAX_VALUE, "Chance (1 in X) for a %s to leap to the target\nSet to 0 to disable this feature");
        this.leapHeight = RoughConfig.getFloat(this.name, "LeapHeight", 0.2f, 0.0f, 32767.0f, "Amount of blocks the %s jumps on leap attack");
        this.hungerDuration = RoughConfig.getInteger(this.name, "HungerDuration", 200, 1, Short.MAX_VALUE, "Duration in ticks of the applied hunger effect (20 ticks = 1 second)");
        this.hungerChance = RoughConfig.getInteger(this.name, "HungerChance", 1, 0, Short.MAX_VALUE, "Chance (1 in X) for a %s to apply the hunger effect on attack\nSet to 0 to disable this feature");
        this.horseChance = RoughConfig.getInteger(this.name, "HorseChance", 10, 0, Short.MAX_VALUE, "Chance (1 in X) that a %s spawns riding a %s horse\nSet to 0 to disable this feature");
        this.horseMinY = RoughConfig.getInteger(this.name, "HorseMinY", 63, 0, Short.MAX_VALUE, "Minimal Y position above %s horses may spawn");
        this.babyBurn = RoughConfig.getBoolean(this.name, "BabyBurn", true, "Set this to false to prevent baby %ss from burning in sunlight");
        this.helmetBurn = RoughConfig.getBoolean(this.name, "HelmetBurn", false, "Set this to true to make all %ss burn in sunlight even if they wear a helmet");
        this.breakBlocks = RoughConfig.getStringArray(this.name, "BreakBlocks", Constants.DEFAULT_DESTROY_BLOCKS, "Blocks which can be destroyed by %ss if they have no attack target\nDelete all lines to disable this feature");
        this.equipApplier.initConfig(Constants.DEFAULT_MAINHAND, Constants.DEFAULT_OFFHAND, Constants.DEFAULT_HELMETS, Constants.DEFAULT_CHESTPLATES, Constants.DEFAULT_LEGGINGS, Constants.DEFAULT_BOOTS, Constants.DEFAULT_WEAPON_ENCHANTS, Constants.DEFAULT_ARMOR_ENCHANTS, false);
        this.bossApplier.initConfig();
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        if (this.leapChance > 0) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAILeapAtTargetChanced((EntityLiving)entity, this.leapHeight, this.leapChance));
        }
        if (this.babyBurn && entity instanceof EntityZombie && ((EntityZombie)entity).func_70631_g_() && !entity.func_70045_F()) {
            tasks.func_75776_a(0, (EntityAIBase)new RoughAISunlightBurn((EntityLiving)entity, false));
        }
        if (this.helmetBurn) {
            tasks.func_75776_a(0, (EntityAIBase)new RoughAISunlightBurn((EntityLiving)entity, true));
        }
        if (this.allowedBreakBlocks.size() > 0) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAIBreakBlocks((EntityLiving)entity, 8, this.allowedBreakBlocks));
        }
    }

    @Override
    public void addFeatures(EntityJoinWorldEvent event, Entity entity, Boolean bossesEnabled) {
        if (!(entity instanceof EntityLiving) || entity.getEntityData().func_74767_n(BOSS_MINION)) {
            return;
        }
        if (bossesEnabled.booleanValue()) {
            EntityLiving boss = this.bossApplier.trySetBoss((EntityLiving)entity);
            if (boss != null) {
                entity = boss;
                event.setCanceled(true);
            } else {
                this.equipApplier.equipEntity((EntityLiving)entity);
            }
        }
        MountHelper.tryMountHorse(entity, MountHelper.HorseType.ZOMBIE, this.horseChance, this.horseMinY);
    }

    @Override
    public void onAttack(Entity attacker, Entity immediateAttacker, Entity target, LivingAttackEvent event) {
        if (target instanceof EntityLivingBase && this.hungerChance > 0) {
            FeatureHelper.addEffect((EntityLivingBase)target, MobEffects.field_76438_s, this.hungerDuration, 0, this.hungerChance, true, 4);
        }
    }
}

