/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.entities.BossSkeleton;
import com.p1ut0nium.roughmobsrevamped.entities.BossZombie;
import com.p1ut0nium.roughmobsrevamped.entities.IBoss;
import com.p1ut0nium.roughmobsrevamped.misc.AttributeHelper;
import com.p1ut0nium.roughmobsrevamped.misc.Constants;
import com.p1ut0nium.roughmobsrevamped.misc.EquipHelper;
import com.p1ut0nium.roughmobsrevamped.util.handlers.EffectsHandler;
import com.p1ut0nium.roughmobsrevamped.util.handlers.SoundHandler;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class BossHelper {
    public static final Random RND = new Random();
    public static final String BOSS = Constants.unique("isBoss");

    public static boolean isBoss(Entity entity) {
        return entity.getEntityData() != null && entity.getEntityData().func_74767_n(BOSS);
    }

    public static abstract class BossApplier {
        private EquipHelper.EquipmentApplier equipApplier;
        private final String name;
        private final int defaultBossChance;
        private final float defaultEnchMultiplier;
        private final float defaultDropChance;
        private final String[] defaultBossNames;
        private int bossChance;
        private boolean bossWarning;
        private int bossWarningDist;
        private boolean bossWarningSound;
        private String[] bossNames;

        public BossApplier(String name, int defaultBossChance, float defaultEnchMultiplier, float defaultDropChance, String[] defaultBossNames) {
            this.name = name;
            this.defaultBossChance = defaultBossChance;
            this.defaultEnchMultiplier = defaultEnchMultiplier;
            this.defaultDropChance = defaultDropChance;
            this.defaultBossNames = defaultBossNames;
            this.equipApplier = new EquipHelper.EquipmentApplier(name + " boss", 1, 1, 1, this.defaultEnchMultiplier, this.defaultDropChance);
        }

        public void initConfig() {
            this.equipApplier.initConfig(Constants.DEFAULT_BOSS_MAINHAND, Constants.DEFAULT_BOSS_OFFHAND, Constants.DEFAULT_BOSS_HELMETS, Constants.DEFAULT_BOSS_CHESTPLATES, Constants.DEFAULT_BOSS_LEGGINGS, Constants.DEFAULT_BOSS_BOOTS, Constants.DEFAULT_WEAPON_ENCHANTS, Constants.DEFAULT_ARMOR_ENCHANTS, true);
            this.bossWarning = RoughConfig.getBoolean(this.name, "BossWarning", true, "Enable this to have a chat message warning of a boss spawn.");
            this.bossWarningDist = RoughConfig.getInteger(this.name, "BossWarningDistance", 50, 0, Short.MAX_VALUE, "Max bos spawn distance from a player that will trigger a warning.\nUsed for both chat messages and sounds.");
            this.bossWarningSound = RoughConfig.getBoolean(this.name, "BossWarningSound", true, "Play a warning sound when a boss spawns.");
            this.bossChance = RoughConfig.getInteger(this.name, "BossChance", this.defaultBossChance, 0, Short.MAX_VALUE, "Chance (1 in X) for a newly spawned " + this.name + " to become a boss " + this.name);
            this.bossNames = RoughConfig.getStringArray(this.name, "BossNames", this.defaultBossNames, this.name + " boss names. Please be more creative than I am... :P");
        }

        public void postInit() {
            this.equipApplier.createPools();
        }

        public EntityLiving trySetBoss(EntityLiving entity) {
            String entityTypeName;
            if (this.bossChance <= 0 || RND.nextInt(this.bossChance) != 0 || entity instanceof EntityZombie && ((EntityZombie)entity).func_70631_g_()) {
                return null;
            }
            IBoss boss = null;
            switch (entityTypeName = entity.func_70005_c_()) {
                case "Zombie": {
                    boss = new BossZombie(entity.field_70170_p);
                    boss.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_72838_d((Entity)boss);
                    entity.func_70106_y();
                    break;
                }
                case "Skeleton": {
                    boss = new BossSkeleton(entity.field_70170_p);
                    ((BossSkeleton)boss).func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    entity.field_70170_p.func_72838_d((Entity)((BossSkeleton)boss));
                    entity.func_70106_y();
                }
            }
            if (boss != null) {
                AttributeHelper.applyAttributeModifier((EntityLivingBase)((EntityLiving)boss), SharedMonsterAttributes.field_111267_a, this.name + "BossHealth", 0, ((EntityLiving)boss).func_110138_aP() * 2.0f);
                AttributeHelper.applyAttributeModifier((EntityLivingBase)((EntityLiving)boss), SharedMonsterAttributes.field_111266_c, this.name + "BossKnock", 1, 1.0);
                boolean isBoss = true;
                this.equipApplier.equipEntity((EntityLiving)boss, isBoss);
                String bossName = this.bossNames[RND.nextInt(this.bossNames.length)];
                ((EntityLiving)boss).func_96094_a(bossName);
                if (((EntityLiving)boss).func_130014_f_().func_175710_j(((EntityLiving)boss).func_180425_c())) {
                    EffectsHandler.lightningStrikeOn((Entity)((EntityLiving)boss));
                }
                if (this.bossWarning) {
                    TextComponentString bossWarningMsg = new TextComponentString(bossName + ", a powerful " + entityTypeName + " warlord, has joined the battlefield.");
                    bossWarningMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                    bossWarningMsg.func_150256_b().func_150227_a(Boolean.valueOf(true));
                    EntityPlayer closestPlayer = ((EntityLiving)boss).field_70170_p.func_72890_a((Entity)((EntityLiving)boss), (double)this.bossWarningDist);
                    if (closestPlayer != null) {
                        closestPlayer.func_145747_a((ITextComponent)bossWarningMsg);
                    }
                }
                if (this.bossWarningSound) {
                    ((EntityLiving)boss).func_184185_a(SoundHandler.ENTITY_BOSS_SPAWN, (float)(this.bossWarningDist / 16), 0.5f);
                }
                ((EntityLiving)boss).getEntityData().func_74757_a(BOSS, true);
                this.addBossFeatures((EntityLiving)boss);
                return (EntityLiving)boss;
            }
            return null;
        }

        public abstract void addBossFeatures(EntityLiving var1);
    }
}

