/*
 * Decompiled with CFR 0.152.
 */
package com.p1ut0nium.roughmobsrevamped.misc;

import com.p1ut0nium.roughmobsrevamped.RoughMobs;
import com.p1ut0nium.roughmobsrevamped.compat.GameStagesCompat;
import com.p1ut0nium.roughmobsrevamped.config.RoughConfig;
import com.p1ut0nium.roughmobsrevamped.misc.Constants;
import com.p1ut0nium.roughmobsrevamped.misc.SpawnHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EquipHelper {
    private static final String KEY_APPLIED = Constants.unique("equipApplied");
    private static final Random RND = new Random();
    private static boolean playerHasEnchantStage;
    private static boolean enchantStageEnabled;
    private static boolean chanceTimeMultiplier;
    private static boolean chanceDistanceMultiplier;
    private static int distThreshold;

    private static boolean getChance(Entity entity, int chance) {
        World world;
        double distanceToSpawn;
        if (chance <= 0) {
            return false;
        }
        float distanceChanceIncrease = 0.0f;
        float timeChanceIncrease = 0.0f;
        if (chanceTimeMultiplier) {
            long currentTime = entity.func_130014_f_().func_72820_D();
            byte currentHour = (byte)Math.floor((currentTime %= 24000L) / 1000L);
            if (currentHour >= 13 && currentHour <= 18) {
                timeChanceIncrease = (float)((double)(currentHour - 12) * 0.16);
            } else if (currentHour > 18 && currentHour <= 22) {
                timeChanceIncrease = (float)((double)Math.abs(currentHour - 23) * 0.25);
            }
        }
        if (chanceDistanceMultiplier && (distanceToSpawn = entity.func_70011_f((double)(world = entity.func_130014_f_()).func_175694_M().func_177958_n(), (double)world.func_175694_M().func_177956_o(), (double)world.func_175694_M().func_177952_p())) >= (double)SpawnHelper.getMinDistFromSpawn()) {
            distanceChanceIncrease = Math.min(1.0f, (float)(distanceToSpawn -= (double)SpawnHelper.getMinDistFromSpawn()) / (float)distThreshold);
        }
        float adjustedChance = Math.min(1.0f, 1.0f / (float)chance + Math.min(1.0f, 1.0f / (float)chance * distanceChanceIncrease + 1.0f / (float)chance * timeChanceIncrease));
        return Math.random() <= (double)adjustedChance;
    }

    public static class EntryPool<T> {
        public final Map<T, Object[]> POOL = new HashMap<T, Object[]>();
        private List<T> entries = null;

        public void addEntry(T t, Object ... data) {
            this.POOL.put(t, data);
        }

        public T getRandom(Entity entity) {
            return this.getRandom(entity, null);
        }

        public T getRandom(Entity entity, ItemStack item) {
            this.entries = new ArrayList<T>();
            for (Map.Entry<T, Object[]> entry : this.POOL.entrySet()) {
                Object[] data = entry.getValue();
                T key = entry.getKey();
                if (key instanceof ItemStack && data.length > 2 && ((String)data[2]).length() != 0) {
                    try {
                        ((ItemStack)key).func_77982_d(JsonToNBT.func_180713_a((String)((String)data[2])));
                    }
                    catch (NBTException e) {
                        RoughMobs.logError("NBT Tag invalid: %s", e.toString());
                        e.printStackTrace();
                    }
                }
                if (!EntryPool.isDimension(entity, String.valueOf(data[1]))) continue;
                boolean validEntry = true;
                if (item != null && key instanceof Enchantment) {
                    validEntry = ((Enchantment)key).func_92089_a(item);
                }
                if (!validEntry) continue;
                for (int i = 0; i < (Integer)data[0]; ++i) {
                    this.entries.add(key);
                }
            }
            int entrySize = this.entries.size();
            if (entrySize != 0) {
                int rnd = RND.nextInt(entrySize);
                return this.entries.get(rnd);
            }
            return null;
        }

        private static boolean isDimension(Entity entity, String dimension) {
            return dimension.trim().toUpperCase().equals("ALL") || String.valueOf(entity.field_71093_bK).equals(dimension);
        }
    }

    public static class EquipmentPool {
        public final EntryPool<ItemStack> ITEM_POOL = new EntryPool();
        public final EntryPool<Enchantment> ENCHANTMENT_POOL = new EntryPool();

        public static EquipmentPool createEquipmentPool(String name, String[] arrayItems, String[] arrayEnchants) {
            List<String> errorEnchants;
            EquipmentPool pool = new EquipmentPool();
            List<String> errorItems = pool.addItemsFromNames(arrayItems);
            if (!errorItems.isEmpty()) {
                RoughMobs.logError("Rough Mobs Revamped: error on creating the " + name + " item pool! " + String.join((CharSequence)", ", errorItems), new Object[0]);
            }
            if (!(errorEnchants = pool.addEnchantmentsFromNames(arrayEnchants)).isEmpty()) {
                RoughMobs.logError("Rough Mobs Revamped: error on creating the " + name + " enchantment pool! " + String.join((CharSequence)", ", errorEnchants), new Object[0]);
            }
            return pool;
        }

        public List<String> addEnchantmentsFromNames(String[] array) {
            ArrayList<String> errors = new ArrayList<String>();
            for (String s : array) {
                String error = this.addEnchantmentFromName(s);
                if (error == null) continue;
                errors.add(error);
            }
            return errors;
        }

        private String addEnchantmentFromName(String s) {
            String[] parts = s.split(";");
            if (parts.length >= 2) {
                try {
                    int dimension;
                    Enchantment ench = Enchantment.func_180305_b((String)parts[0]);
                    int probability = Integer.parseInt(parts[1]);
                    int n = dimension = parts.length > 2 ? Integer.parseInt(parts[2]) : Integer.MIN_VALUE;
                    if (ench == null) {
                        return "Invalid enchantment: " + parts[0] + " in line: " + s;
                    }
                    this.addEnchantment(ench, probability, dimension);
                }
                catch (NumberFormatException e) {
                    return "Invalid numbers in line: " + s;
                }
            } else {
                return "Invalid format for line: \"" + s + "\" Please change to enchantment;probability;dimensionID";
            }
            return null;
        }

        public List<String> addItemsFromNames(String[] array) {
            ArrayList<String> errors = new ArrayList<String>();
            for (String s : array) {
                String error = this.addItemFromName(s);
                if (error == null) continue;
                errors.add(error);
            }
            return errors;
        }

        private String addItemFromName(String s) {
            String[] parts = s.split(";");
            if (parts.length >= 2) {
                try {
                    String nbt;
                    Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0]));
                    int probability = Integer.parseInt(parts[1]);
                    int dimension = parts.length >= 3 ? Integer.parseInt(parts[2]) : Integer.MIN_VALUE;
                    int meta = parts.length >= 4 ? Integer.parseInt(parts[3]) : 0;
                    String string = nbt = parts.length >= 5 ? parts[4] : "";
                    if (item == null) {
                        return "Invalid item: " + parts[0] + " in line: " + s;
                    }
                    this.addItem(new ItemStack(item, 1, meta), probability, dimension, nbt);
                }
                catch (NumberFormatException e) {
                    return "Invalid numbers in line: " + s;
                }
            } else {
                return "Invalid format for line: \"" + s + "\" Please change to item;probability;meta";
            }
            return null;
        }

        public void addItem(ItemStack stack, int probability, int dimension, String nbt) {
            this.ITEM_POOL.addEntry(stack, probability, dimension == Integer.MIN_VALUE ? "ALL" : Integer.valueOf(dimension), nbt);
        }

        public void addEnchantment(Enchantment enchantment, int probability, int dimension) {
            this.ENCHANTMENT_POOL.addEntry(enchantment, probability, dimension == Integer.MIN_VALUE ? "ALL" : Integer.valueOf(dimension));
        }

        public ItemStack getRandom(Entity entity, int enchChance, float levelMultiplier) {
            Enchantment ench;
            if (this.ITEM_POOL.POOL.isEmpty()) {
                return null;
            }
            ItemStack randomStack = this.ITEM_POOL.getRandom(entity);
            if ((!enchantStageEnabled || enchantStageEnabled && playerHasEnchantStage) && randomStack != null && !this.ENCHANTMENT_POOL.POOL.isEmpty() && enchChance > 0 && RND.nextInt(enchChance) == 0 && EquipHelper.getChance(entity, enchChance) && (ench = this.ENCHANTMENT_POOL.getRandom(entity, randomStack)) != null) {
                double maxLevel = Math.max(ench.func_77319_d(), Math.min(ench.func_77325_b(), Math.round((float)ench.func_77325_b() * levelMultiplier)));
                int level = (int)Math.round(maxLevel * (0.5 + Math.random() / 2.0));
                if (!randomStack.func_77948_v()) {
                    randomStack.func_77966_a(ench, level);
                }
            }
            return randomStack;
        }
    }

    public static class EquipmentApplier {
        private final String name;
        private final int chancePerWeaponDefault;
        private final int chancePerPieceDefault;
        private final int enchChanceDefault;
        private final float enchMultiplierDefault;
        private final float dropChanceDefault;
        private EquipmentPool poolMainhand;
        private EquipmentPool poolOffhand;
        private EquipmentPool poolHelmet;
        private EquipmentPool poolChestplate;
        private EquipmentPool poolLeggings;
        private EquipmentPool poolBoots;
        private int chancePerWeapon;
        private int chancePerPiece;
        private int enchChance;
        private float enchMultiplier;
        private float dropChance;
        private String[] equipMainhand;
        private String[] equipOffhand;
        private String[] equipHelmet;
        private String[] equipChestplate;
        private String[] equipLeggings;
        private String[] equipBoots;
        private String[] equipWeaponEnchants;
        private String[] equipArmorEnchants;

        public EquipmentApplier(String name, int chancePerWeaponDefault, int chancePerPieceDefault, int enchChanceDefault, float enchMultiplierDefault, float dropChanceDefault) {
            this.name = name;
            this.chancePerWeaponDefault = chancePerWeaponDefault;
            this.chancePerPieceDefault = chancePerPieceDefault;
            this.enchChanceDefault = enchChanceDefault;
            this.enchMultiplierDefault = enchMultiplierDefault;
            this.dropChanceDefault = dropChanceDefault;
        }

        public EquipmentPool getPoolMainhand() {
            return this.poolMainhand;
        }

        public EquipmentPool getPoolOffhand() {
            return this.poolOffhand;
        }

        public EquipmentPool getPoolHelmet() {
            return this.poolHelmet;
        }

        public EquipmentPool getPoolChestplate() {
            return this.poolChestplate;
        }

        public EquipmentPool getPoolLeggings() {
            return this.poolLeggings;
        }

        public EquipmentPool getPoolBoots() {
            return this.poolBoots;
        }

        public void setPoolMainhand(EquipmentPool poolMainhand) {
            this.poolMainhand = poolMainhand;
        }

        public void setPoolOffhand(EquipmentPool poolOffhand) {
            this.poolOffhand = poolOffhand;
        }

        public void setPoolHelmet(EquipmentPool poolHelmet) {
            this.poolHelmet = poolHelmet;
        }

        public void setPoolChestplate(EquipmentPool poolChestplate) {
            this.poolChestplate = poolChestplate;
        }

        public void setPoolLeggings(EquipmentPool poolLeggings) {
            this.poolLeggings = poolLeggings;
        }

        public void setPoolBoots(EquipmentPool poolBoots) {
            this.poolBoots = poolBoots;
        }

        public void equipEntity(EntityLiving entity) {
            this.equipEntity(entity, false);
        }

        public void equipEntity(EntityLiving entity, boolean isBoss) {
            if (entity == null || entity.getEntityData().func_74767_n(KEY_APPLIED)) {
                return;
            }
            EntityPlayer playerClosest = entity.field_70170_p.func_72890_a((Entity)entity, -1.0);
            enchantStageEnabled = GameStagesCompat.useEnchantStage();
            if (enchantStageEnabled) {
                playerHasEnchantStage = GameStageHelper.hasAnyOf((EntityPlayer)playerClosest, (String[])new String[]{"roughmobsall", "roughmobsenchant"});
            } else {
                playerHasEnchantStage = false;
            }
            EquipmentPool[] pools = new EquipmentPool[]{this.poolMainhand, this.poolOffhand, this.poolBoots, this.poolLeggings, this.poolChestplate, this.poolHelmet};
            boolean completeArmorSet = isBoss;
            for (int i = 0; i < pools.length; ++i) {
                ItemStack stack;
                int chance;
                EquipmentPool pool = pools[i];
                EntityEquipmentSlot slot = EntityEquipmentSlot.values()[i];
                int n = chance = i <= 1 ? this.chancePerWeapon : this.chancePerPiece;
                if (!EquipHelper.getChance((Entity)entity, chance) && (!completeArmorSet || i <= 1) || (stack = pool.getRandom((Entity)entity, this.enchChance, this.enchMultiplier)) == null) continue;
                entity.func_184201_a(slot, stack);
                entity.func_184642_a(slot, this.dropChance);
            }
            entity.getEntityData().func_74757_a(KEY_APPLIED, true);
        }

        public String initConfig(String[] defaultMainhand, String[] defaultOffhand, String[] defaultHelmets, String[] defaultChestplates, String[] defaultLeggings, String[] defaultBoots, String[] defaultWeaponEnchants, String[] defaultArmorEnchants, boolean skipChanceOptions) {
            String formatName = this.name.toLowerCase().replace(" ", "") + "Equipment";
            RoughConfig.getConfig().addCustomCategoryComment(formatName, "Add enchanted armor and weapons to a newly spawned " + this.name + ". Takes 2-3 values seperated by a semicolon:\nFormat: item or enchantment;chance;dimension\nitem or enchantment:\tthe item/enchantment id\nchance:\t\t\t\tthe higher this number the more this item/enchantment gets selected\ndimension:\t\t\tdimension (ID) in which the item/enchantment can be selected (optional! Leave this blank for any dimension)");
            if (skipChanceOptions) {
                this.chancePerWeapon = this.chancePerWeaponDefault;
                this.chancePerPiece = this.chancePerPieceDefault;
                this.enchChance = this.enchChanceDefault;
            } else {
                this.chancePerWeapon = RoughConfig.getInteger(formatName, "WeaponChance", this.chancePerWeaponDefault, 0, Short.MAX_VALUE, "Chance (1 in X per hand) to give a " + this.name + " new weapons on spawn.\nNOTE: Bosses always spawn with weapons.\nSet to 0 to disable new weapons", true);
                this.chancePerPiece = RoughConfig.getInteger(formatName, "ArmorChance", this.chancePerPieceDefault, 0, Short.MAX_VALUE, "Chance (1 in X per piece) to give a " + this.name + " new armor on spawn.\nSet to 0 to disable new armor.", true);
                this.enchChance = RoughConfig.getInteger(formatName, "EnchantChance", this.enchChanceDefault, 0, Short.MAX_VALUE, "Chance (1 in X per item) to enchant newly given items\nSet to 0 to disable item enchanting", true);
            }
            chanceTimeMultiplier = RoughConfig.getBoolean(formatName, "TimeMultiplier", true, "Should rough mobs get more abilities and gear as it gets closer to midnight?", true);
            chanceDistanceMultiplier = RoughConfig.getBoolean(formatName, "DistanceMultiplier", true, "Should rough mobs get more and stronger abilities and gear based upon distance from world spawn?", true);
            distThreshold = RoughConfig.getInteger(formatName, "DistanceThreshold", 1000, 0, Integer.MAX_VALUE, "The distance threshold used to calculate the DistanceMultiplier.\nShorter distances here means mobs will be tougher closer to the World Spawn.", true);
            this.enchMultiplier = RoughConfig.getFloat(formatName, "EnchantMultiplier", this.enchMultiplierDefault, 0.0f, 1.0f, "Multiplier for the applied enchantment level with the max. level. The level can still be a bit lower\ne.g. 0.5 would make sharpness to be at most level 3 (5 x 0.5 = 2.5 and [2.5] = 3) and fire aspect would always be level 1 (2 x 0.5 = 1)", true);
            this.dropChance = RoughConfig.getFloat(formatName, "DropChance", this.dropChanceDefault, 0.0f, 1.0f, "Chance (per slot) that the " + this.name + " drops the equipped item (1 = 100%, 0 = 0%)", true);
            this.equipMainhand = RoughConfig.getStringArray(formatName, "Mainhand", defaultMainhand, "Items which can be wielded by a " + this.name + " in their mainhand");
            this.equipOffhand = RoughConfig.getStringArray(formatName, "Offhand", defaultOffhand, "Items which can be wielded by a " + this.name + " in their offhand");
            this.equipHelmet = RoughConfig.getStringArray(formatName, "Helmet", defaultHelmets, "Helmets which can be worn by a " + this.name + " in their helmet slot");
            this.equipChestplate = RoughConfig.getStringArray(formatName, "Chestplate", defaultChestplates, "Chestplates which can be worn by a " + this.name + " in their chestplate slot");
            this.equipLeggings = RoughConfig.getStringArray(formatName, "Leggings", defaultLeggings, "Leggings which can be worn by a " + this.name + " in their leggings slot");
            this.equipBoots = RoughConfig.getStringArray(formatName, "Boots", defaultBoots, "Boots which can be worn by a " + this.name + " in their boots slot");
            this.equipWeaponEnchants = RoughConfig.getStringArray(formatName, "WeaponEnchants", defaultWeaponEnchants, "Enchantments which can be applied to mainhand and offhand items");
            this.equipArmorEnchants = RoughConfig.getStringArray(formatName, "ArmorEnchants", defaultArmorEnchants, "Enchantments which can be applied to armor items");
            return formatName;
        }

        public void createPools() {
            this.setPoolMainhand(EquipmentPool.createEquipmentPool("mainhand", this.equipMainhand, this.equipWeaponEnchants));
            this.setPoolOffhand(EquipmentPool.createEquipmentPool("offhand", this.equipOffhand, this.equipWeaponEnchants));
            this.setPoolHelmet(EquipmentPool.createEquipmentPool("helmet", this.equipHelmet, this.equipArmorEnchants));
            this.setPoolChestplate(EquipmentPool.createEquipmentPool("chestplate", this.equipChestplate, this.equipArmorEnchants));
            this.setPoolLeggings(EquipmentPool.createEquipmentPool("leggings", this.equipLeggings, this.equipArmorEnchants));
            this.setPoolBoots(EquipmentPool.createEquipmentPool("boots", this.equipBoots, this.equipArmorEnchants));
        }
    }
}

