require "behaviours/follow"
require "behaviours/wander"
require "behaviours/attackwall"

local MIN_FOLLOW_DIST = 2
local MAX_FOLLOW_DIST = 10
local TARGET_FOLLOW_DIST = 9
local MAX_WANDER_DIST = 10

local SEE_PLAYER_DIST = 5
local SEE_FOOD_DIST = 10
local MAX_WANDER_DIST = 15
local MAX_CHASE_TIME = 20
local MAX_CHASE_DIST = 25
local RUN_AWAY_DIST = 6
local STOP_RUN_AWAY_DIST = 8


local Rivenmemberbrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GetHome(inst)
    if inst.components.follower.leader then
        return nil
    end
    return inst.components.homeseeker and inst.components.homeseeker.home 
end

local function GetHomePos(inst)
    local home = GetHome(inst)
    return home and home:GetPosition() 
end

local function EatFoodAction(inst)
    local target = nil
    local enemy = nil
    enemy = FindEntity(inst, 20, function(guy)
        return guy:HasTag("character")
    end)
    if enemy then
        return
    end
    if inst.components.inventory and inst.components.eater then
        target = inst.components.inventory:FindItem(function(item) return inst.components.eater:CanEat(item) end)
    end
    if not target then
        target = FindEntity(inst, 30, function(item) return inst.components.eater:CanEat(item) end)
    end
    if target then
        local act = BufferedAction(inst, target, ACTIONS.EAT)
        act.validfn = function() return not (target.components.inventoryitem and target.components.inventoryitem.owner and target.components.inventoryitem.owner ~= inst) end
        return act
    end
end

function Rivenmemberbrain:OnStart()
    local root = PriorityNode(
    {   
        WhileNode( function() 
            if self.inst.components.combat.target and self.inst.components.combat.target:HasTag(self.inst.belongtowhich) and not self.inst.components.combat.target:HasTag("character") then
                self.inst.components.combat.target = nil
            end 
            local enemy = self.inst.components.combat.target
            local dist = 999
            if enemy then
                local x1, y1, z1 = self.inst.Transform:GetWorldPosition()
                local x2, y2, z2 = enemy.Transform:GetWorldPosition()
                if x1 and x2 and z1 and z2 then
                    dist = math.sqrt((x1-x2)*(x1-x2) + (z1-z2)*(z1-z2))
                end
            end
            return enemy and (self.inst.myweapon == "swap_blowdart" or self.inst.myweapon == "swap_staffs" )
            and dist<6 and self.inst.hurttime<3
            end, 
            "Dodge", RunAway(self.inst, function() 
            return self.inst.components.combat.target end,  RUN_AWAY_DIST,  STOP_RUN_AWAY_DIST) ),
        IfNode( function() return self.inst.components.combat.target ~= nil end, "hastarget", AttackWall(self.inst)),
        WhileNode( function() 
                if self.inst.components.combat.target and self.inst.components.combat.target:HasTag(self.inst.belongtowhich) and not self.inst.components.combat.target:HasTag("character") then
                    self.inst.components.combat.target = nil
                end 
                local oldcalculate=self.inst.calculate
                if oldcalculate<=0 and not self.inst.renewtask then
                    self.inst:DoTaskInTime(4, function() 
                        self.inst.calculate = math.random(5)
                        if self.inst.renewtask then
                            self.inst.renewtask:Cancel()
                            self.inst.renewtask=nil
                        end
                    end)
                end
    			return (self.inst.components.combat.target == nil or not self.inst.components.combat:InCooldown()) and oldcalculate>0
            end, 			
			"AttackMomentarily",
			ChaseAndAttack(self.inst, 20, 100) ),      
        WhileNode( function()
            if self.inst.components.combat.target and self.inst.components.combat.target:HasTag(self.inst.belongtowhich) and not self.inst.components.combat.target:HasTag("character") then
                self.inst.components.combat.target = nil
            end  
            local enemy = self.inst.components.combat.target
			return enemy
            end, 
			"Dodge", RunAway(self.inst, function() 
			return self.inst.components.combat.target end,  RUN_AWAY_DIST,  STOP_RUN_AWAY_DIST) ),
        DoAction(self.inst, EatFoodAction, "Eat Food"),
        Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
        WhileNode(function() return GetHome(self.inst) end, "HasHome", Wander(self.inst, GetHomePos, 8) ),
        Wander(self.inst),
    }, .1)
    
    self.bt = BT(self.inst, root)

end

return Rivenmemberbrain