local Rivencast = Class(function(self, inst)
    self.inst = inst
    self.disabled=false
    self.pweapon = nil
end)
function Rivencast:SJBZ(pt, caster)
    local old = caster.bufferedaction
    if caster:HasTag("qbuffon") and caster.qconbine==0 and caster.nocasting(caster) then
        self:q1(pt, caster)
        self:q1buff(pt, caster)
    elseif caster:HasTag("qbuffon") and caster.qconbine==1 and caster.nocasting(caster) then
        self:q2(pt, caster)
        self:q2buff(pt, caster)
    elseif caster:HasTag("qbuffon") and caster.qconbine==2 and caster.nocasting(caster) then
        self:q3(pt, caster)
        self:q3buff(pt, caster)
    elseif caster:HasTag("ebuffon") and caster.nocasting(caster) then
        self:e1(pt, caster)
        self:e1buff(pt, caster)
        self:e1attack(pt, caster)
    elseif caster:HasTag("rbuffon") and caster.nocasting(caster) then
        self:r1(pt, caster)
        self:r1buff(pt, caster)
        self:r1attack(pt, caster)
    end
    caster.bufferedaction = old 
    return true
end
function Rivencast:CANCEL()
    local player = GetPlayer()
    local old = player.bufferedaction
    player.removealltag(player)
    player.destoryq(player)
    player:ClearBufferedAction()
    player.bufferedaction = old 
    return true
end
function Rivencast:q1(pt, caster)
    if not caster:HasTag("skillq") then
        caster:AddTag("skillq")
    end
    caster:ClearBufferedAction()
    caster.components.playercontroller:Enable(false)
    caster.components.locomotor:Stop()
    pt=Vector3(TheInput:GetWorldPosition():Get())
    if caster.components.driver and caster.components.driver.vehicle then
        caster.components.driver.vehicle:Show()
    end
    caster:ForceFacePoint(pt.x,pt.y,pt.z)
    local x2, y2, z2 = caster.Transform:GetWorldPosition()
    local dist = math.sqrt((pt.x-x2)*(pt.x-x2) + (pt.z-z2)*(pt.z-z2))
    if dist>8 then
        dist=8
    end
    local speed = dist*4
    caster.AnimState:PlayAnimation("atk")
    caster.Physics:SetMotorVelOverride(.35 * speed, 0, 0) 
    caster:DoTaskInTime(0.03, function() 
        caster.components.xxxmagic_riven:DoDelta(25)
        caster.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
        if caster.components.health then
            caster.components.health:SetInvincible(true)
        end
    end)
    caster:DoTaskInTime(0.4, function() 
        self:q1attack(pt, caster)
        caster.Physics:ClearMotorVelOverride()
        caster.components.locomotor:Stop()
        caster.AnimState:PlayAnimation("idle")
        if caster.components.health then
            caster.components.health:SetInvincible(false)
        end 
        shitswap("rivenq2").Transform:SetPosition(GetPlayer():GetPosition():Get())
        shitswap("rivenq1").Transform:SetPosition(GetPlayer():GetPosition():Get())
        caster.components.playercontroller:Enable(true)
        caster:ClearBufferedAction()
        if caster:HasTag("skillq") then
            caster:RemoveTag("skillq")
        end
    end)
end
function Rivencast:q2(pt, caster)
    if not caster:HasTag("skillq") then
        caster:AddTag("skillq")
    end
    caster:ClearBufferedAction()
    caster.components.playercontroller:Enable(false)
    caster.components.locomotor:Stop()
    pt=Vector3(TheInput:GetWorldPosition():Get())
    if caster.components.driver and caster.components.driver.vehicle then
        caster.components.driver.vehicle:Show()
    end
    caster:ForceFacePoint(pt.x,pt.y,pt.z)
    local x2, y2, z2 = caster.Transform:GetWorldPosition()
    local dist = math.sqrt((pt.x-x2)*(pt.x-x2) + (pt.z-z2)*(pt.z-z2))
    if dist>8 then
        dist=8
    end
    local speed = dist*4
    caster.AnimState:PlayAnimation("shovel_pre")
    caster.Physics:SetMotorVelOverride(.35 * speed, 0, 0)
    caster:DoTaskInTime(0.15, function() 
        caster.AnimState:PlayAnimation("shovel_loop",false)
    end)
    caster:DoTaskInTime(0.03, function() 
        caster.components.xxxmagic_riven:DoDelta(25)
        caster.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
        if caster.components.health then
            caster.components.health:SetInvincible(true)
        end
    end)
    caster:DoTaskInTime(0.4, function() 
        self:q2attack(pt, caster)
        caster.Physics:ClearMotorVelOverride()
        caster.components.locomotor:Stop()
        caster.AnimState:PlayAnimation("idle")
        if caster.components.health then
            caster.components.health:SetInvincible(false)
        end 
        shitswap("rivenq2").Transform:SetPosition(GetPlayer():GetPosition():Get())
        shitswap("rivenq1").Transform:SetPosition(GetPlayer():GetPosition():Get())
        caster.components.playercontroller:Enable(true)
        caster:ClearBufferedAction()
        if caster:HasTag("skillq") then
            caster:RemoveTag("skillq")
        end
    end)
end

local function testpoint (x,y,z)
    local ground = GetWorld()
    local tile = ground.Map:GetTileAtPoint(x, y, z)
    return tile ~= GROUND.IMPASSABLE
end

function Rivencast:q3(pt, caster)
    caster.AnimState:PlayAnimation("idle")
    caster:ClearBufferedAction()
    caster.components.locomotor:Stop()
    caster.components.playercontroller:Enable(false)
    pt=Vector3(TheInput:GetWorldPosition():Get())
    local x2, y2, z2 = caster.Transform:GetWorldPosition()
    local dist = math.sqrt((pt.x-x2)*(pt.x-x2) + (pt.z-z2)*(pt.z-z2))
    local odist = dist
    if dist>10 then
        dist=10
    end
    local spx = x2+(pt.x-x2)*(dist/odist)
    local spz = z2+(pt.z-z2)*(dist/odist)
    pt.x = spx
    pt.z = spz
    local jumpp= false
    caster.components.xxxmagic_riven:DoDelta(25)
    if not caster:HasTag("skillq") then
        caster:AddTag("skillq")
    end
    caster.AnimState:PlayAnimation("jump")
    if caster.components.driver and caster.components.driver.vehicle then
        caster.components.driver.vehicle:Show()
    end
    caster:ForceFacePoint(pt.x,pt.y,pt.z)
    if caster.components.health then
        caster.components.health:SetInvincible(true)
    end
    if testpoint(spx,0,spz) then
        jumpp= true
        local speed = dist * 5
        caster.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
        caster.Physics:ClearCollisionMask()
        caster.Physics:CollidesWith(COLLISION.GROUND)
        caster.Physics:SetMotorVelOverride(.35 * speed, .25 * speed, 0)
        caster:DoTaskInTime(0.3, function() 
            caster.Physics:ClearMotorVelOverride()
            caster.Physics:SetMotorVelOverride(.35 * speed, -0.25 * speed, 0)
        end)
    else
        local speed = dist*8/6
        caster.Physics:SetMotorVelOverride(.35 * speed, 0, 0)
    end
    caster:DoTaskInTime(0.5, function() 
        caster.AnimState:PlayAnimation("atk")
        caster.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
    end)
    caster:DoTaskInTime(0.6, function() 
        self:q3attack(pt, caster)
        caster:ClearBufferedAction()
        if jumpp then
            caster.Physics:ClearMotorVelOverride()
            caster.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
            caster.Physics:ClearCollisionMask()
            caster.Physics:CollidesWith(COLLISION.WORLD)
            caster.Physics:CollidesWith(COLLISION.OBSTACLES)
            caster.Physics:CollidesWith(COLLISION.CHARACTERS)
            caster.Physics:CollidesWith(COLLISION.ITEMS)
            caster.Physics:CollidesWith(COLLISION.GROUND)
            caster.Transform:SetPosition(spx, 0, spz)
        end
        caster.components.playercontroller:Enable(true)
        caster.components.locomotor:Stop()
        TheCamera:Shake("SIDE", 0.5, 0.05, 0.1)
        shitswap("rivenq2").Transform:SetPosition(GetPlayer():GetPosition():Get())
        shitswap("rivenq1").Transform:SetPosition(GetPlayer():GetPosition():Get())
        if caster.components.health then
            caster.components.health:SetInvincible(false)
        end 
        if caster:HasTag("skillq") then
            caster:RemoveTag("skillq")
        end
    end)
end
function Rivencast:e1(pt, caster)
    if not caster:HasTag("skille") then
        caster:AddTag("skille")
    end
    caster:ClearBufferedAction()
    caster.components.playercontroller:Enable(false)
    caster.components.locomotor:Stop()
    if caster.components.driver and caster.components.driver.vehicle then
        caster.components.driver.vehicle:Show()
    end
    pt=Vector3(TheInput:GetWorldPosition():Get())
    caster:ForceFacePoint(pt.x,pt.y,pt.z)
    local x2, y2, z2 = caster.Transform:GetWorldPosition()
    local dist = math.sqrt((pt.x-x2)*(pt.x-x2) + (pt.z-z2)*(pt.z-z2))
    if dist<4 then
        dist=4
    elseif dist>8 then
        dist=8
    end
    local speed = dist*7
    caster.AnimState:PlayAnimation("shovel_pre")
    caster.AnimState:PlayAnimation("atk")
    caster:DoTaskInTime(0.15, function() 
        caster.AnimState:PlayAnimation("shovel_loop",false)
    end)
    caster:DoTaskInTime(0.1, function() 
        caster.components.xxxmagic_riven:DoDelta(25)
        caster.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
        caster.Physics:SetMotorVelOverride(.35 * speed, 0, 0)
        if caster.components.health then
            caster.components.health:SetInvincible(true)
        end
    end)
    caster:DoTaskInTime(0.3, function() 
        caster.Physics:ClearMotorVelOverride()
        caster.components.locomotor:Stop()
        caster.components.playercontroller:Enable(true)
        if caster.components.health then
            caster.components.health:SetInvincible(false)
        end 
        local fx = shitswap("forcefieldfx")
        if not fx.components.highlight then
            fx:AddComponent("highlight")
        end
        local frozenColor = Vector3(0/255,255/255,0/255)
        local r,g,b = frozenColor.x,frozenColor.y,frozenColor.z
        fx.components.highlight:SetAddColour(Vector3(r, g, b) )
        shitswap("moose_nest_fx").entity:SetParent(caster.entity)
        shitswap("sparklefx").entity:SetParent(caster.entity)
        fx.entity:SetParent(caster.entity)
        fx.Transform:SetPosition(0, 0.2, 0)
        caster.components.xxxmagic_riven.armor=45 
        if caster.components.health.SetAbsorptionAmount then
            caster.components.health:SetAbsorptionAmount(1)
        else
            caster.components.health.absorb=1
        end
        local hitfn = function(attacked, data)
            if data and data.damage and data.damage>0 and caster.components.xxxmagic_riven.armor>0 then
                caster.components.xxxmagic_riven.armor =caster.components.xxxmagic_riven.armor-data.damage
                if caster.components.xxxmagic_riven.armor <= 0 then
                    caster.components.xxxmagic_riven.armor=0
                    if caster.components.health.SetAbsorptionAmount then
                        caster.components.health:SetAbsorptionAmount(caster.absorb)
                    else
                        caster.components.health.absorb=caster.absorb
                    end
                    if fx then
                        fx.kill_fx(fx)
                    end
                end
            end 
        end
        caster:ListenForEvent("attacked", hitfn, caster)
        caster:DoTaskInTime(2, function() 
            fx.kill_fx(fx)
            if caster:HasTag("ebuffon") then
                caster:RemoveTag("ebuffon")
            end
            caster.components.xxxmagic_riven.armor=0
            if caster.components.health.SetAbsorptionAmount then
                caster.components.health:SetAbsorptionAmount(caster.absorb)
            else
                caster.components.health.absorb=caster.absorb
            end
            caster:RemoveEventCallback("attacked", hitfn ,caster)
        end)
    end)
    caster:DoTaskInTime(0.4, function()
        caster.AnimState:PlayAnimation("idle")
        caster:ClearBufferedAction()
        if caster:HasTag("skille") then
            caster:RemoveTag("skille")
        end
        if caster.components.driver and caster.components.driver.vehicle then
            caster.components.driver.vehicle:Hide()
        end
    end)
end
function Rivencast:r1(pt, caster)
    caster:ClearBufferedAction()
    caster.components.playercontroller:Enable(false)
    caster.components.locomotor:Stop()
    local weapon  = caster.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) 
    caster.canr = false 
    if not caster:HasTag("r") then
        caster:AddTag("r")
    end
    if not caster:HasTag("skillr") then
        caster:AddTag("skillr")
    end
    if caster:HasTag("rpre") then
        caster:RemoveTag("rpre")
    end
    if caster:HasTag("rbuffon") then
        caster:RemoveTag("rbuffon")
    end
    if caster.components.driver and caster.components.driver.vehicle then
        caster.components.driver.vehicle:Show()
    end
    pt=Vector3(TheInput:GetWorldPosition():Get())
    caster:ForceFacePoint(pt.x,pt.y,pt.z)
    local x2, y2, z2 = caster.Transform:GetWorldPosition()
    local fx=shitswap("rivenr")
    fx.Transform:SetScale(4, 4, 4)
    fx.Transform:SetPosition(x2, y2, z2)
    fx:ForceFacePoint(pt.x,pt.y,pt.z)
    fx:Hide()
    local angel = math.atan2(pt.z-z2, pt.x-x2)
    local dist = math.sqrt((pt.x-x2)*(pt.x-x2) + (pt.z-z2)*(pt.z-z2))
    local speed = dist * 4
    caster.AnimState:PlayAnimation("atk")
    caster:DoTaskInTime(0.3, function() 
        caster.AnimState:PlayAnimation("jump")
        caster.Physics:SetMotorVelOverride(  .3*speed, 5, 0)
    end)
    caster:DoTaskInTime(0.5, function() 
        caster.Physics:ClearMotorVelOverride()
        caster.Physics:SetMotorVelOverride(  .3*speed, -5, 0)
        caster.AnimState:PlayAnimation("shovel_pre")
    end)
    caster:DoTaskInTime(0.7, function() 
        caster.AnimState:PlayAnimation("atk")
        caster.Physics:ClearMotorVelOverride()
        caster.components.locomotor:Stop()
        caster:ClearBufferedAction()
        caster.components.playercontroller:Enable(true)
        if caster:HasTag("skillr") then
            caster:RemoveTag("skillr")
        end
        if caster.components.driver and caster.components.driver.vehicle then
            caster.components.driver.vehicle:Hide()
        end
    end)
    caster:DoTaskInTime(0.9, function() 
        fx:Show()
        local nw = caster.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) 
        if weapon and weapon.prefab=='rivensword' and caster.AnimState 
            and nw and nw == weapon
        then
            weapon.components.equippable.onequipfn(weapon,caster)
        end
        x2, y2, z2 = caster:GetPosition():Get()
        fx.Transform:SetPosition(x2, y2, z2)
        fx.Physics:SetMotorVelOverride(15, 0, 0)
        fx.Physics:SetCollides(false)
    end)
    caster:DoTaskInTime(1, function() 
        local x3,y3,z3 = caster:GetPosition():Get()
        local ents = TheSim:FindEntities(x3,y3,z3, 20)
        local player=caster
        local backpack = player.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
        if backpack and backpack.components.container then
        else
            backpack = nil 
        end
        for k,v in pairs(ents) do
            if (v and v.components.container and v.components.container.canbeopened) 
                    or (v and v.components.follower and v.components.follower.leader == caster) then 
            elseif  v and not (v:HasTag("mypet") or v:HasTag(player.belongtowhich) and (v.components.combat and v.components.combat.target~= caster)) and v.components.combat and v.components.health and v.components.health:GetPercent() >= 0 and v ~= caster 
            
            and player.components.inventory and not player.components.inventory:GetItemSlot(v)
            and player.components.inventory:GetActiveItem()~=v
            and not (backpack and backpack.components.container:GetItemSlot(v))
            
            then
                local x4, y4, z4 = v:GetPosition():Get()
                local ang=math.abs((math.atan2(z4-z3, x4-x3))-angel)
                if ang<.8 then
                    local damageI=200
                    local wdamage = 10
                    if weapon and weapon.components.weapon then
                        wdamage = weapon.components.weapon.damage
                    end
                    if weapon and weapon.components.weapon and weapon.components.weapon.attackrange and weapon.components.weapon.attackrange>3 then 
                        wdamage = wdamage /3
                    end
                    if weapon and weapon.components.weapon and weapon.components.weapon.damage then
                        damageI=wdamage*caster.charcritmulti*6
                    end
                    v.components.combat:GetAttacked(caster, damageI)
                    if v.sg and v.sg.sg and v.sg.sg.states and v.sg.sg.states.hit and not v.components.health:IsDead() then
                        v.sg:GoToState("hit") 
                    end
                    v.components.combat:SetTarget(caster)
                end
            end
        end

    end)
end
function Rivencast:q1buff(pt, caster)
    local inst = caster
    inst.qconbine=1
    inst.qtimeout(inst)
end
function Rivencast:q2buff(pt, caster)
    local inst = caster
    inst.qconbine=2
    inst.qtimeout(inst)
end
function Rivencast:q3buff(pt, caster)
    local inst = caster
    local player=caster
    if caster:HasTag("qbuffon") then
        caster:RemoveTag("qbuffon")
    end
    caster.canq = false 
    if not caster:HasTag("q") then
        caster:AddTag("q")
    end
    caster.qconbine=0
    inst.removealltag(inst)
    inst.destoryq(inst)
    local inst=caster
    local QCD = 13
    player:DoTaskInTime(QCD*inst.cdtime*inst.changecdtimes, function() 
        inst.canq = true 
        inst.qconbine=0
        if inst:HasTag("q") then
            inst:RemoveTag("q")
        end
        if inst:HasTag("skillq") then
            inst:RemoveTag("skillq")
        end
        if inst:HasTag("qbuffon") then
            inst:RemoveTag("qbuffon")
        end
    end) 
end
function Rivencast:e1buff(pt, caster)
    local ECD = 10
    local player = caster
    local inst = caster
    if caster:HasTag("ebuffon") then
        caster:RemoveTag("ebuffon")
    end
    caster.cane = false
    if not caster:HasTag("e") then
        caster:AddTag("e")
    end
    player:DoTaskInTime(ECD*inst.cdtime*inst.changecdtimes, function() 
        inst.cane = true 
        inst.qconbine=0
        if inst:HasTag("e") then
            inst:RemoveTag("e")
        end
        if inst:HasTag("skille") then
            inst:RemoveTag("skille")
        end
        if inst:HasTag("ebuffon") then
            inst:RemoveTag("ebuffon")
        end
    end) 
end
function Rivencast:r1buff(pt, caster)
    caster:RemoveTag("rbuffon")
end
function Rivencast:q1attack(pt, caster)
    local player=caster
    pt = Vector3(caster.Transform:GetWorldPosition())
    local weapon  = caster.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) 
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 3)
    local backpack = player.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
    if backpack and backpack.components.container then
    else
        backpack = nil 
    end
    local hasDestory = false
    for k,v in pairs(ents) do
        if (v and v.components.container and v.components.container.canbeopened) 
            or (v and v.components.follower and v.components.follower.leader == caster) then
        elseif v and not (v:HasTag("mypet") or v:HasTag(player.belongtowhich) and (v.components.combat and v.components.combat.target~= caster) ) and v.components.combat and v.components.health and v.components.health:GetPercent() >= 0 and v ~= caster 
        and player.components.inventory and not player.components.inventory:GetItemSlot(v)
        and player.components.inventory:GetActiveItem()~=v
        and not (backpack and backpack.components.container:GetItemSlot(v))
        then
            local wdamage = 10
            if weapon and weapon.components.weapon then
             wdamage = weapon.components.weapon.damage
            end
            if  weapon and weapon.components.weapon and weapon.components.weapon.attackrange and weapon.components.weapon.attackrange>3 then 
                wdamage = wdamage /3
            end
            v.components.combat:GetAttacked(caster, wdamage*caster.charcritmulti*1)  
            if v.sg and not v.components.health:IsDead() then
                if v.sg and v.sg.sg and v.sg.sg.states and v.sg.sg.states.hit and not v.components.health:IsDead() then
                    v.sg:GoToState("hit")
                    shitswap("rivenq3").Transform:SetPosition(v:GetPosition():Get())
                    local fx = shitswap("firesplash_fx")
                    if not fx.components.highlight then
                        fx:AddComponent("highlight")
                    end
                    local frozenColor = Vector3(0/255,255/255,0/255)
                    local r,g,b = frozenColor.x,frozenColor.y,frozenColor.z
                    fx.components.highlight:SetAddColour(Vector3(r, g, b) )
                    fx.Transform:SetScale(0.5, 0.5, 0.5)
                    fx.Transform:SetPosition(v:GetPosition():Get())
                end 
                if v.components.combat then
                    v.components.combat:SetTarget(caster)
                end
            end
        elseif weapon and weapon.components.tool and not hasDestory and
            v and v.components.workable and v.components.workable.workleft > 0 
            and weapon.components.tool.action[v.components.workable.action]
            and player 
            and player.components.hunger
            then
            hasDestory = true 
            if  weapon and weapon.components.finiteuses and weapon.components.finiteuses.consumption[v.components.workable.action] then
                local cost=weapon.components.finiteuses.consumption[v.components.workable.action]*5
                if  weapon and weapon.components.finiteuses.current>cost then
                    weapon.components.finiteuses:Use(cost)
                else
                    weapon.components.finiteuses.current=1
                end
            end
            shitswap("collapse_small").Transform:SetPosition(v:GetPosition():Get())
            shitswap("collapse_small").Transform:SetPosition(v:GetPosition():Get())
            v.components.workable:Destroy(player)
            player.components.hunger:DoDelta(-10, false, true)
        end
    end
end
function Rivencast:q2attack(pt, caster)
    local player=caster
    pt = Vector3(caster.Transform:GetWorldPosition())
    local weapon  = caster.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) 
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 3)
    local backpack = player.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
    if backpack and backpack.components.container then
    else
        backpack = nil 
    end
    local hasDestory = false
    for k,v in pairs(ents) do
        if (v and v.components.container and v.components.container.canbeopened) 
            or (v and v.components.follower and v.components.follower.leader == caster) then
        elseif v and not (v:HasTag("mypet") or v:HasTag(player.belongtowhich) and (v.components.combat and v.components.combat.target~= caster)) and v.components.combat and v.components.health and v.components.health:GetPercent() >= 0 and v ~= caster 
        and player.components.inventory and not player.components.inventory:GetItemSlot(v)
        and player.components.inventory:GetActiveItem()~=v
        and not (backpack and backpack.components.container:GetItemSlot(v))
        then
            local wdamage = 10
            if  weapon and weapon.components.weapon then
             wdamage = weapon.components.weapon.damage
            end
            if  weapon and weapon.components.weapon and weapon.components.weapon.attackrange and weapon.components.weapon.attackrange>3 then 
                wdamage = wdamage /3
            end
            v.components.combat:GetAttacked(caster, weapon.components.weapon.damage*caster.charcritmulti*1)  
            if v.sg and not v.components.health:IsDead() then
                if v.sg and v.sg.sg and v.sg.sg.states and v.sg.sg.states.hit and not v.components.health:IsDead() then
                    v.sg:GoToState("hit")
                    shitswap("rivenq3").Transform:SetPosition(v:GetPosition():Get())
                    local fx = shitswap("firesplash_fx")
                    if not fx.components.highlight then
                        fx:AddComponent("highlight")
                    end
                    local frozenColor = Vector3(0/255,255/255,0/255)
                    local r,g,b = frozenColor.x,frozenColor.y,frozenColor.z
                    fx.components.highlight:SetAddColour(Vector3(r, g, b) )
                    fx.Transform:SetScale(0.5, 0.5, 0.5)
                    fx.Transform:SetPosition(v:GetPosition():Get())
                end 
                if v.components.combat then
                    v.components.combat:SetTarget(caster)
                end
            end
        elseif weapon and weapon.components.tool and not hasDestory and
            v and v.components.workable and v.components.workable.workleft > 0 
            and weapon.components.tool.action[v.components.workable.action]
            and player 
            and player.components.hunger
            then
            hasDestory = true
            if  weapon and weapon.components.finiteuses and weapon.components.finiteuses.consumption[v.components.workable.action] then
                local cost=weapon.components.finiteuses.consumption[v.components.workable.action]*5
                if  weapon and weapon.components.finiteuses.current>cost then
                    weapon.components.finiteuses:Use(cost)
                else
                    weapon.components.finiteuses.current=1
                end
            end
            shitswap("collapse_small").Transform:SetPosition(v:GetPosition():Get())
            shitswap("collapse_small").Transform:SetPosition(v:GetPosition():Get())
            v.components.workable:Destroy(player)
            player.components.hunger:DoDelta(-10, false, true)
        end
    end
end
function Rivencast:q3attack(pt, caster)
    local player=caster
    local weapon  = caster.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) 
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 4)
    local backpack = player.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
    if backpack and backpack.components.container then
    else
        backpack = nil 
    end
    local hasDestory = false
    for k,v in pairs(ents) do
        if (v and v.components.container and v.components.container.canbeopened) 
            or (v and v.components.follower and v.components.follower.leader == caster) then
        elseif v and not (v:HasTag("mypet") or v:HasTag(player.belongtowhich) and (v.components.combat and v.components.combat.target~= caster)) and v.components.combat and v.components.health and v.components.health:GetPercent() >= 0 and v ~= caster 
        and player.components.inventory and not player.components.inventory:GetItemSlot(v)
        and player.components.inventory:GetActiveItem()~=v
        and not (backpack and backpack.components.container:GetItemSlot(v))
        then
            local wdamage = 10
            if  weapon and weapon.components.weapon then
             wdamage = weapon.components.weapon.damage
            end
            if  weapon and weapon.components.weapon and weapon.components.weapon.attackrange and weapon.components.weapon.attackrange>3 then 
                wdamage = wdamage /3
            end
            v.components.combat:GetAttacked(caster, wdamage*caster.charcritmulti*1.2)  
            if v.sg and not v.components.health:IsDead() then
                if v.brain then
                    v.brain:Stop()
                end
                local x2, y2, z2 = v:GetPosition():Get()
                local sign=1
                v.task1 = v:DoPeriodicTask(0.05,  function()
                    local x3, y3, z3 = v:GetPosition():Get()
                    v.Transform:SetPosition(x2, y3+0.7*sign, z2)
                end)
                v:DoTaskInTime(0.3, function() 
                    sign=-1
                end)
                v:DoTaskInTime(0.6, function() 
                    v.task1:Cancel()
                    v.task1 = nil
                    v.Transform:SetPosition(x2, y2, z2)
                end)

                v.components.combat:BlankOutAttacks(1)
                if v.components.combat then
                    v.components.combat:SetTarget(nil)
                end
                if v.sg and v.sg.sg and v.sg.sg.states and v.sg.sg.states.hit and not v.components.health:IsDead() then
                    v.sg:GoToState("hit")
                    shitswap("rivenq3").Transform:SetPosition(v:GetPosition():Get())
                    local fx = shitswap("firesplash_fx")
                    if not fx.components.highlight then
                        fx:AddComponent("highlight")
                    end
                    local frozenColor = Vector3(0/255,255/255,0/255)
                    local r,g,b = frozenColor.x,frozenColor.y,frozenColor.z
                    fx.components.highlight:SetAddColour(Vector3(r, g, b) )
                    fx.Transform:SetScale(0.5, 0.5, 0.5)
                    fx.Transform:SetPosition(v:GetPosition():Get())
                end
                v:DoTaskInTime(1, function() 
                    if v.brain then
                        v.brain:Start()
                    end
                end)
                v:DoTaskInTime(1.5, function() 
                    if v.components.combat then
                        v.components.combat:SetTarget(caster)
                    end
                end)
            end
        elseif weapon and weapon.components.tool and not hasDestory and
            v and v.components.workable and v.components.workable.workleft > 0 
            and weapon.components.tool.action[v.components.workable.action]
            and player 
            and player.components.hunger
            then
            hasDestory = true 
            if  weapon and weapon.components.finiteuses and weapon.components.finiteuses.consumption[v.components.workable.action] then
                local cost=weapon.components.finiteuses.consumption[v.components.workable.action]*5
                if  weapon and weapon.components.finiteuses.current>cost then
                    weapon.components.finiteuses:Use(cost)
                else
                    weapon.components.finiteuses.current=1
                end
            end
            shitswap("collapse_small").Transform:SetPosition(v:GetPosition():Get())
            shitswap("collapse_small").Transform:SetPosition(v:GetPosition():Get())
            v.components.workable:Destroy(player)
            player.components.hunger:DoDelta(-10, false, true)
        end
    end
end
function Rivencast:e1attack(pt, caster)
end
function Rivencast:r1attack(pt, caster)
end
return Rivencast