local assets=
{ 
    Asset("ANIM", "anim/rivenarsenallib.zip"), 
    Asset("ATLAS", "images/inventoryimages/rivenarsenal.xml"),  
    Asset("IMAGE", "images/inventoryimages/rivenarsenal.tex"),
}
local prefabs = 
{
}
local function addDamage(player,weapon)
    if weapon and weapon.components.weapon then
    weapon.components.weapon:SetDamage(weapon.defaultDamage+weapon.gemlevel)
    if weapon.gemlevel >0 then
        weapon.name = string.format("gareb%sweapon(+%d)",weapon.weaponname,weapon.gemlevel)
    else
        weapon.name = string.format("gareb%sweapon",weapon.weaponname)
    end
    weapon.components.inspectable:SetDescription(
        string.format("damage(%d) defend(%d) speed(%d) heal(%d) cd(%d) crit(%d)\n \n \n  \n "
        , weapon.defaultDamage+weapon.gemlevel
        , weapon.bluegem
        , weapon.yellowgem
        , weapon.greengem
        , weapon.purplegem
        , weapon.orangegem
        ))
    end
end
local function weaponLigth(player,weapon)
    if weapon and weapon.gemlevel >=10 then 
        local light = weapon.entity:AddLight()
        light:SetFalloff(.4)
        light:SetIntensity(.8)
        light:SetRadius(.3+(weapon.gemlevel-10)*0.03)
        light:Enable(true)
        light:SetColour(255/255, 0/255, 0/255) 
    end
end
local function commonfn(weaponname)
    local function onfinished(inst)
        inst:Remove()
    end
    local function onequip(inst, owner)
        local player=GetPlayer()
        player.setbaseattr(player,player.mylevel()-1,1,inst)
        owner.AnimState:OverrideSymbol("swap_object", "rivenarsenallib", weaponname.."/swap_"..weaponname)
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
        weaponLigth(owner,inst)
    end
    local function onunequip(inst, owner) 
        local player=GetPlayer()
        player.setbaseattr(player,player.mylevel()-1,0,inst)
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end
    local player = GetPlayer()
    local inst = CreateEntity()
    inst.weaponname=weaponname
    inst.supportfueltype = {
        ["purplegem"] = true,
        ["bluegem"] = true,
        ["gemlevel"] = true,
        ["orangegem"] = true,
        ["yellowgem"] = true,
        ["greengem"] = true,
    }
    inst.addDamage=addDamage
    inst.gemlevel = 0
    inst.purplegem = 0
    inst.bluegem = 0
    inst.orangegem = 0
    inst.yellowgem = 0
    inst.greengem = 0
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    anim:SetBank(weaponname)
    anim:SetBuild("rivenarsenallib")
    anim:PlayAnimation("GROUND")
    if IsDLCEnabled and CAPY_DLC  and IsDLCEnabled(CAPY_DLC) then
        MakeInventoryFloatable(inst, "FLOAT", "GROUND")
    end
    inst:AddTag("sharp")
    inst:AddComponent("weapon")
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.SPEAR_USES)
    inst.components.finiteuses:SetUses(TUNING.SPEAR_USES)
    inst.components.finiteuses:SetOnFinished( onfinished )
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.inventoryitem.imagename = weaponname 
    inst.components.inventoryitem.atlasname = "images/inventoryimages/rivenarsenal.xml"
    inst.defaultDamage=math.ceil((math.random()*1.2+0.4)*TUNING.SPEAR_DAMAGE)
    inst.components.weapon:SetDamage(inst.defaultDamage)
    local function TakeItem(inst)
        addDamage(player,inst)
        player.setbaseattr(player,player.mylevel()-1)
        if inst.gemlevel >0 then
            inst.name = string.format("gareb%sweapon(+%d)",inst.weaponname,inst.gemlevel)
            local hand  = player.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) 
            if inst.gemlevel >=10 and hand and hand==inst then 
                weaponLigth(player,inst)
            end
        end
    end
    inst:AddComponent("tradable")
    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "RIVENFUEL"
    inst.components.fueled:InitializeFuelLevel(20000000)
    inst.components.fueled.ontakefuelfn = TakeItem
    inst.components.fueled.accepting = true
    inst.components.fueled:StopConsuming()
    inst:AddTag("rivenweapon")
    local function onpreload(inst, data)
        if not data then
            data={}
        end
        if data.weaponname then
            inst.weaponname = data.weaponname
        else
            inst.weaponname = weaponname
        end
        if data.defaultDamage then
            inst.defaultDamage = data.defaultDamage
        else
            inst.defaultDamage = math.ceil((math.random()*0.3+0.7)*TUNING.SPEAR_DAMAGE)
        end
        if data.defaultDamage then
            inst.defaultDamage = data.defaultDamage
        else
            inst.defaultDamage = math.ceil((math.random()*0.3+0.7)*TUNING.SPEAR_DAMAGE)
        end

        if data.gemlevel then
            inst.gemlevel = data.gemlevel
        else
            inst.gemlevel = 0
        end
        if inst.gemlevel >0 then
            inst.name = string.format("gareb%sweapon(+%d)",inst.weaponname,inst.gemlevel)
        else
            inst.name = inst.weaponname
        end
        
        if data.purplegem then
            inst.purplegem = data.purplegem
        else
            inst.purplegem = 0
        end

        if data.bluegem then
            inst.bluegem = data.bluegem
        else
            inst.bluegem = 0
        end

        if data.orangegem then
            inst.orangegem = data.orangegem
        else
            inst.orangegem = 0
        end

        if data.yellowgem then
            inst.yellowgem = data.yellowgem
        else
            inst.yellowgem = 0
        end

        if data.greengem then
            inst.greengem = data.greengem
        else
            inst.greengem = 0
        end     

        if inst.purplegem>=10 then 
            inst.supportfueltype["purplegem"] = false
        end
        if inst.bluegem>=10 then 
            inst.supportfueltype["bluegem"] = false
        end
        if inst.orangegem>=10 then 
            inst.supportfueltype["orangegem"] = false
        end
        if inst.yellowgem>=10 then 
            inst.supportfueltype["yellowgem"] = false
        end
        if inst.greengem>=10 then 
            inst.supportfueltype["greengem"] = false
        end
        if inst.gemlevel>=30 then 
            inst.supportfueltype["gemlevel"] = false
        end
        addDamage(player,inst)
    end
    local function onsave(inst, data)
        if inst.weaponname then
            data.weaponname=inst.weaponname
        else
            data.weaponname=weaponname
        end
        if inst.defaultDamage then
            data.defaultDamage=inst.defaultDamage
        else
            data.defaultDamage=math.ceil((math.random()+0.5)*TUNING.SPEAR_DAMAGE)
        end

        if inst.gemlevel then
            data.gemlevel=inst.gemlevel
        else
            data.gemlevel=0
        end

        if inst.purplegem then
            data.purplegem=inst.purplegem
        else
            data.purplegem=0
        end

        if inst.bluegem then
            data.bluegem=inst.bluegem
        else
            data.bluegem=0
        end

        if inst.orangegem then
            data.orangegem=inst.orangegem
        else
            data.orangegem=0
        end

        if inst.yellowgem then
            data.yellowgem=inst.yellowgem
        else
            data.yellowgem=0
        end

        if inst.greengem then
            data.greengem=inst.greengem
        else
            data.greengem=0
        end
    end
    inst.OnSave = onsave
    inst.OnPreLoad = onpreload
    addDamage(player,inst)
    return inst
end
local function rivenaxetype(weaponname)
    local inst=commonfn(weaponname)
    inst.fixeffect=1.2
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 1.5)
    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
    return inst
end
local function rivenspeartype(weaponname)
    local inst=commonfn(weaponname)
    inst.components.weapon:SetRange(1.5)
    inst.period=1.2
    inst.defaultDamage=math.ceil(inst.defaultDamage*0.9)
    inst.components.weapon:SetDamage(inst.defaultDamage)
    addDamage(nil,inst)
    return inst
end
local function rivenknifetype(weaponname)
    local inst=commonfn(weaponname)
    inst.period=0.5
    inst.defaultDamage=math.ceil(inst.defaultDamage*0.55)
    inst.components.weapon:SetDamage(inst.defaultDamage)
    addDamage(nil,inst)
    return inst
end
local function rivenhammertype(weaponname)
    local inst=commonfn(weaponname)
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.HAMMER)
    inst.components.finiteuses:SetConsumption(ACTIONS.HAMMER, 2)
    inst.components.weapon:SetRange(1)
    inst.defaultDamage=math.ceil(inst.defaultDamage*1.13)
    inst.components.weapon:SetDamage(inst.defaultDamage)
    inst.period=1.4
    addDamage(nil,inst)
    return inst
end
local function rivenswordtype(weaponname)
    return commonfn(weaponname)
end
local function rivenblunttype(weaponname)
    local inst=commonfn(weaponname)
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.HAMMER)
    inst.components.finiteuses:SetConsumption(ACTIONS.HAMMER, 2)
    inst.defaultDamage=math.ceil(inst.defaultDamage*1.07)
    inst.components.weapon:SetDamage(inst.defaultDamage)
    inst.period=1.3
    addDamage(nil,inst)
    return inst
end
local function rivenbowtype(weaponname)
    local inst=commonfn(weaponname)
    inst.fixeffect=0.12
    inst.components.finiteuses:SetMaxUses(TUNING.SPEAR_USES/10)
    inst.components.finiteuses:SetUses(TUNING.SPEAR_USES/10)
    inst.period=3
    inst.defaultDamage=math.ceil(inst.defaultDamage*1.13)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetDamage(inst.defaultDamage)
    addDamage(nil,inst)
    inst:AddTag("rivenbowtype")
    return inst
end
local function rivenstafftype(weaponname)
    local inst=commonfn(weaponname)
    inst.components.weapon:SetRange(1)
    inst.period=1.3
    addDamage(nil,inst)
    return inst
end
local function rivenwandtype(weaponname)
    return rivenknifetype(weaponname)
end
local function riven1() return rivenswordtype("riven1") end
local function riven2() return rivenswordtype("riven2") end
local function riven3() return rivenblunttype("riven3") end
local function riven4() return rivenswordtype("riven4") end
local function riven5() return rivenspeartype("riven5") end
local function riven6() return rivenblunttype("riven6") end
local function riven7() return rivenswordtype("riven7") end
local function riven8() return rivenwandtype("riven8") end
local function riven9() return rivenwandtype("riven9") end
local function riven10() return rivenblunttype("riven10") end
local function riven11() return rivenblunttype("riven11") end
local function riven12() return rivenwandtype("riven12") end
local function riven13() return rivenwandtype("riven13") end
local function riven14() return rivenwandtype("riven14") end
local function riven15() return rivenswordtype("riven15") end
local function riven16() return rivenstafftype("riven16") end
local function riven17() return rivenstafftype("riven17") end
local function riven18() return rivenstafftype("riven18") end
local function riven19() return rivenstafftype("riven19") end
local function riven20() return rivenaxetype("riven20") end
local function riven21() return rivenaxetype("rivenaxe") end
local function riven22() return rivenspeartype("rivenpike") end
local function riven23() return rivenknifetype("rivencatsword") end
local function riven24() return rivenhammertype("rivencth") end
local function riven25() return rivenbowtype("rivenfeatherbow") end
local function riven26() return rivenstafftype("rivenwhitewand") end
return 
Prefab("common/inventory/rivenweapon1", riven1, assets, prefabs),
Prefab("common/inventory/rivenweapon2", riven2, assets, prefabs),
Prefab("common/inventory/rivenweapon3", riven3, assets, prefabs),
Prefab("common/inventory/rivenweapon4", riven4, assets, prefabs),
Prefab("common/inventory/rivenweapon5", riven5, assets, prefabs),
Prefab("common/inventory/rivenweapon6", riven6, assets, prefabs),
Prefab("common/inventory/rivenweapon7", riven7, assets, prefabs),
Prefab("common/inventory/rivenweapon8", riven8, assets, prefabs),
Prefab("common/inventory/rivenweapon9", riven9, assets, prefabs),
Prefab("common/inventory/rivenweapon10", riven10, assets, prefabs),
Prefab("common/inventory/rivenweapon11", riven11, assets, prefabs),
Prefab("common/inventory/rivenweapon12", riven12, assets, prefabs),
Prefab("common/inventory/rivenweapon13", riven13, assets, prefabs),
Prefab("common/inventory/rivenweapon14", riven14, assets, prefabs),
Prefab("common/inventory/rivenweapon15", riven15, assets, prefabs),
Prefab("common/inventory/rivenweapon16", riven16, assets, prefabs),
Prefab("common/inventory/rivenweapon17", riven17, assets, prefabs),
Prefab("common/inventory/rivenweapon18", riven18, assets, prefabs),
Prefab("common/inventory/rivenweapon19", riven19, assets, prefabs),
Prefab("common/inventory/rivenweapon26", riven26, assets, prefabs),
Prefab("common/inventory/rivenweapon20", riven20, assets, prefabs),
Prefab("common/inventory/rivenweapon21", riven21, assets, prefabs),
Prefab("common/inventory/rivenweapon22", riven22, assets, prefabs),
Prefab("common/inventory/rivenweapon23", riven23, assets, prefabs),
Prefab("common/inventory/rivenweapon24", riven24, assets, prefabs),
Prefab("common/inventory/rivenweapon25", riven25, assets, prefabs)
