local assets=
{
	Asset( "ANIM", "anim/player_basic.zip" ),
	Asset( "ANIM", "anim/player_idles_shiver.zip" ),
	Asset( "ANIM", "anim/player_actions.zip" ),
	Asset( "ANIM", "anim/player_actions_axe.zip" ),
	Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
	Asset( "ANIM", "anim/player_actions_shovel.zip" ),
	Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
	Asset( "ANIM", "anim/player_actions_eat.zip" ),
	Asset( "ANIM", "anim/player_actions_item.zip" ),
	Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
	Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
	Asset( "ANIM", "anim/player_actions_fishing.zip" ),
	Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
	Asset( "ANIM", "anim/player_bush_hat.zip" ),
	Asset( "ANIM", "anim/player_attacks.zip" ),
	Asset( "ANIM", "anim/player_idles.zip" ),
	Asset( "ANIM", "anim/player_rebirth.zip" ),
	Asset( "ANIM", "anim/player_jump.zip" ),
	Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
	Asset( "ANIM", "anim/player_teleport.zip" ),
	Asset( "ANIM", "anim/wilson_fx.zip" ),
	Asset( "ANIM", "anim/player_one_man_band.zip" ),
}

SetSharedLootTable( 'rivenmember',
{
	{'spear',          0.05},
	{'armorwood',          0.10},
	{'footballhat',          0.10},
	{'smallmeat_dried',          0.20},
	{'smallmeat_dried',          0.20},
	{'monstermeat_dried',          0.50},
	{'monstermeat_dried',          0.50},
	{'meat_dried',          0.10},
	{'goldnugget',          0.10},
	{'marble',          0.05},
	{'flint',          0.50},
	{'twigs',          0.50},
	{'twigs',          0.50},
	{'cutgrass',          0.50},
	{'cutgrass',          0.50},
	{'rocks',          0.50},
	{'purplegem',          0.01},
	{'bluegem',          0.05},
	{'redgem',          0.05},
	{'orangegem',          0.01},
	{'yellowgem',          0.01},
	{'greengem',          0.01},
	{'rivensoulball',          0.02},
	{'rivensoulballwhite',          0.02},
})
local dialog = {
	"hehe"
}
local catcoonprefabs = 
{
	"bee",
	"butterfly",
	"fireflies",
	"papyrus",
	"tallbirdegg",
	"carrot_seeds",
	"corn_seeds",
	"pumpkin_seeds",
	"eggplant_seeds",
	"durian_seeds",
	"pomegranate_seeds",
	"dragonfruit_seeds",
	"watermelon_seeds",
	"pigskin",
	"mosquito",
	"wormlight",
	"rabbit",
	"thulecite_pieces",
	"mosquitosack",
	"manrabbit_tail",
	"foliage",
	"eel",
	"meatballs",
	"baconeggs",
	"butterflymuffin",
	"frogglebunwich",
	"taffy",
	"stuffedeggplant",
	"fishsticks",
	"honeynuggets",
	"kabobs",
	"turkeydinner",
	"jammypreserves",
	"fishtacos",
	"monsterlasagna",
	"powcake",
	"ratatouille",
}

local catcoonprefabs2 = 
{
	"bee",
	"butterfly",
	"fireflies",
	"papyrus",
	"tallbirdegg",
	"carrot_seeds",
	"corn_seeds",
	"pumpkin_seeds",
	"eggplant_seeds",
	"durian_seeds",
	"pomegranate_seeds",
	"dragonfruit_seeds",
	"watermelon_seeds",
	"pigskin",
	"mosquito",
	"wormlight",
	"rabbit",
	"thulecite_pieces",
	"mosquitosack",
	"manrabbit_tail",
	"foliage",
	"eel",
	"mole",
	"goose_feather",
	"batwing",
	"meatballs",
	"baconeggs",
	"butterflymuffin",
	"frogglebunwich",
	"taffy",
	"stuffedeggplant",
	"fishsticks",
	"honeynuggets",
	"kabobs",
	"turkeydinner",
	"jammypreserves",
	"fishtacos",
	"monsterlasagna",
	"powcake",
	"ratatouille",
}

local catcoonprefabs3 = 
{
	"bee",
	"butterfly",
	"fireflies",
	"papyrus",
	"tallbirdegg",
	"carrot_seeds",
	"corn_seeds",
	"pumpkin_seeds",
	"eggplant_seeds",
	"durian_seeds",
	"pomegranate_seeds",
	"dragonfruit_seeds",
	"watermelon_seeds",
	"pigskin",
	"blubber",
	"crab",
	"fish_med",
	"lobster",
	"mussel",
	"venomgland",
	"blubber",
	"meatballs",
	"baconeggs",
	"butterflymuffin",
	"frogglebunwich",
	"taffy",
	"stuffedeggplant",
	"fishsticks",
	"honeynuggets",
	"kabobs",
	"turkeydinner",
	"jammypreserves",
	"fishtacos",
	"monsterlasagna",
	"powcake",
	"ratatouille",
}

local reward = 
{
	'hambat',
	'hambat',
	'hambat',
	'armorwood',
	'armorwood',
	'armorwood',
	'footballhat',
	'footballhat',
	'footballhat',
	'beemine',
	'beemine',
	'beemine',
	'trap_teeth',
	'trap_teeth',
	'trap_teeth',
	'meat_dried',
	'meat_dried',
	'marble',
	'marble',
	'gunpowder',
	'gunpowder',
	'gunpowder',
	'gunpowder',
	'gears',
	'purplegem',
	'bluegem',
	'redgem',
	'orangegem',
	'yellowgem',
	'greengem',
	'mandrake',
	'nightsword',
	'armor_sanity',
	'batbat',
	'rivensoulball',
	'rivensoulballwhite',
}



local function showtask( inst )
	if inst.taskitem ~= nil and inst.belongtowhich==TUNING.RIVENBELONG then
		inst.taskicon = shitswap("riventask")
		inst.taskicon.Transform:SetPosition(0, 2.5 ,0)
		inst.taskicon.Transform:SetScale(1.2, 1.2, 1.2)
		inst.taskicon.entity:SetParent(inst.entity) 
	end
end

local function createTask( inst )
	if inst.taskitem == nil and inst.belongtowhich==TUNING.RIVENBELONG then
		if IsDLCEnabled and CAPY_DLC and IsDLCEnabled(CAPY_DLC) then
		    inst.taskitem=catcoonprefabs3[math.random(#catcoonprefabs3)]
		elseif IsDLCEnabled and REIGN_OF_GIANTS and IsDLCEnabled(REIGN_OF_GIANTS) then
			inst.taskitem=catcoonprefabs2[math.random(#catcoonprefabs2)]
		else
			inst.taskitem=catcoonprefabs[math.random(#catcoonprefabs)]
		end
	end
	showtask( inst )
end 
local function setbuild2( inst )
	table.insert(assets, Asset( "ANIM", string.format("anim/%s.zip",inst.charanm)))
	inst.AnimState:SetBuild(inst.charanm)
end
local function daytimefn(inst)
    inst.AnimState:OverrideSymbol("swap_object", "swap_lantern", "swap_lantern_on")
    inst.Light:Enable(false)
    if inst.myweapon == "swap_staffs" then
    	inst.AnimState:OverrideSymbol("swap_object", inst.myweapon, "redstaff")
    else
    	inst.AnimState:OverrideSymbol("swap_object", inst.myweapon, inst.myweapon)
    end
end
local function dusktimefn(inst)
   inst.AnimState:OverrideSymbol("swap_object", "swap_lantern", "swap_lantern_on")
   inst.Light:Enable(true)
   inst.Light:SetRadius(1)
   inst.Light:SetFalloff(.4)
   inst.Light:SetIntensity(.4)
   inst.Light:SetColour(235/255,121/255,12/255)
end

local function OnGetItemFromPlayer(inst, giver, item)
	inst.sg:GoToState("idle")
	if inst.taskitem and item.prefab==inst.taskitem then
    	inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
    	inst.components.talker:Say("3Q")
    	local player=GetPlayer()
    	if player.mylevel()<18 then
    		local money = math.random(100)
    		local expvaluenum = math.ceil((math.random(player.mylevel())*10)*math.random())
    		player.money=player.money+money
    	    player.expvaluenum=player.expvaluenum+expvaluenum
    	    player.refreshlevel(player)
    	    player.CreateDamageIndicator(player,string.format("exp+%s",expvaluenum),0,1,0)
    	    player:DoTaskInTime(1, function() 
    	    	player.CreateDamageIndicator(player,string.format("money+%s",money),1,1,0)
    	    end)
    	end
    	inst:ForceFacePoint(giver:GetPosition():Get())
    	inst.sg:GoToState("give")
    	inst.taskitem=nil
    	if inst.taskicon then
    		inst.taskicon:Remove()
    	end
    	for i = 1, math.random(3) do 
    	    shitswap(reward[math.random(#reward)]).Transform:SetPosition(inst:GetPosition():Get()) 
    	end 
    	shitswap('goldnugget').Transform:SetPosition(inst:GetPosition():Get()) 
    elseif item.prefab=='goldnugget' and inst.belongtowhich==giver.belongtowhich then
		inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
		inst.components.talker:Say("Since bullied on the outside, let brother help you chant")
		giver.components.leader:AddFollower(inst)
		inst.components.follower:AddLoyaltyTime(TUNING.TOTAL_DAY_TIME*3)
	elseif item.components.weapon or item.components.armor then
		inst.components.talker:Say("equipment! nice")
		inst.sg:GoToState("talk")
	elseif item.components.edible and item.components.edible.hungervalue and item.components.edible.hungervalue>10 then
		inst.components.talker:Say("I'm hungry ")
		inst.sg:GoToState("eat")
		inst.components.health:DoDelta(item.components.edible.hungervalue)
	else
		inst.components.talker:Say("Thank you, although it does not have any use")
		inst.sg:GoToState("talk")
	end
	if item then
		item:Remove()
	end

end

local function OnWaterChange(inst, onwater)
	if inst.fx then
		if inst.fx.task then
			inst.fx.task:Cancel()
			inst.fx.task=nil
		end
		inst.fx:Remove()
		inst.fx=nil
	end
	if onwater then
		inst.onwater=true
		inst.components.talker:Say("I have ship !")
		inst.fx = CreateEntity()
		inst.fx.entity:AddTransform()
		inst.fx.Transform:SetFourFaced()
		inst.fx.entity:AddAnimState()
	    inst.fx.AnimState:SetBank("rowboat")
		inst.fx.AnimState:SetBuild("rowboat_build")
		inst.fx.AnimState:PlayAnimation("run_loop", true)
		inst.fx.Transform:SetPosition(0, -0.2, 0)
		inst.fx.entity:SetParent(inst.entity)
		inst.fx.task = inst.fx:DoPeriodicTask(0.3, function ( )
			inst.fx.Transform:SetRotation(inst.Transform:GetRotation(inst))
		end)
		inst.fx.OnSave = function (this, data)
			if this.task then
				this.task:Cancel()
				this.task=nil
			end
			this:Remove()
		end
		inst.fx.OnPreLoad = function (this, data)
			if this.task then
				this.task:Cancel()
				this.task=nil
			end
			this:Remove()
		end
	else
		inst.onwater=false
	end
end

local function OnAttacked(inst, data)
    local attacker = data and data.attacker
    if attacker and inst.components.combat:CanTarget(attacker) and not (attacker:HasTag(inst.belongtowhich) and not attacker:HasTag("character")) then
        inst.components.combat:SetTarget(attacker)
        local x1, y1, z1 = inst.Transform:GetWorldPosition()
        local x2, y2, z2 = attacker.Transform:GetWorldPosition()
        local dist = math.sqrt((x1-x2)*(x1-x2) + (z1-z2)*(z1-z2))
        if inst.calculate>0 and dist<3 then
	   		inst.calculate = inst.calculate - 1
	   		inst.hurttime=inst.hurttime+1
	    end
        inst.components.combat:ShareTarget(attacker, 30, function(dude)
        if dude:HasTag("character") then
        	return false
        end
        if attacker:HasTag("character") then
        	return dude:HasTag(inst.belongtowhich)
        end
        return dude:HasTag(inst.belongtowhich) and not dude:HasTag("character")
               and not dude.components.health:IsDead()
               and (not attacker:HasTag(inst.belongtowhich) and not attacker:HasTag("character") )
        end, 10)
    end
end

local function onsave(inst, data)
	if inst.fx then
		if inst.fx.task then
			inst.fx.task:Cancel()
			inst.fx.task=nil
		end
		inst.fx:Remove()
		inst.fx=nil
	end

	if inst.berry then
	    data.berry=inst.berry
	end
	if inst.taskitem then
	    data.taskitem=inst.taskitem
	end
    if inst.belongtowhich then
        data.belongtowhich=inst.belongtowhich
    end
    if inst.enemywhich then
        data.enemywhich=inst.enemywhich
    end
    if inst.myhat then
        data.myhat=inst.myhat
    end
    if inst.myarmor then
        data.myarmor=inst.myarmor
    end
    if inst.myweapon then
        data.myweapon=inst.myweapon
    end
	if inst.charanm then
		data.charanm=inst.charanm
	end   
end

local function onpreload(inst, data)
	if not data then
		return
	end
    if data.belongtowhich then
        inst.belongtowhich = data.belongtowhich
    end
    if data.berry then
        inst.berry = data.berry
    end
    if data.taskitem then
        inst.taskitem = data.taskitem
    end
    if data.enemywhich then
        inst.enemywhich = data.enemywhich
    end
    if data.myhat then
        inst.myhat = data.myhat
    end
    if data.myarmor then
        inst.myarmor = data.myarmor
    end
    if data.myweapon then
        inst.myweapon = data.myweapon
    end
    if data.charanm then
        inst.charanm = data.charanm
    end
    if Prefabs[inst.charanm] then
    	setbuild2(inst)	
    else
	    inst.AnimState:SetBuild("wilson")	
    end
    
    inst:RemoveTag('demaciamem')
    inst:RemoveTag('noxusmem')
    inst:AddTag(inst.belongtowhich)
    inst:RemoveTag("companion")
    inst:RemoveTag("hostile")
    if inst.belongtowhich==TUNING.RIVENBELONG then
    	inst:AddTag("companion")
	else
		inst:AddTag("hostile")
    end
    inst.components.inspectable:SetDescription(string.format("%s%s",inst.belongtowhich,inst.charanm))
    inst.name = string.format("%s%s",inst.belongtowhich,inst.charanm)

    if not (inst.myhat == "hat_flower" or inst.myhat == "hat_earmuffs") then
	    inst.AnimState:Show("HAT")
	    inst.AnimState:Show("HAT_HAIR")
	    inst.AnimState:Hide("HAIR_NOHAT")
	    inst.AnimState:Hide("HAIR")
    else 
   		inst.AnimState:Show("HAIR_NOHAT")
    	inst.AnimState:Show("HAIR")
    end

    inst.AnimState:OverrideSymbol("swap_hat", inst.myhat, "swap_hat")
    inst.AnimState:OverrideSymbol("swap_body", inst.myarmor, "swap_body")
    if inst.myweapon == "swap_staffs" then
    	inst.AnimState:OverrideSymbol("swap_object", inst.myweapon, "redstaff")
    else
    	inst.AnimState:OverrideSymbol("swap_object", inst.myweapon, inst.myweapon)
    end
    if inst.myweapon == "swap_blowdart" or inst.myweapon == "swap_staffs" then
   		inst.dart=0.75
   		inst.components.locomotor.walkspeed= inst.walkspeed*inst.dart
   		inst.components.locomotor.runspeed = inst.runspeed*inst.dart
    	inst.components.combat:SetAttackPeriod(inst.oldperiod*2)
    	inst.components.combat:SetRange(8,10)
	else
		inst.components.combat:SetAttackPeriod(inst.oldperiod)
    	inst.components.combat:SetRange(1.5)	
    end
    local time = GetClock().phase
    if time=="dusk" or time=="night" then
    	dusktimefn(inst)
    else 
    	daytimefn(inst)
    end
    inst:RemoveComponent("lootdropper")
    inst:AddComponent("lootdropper")
    if inst.belongtowhich~=TUNING.RIVENBELONG then
    	inst.components.lootdropper:SetChanceLootTable('rivenmember')
    	inst.components.trader.enabled=false
    else
    	inst.components.trader.enabled=true
    end



    showtask( inst )
end


local function RetargetFn(inst)
    local invader = FindEntity(inst, 15, function(guy)
    	local target = ((guy:HasTag(inst.enemywhich) or (inst.belongtowhich==TUNING.RIVENBELONG and (guy:HasTag("monster") and (not inst.components.follower.leader or (inst.components.follower.leader and guy.components.combat and guy.components.combat.target==inst.components.follower.leader)) ))
        or (inst.components.follower.leader and not guy:HasTag(inst.belongtowhich) and inst.components.follower.leader.components.combat.target==guy))
        and not guy:HasTag(inst.belongtowhich)) or (inst.components.follower.leader and guy.components.combat and guy.components.combat.target==inst.components.follower.leader and not guy:HasTag(inst.belongtowhich))
    	if math.random()<0.3 and target then
	    	if guy:HasTag("character") and guy:HasTag(inst.enemywhich) or inst.components.combat.target==guy then
				inst.components.talker:Say("Experience come here!")
	        end
        end
        return target and 
        not (guy:HasTag(inst.belongtowhich) and not guy:HasTag("character"))
    end)
    return invader
end
local function KeepTargetFn(inst, target)
    local home = inst.components.homeseeker and inst.components.homeseeker.home
    if home and not inst.components.follower.leader and not inst.components.health:IsDead() then
        return home:GetDistanceSqToInst(target) < 60*60
               and home:GetDistanceSqToInst(inst) < 60*60
    end
    return target and inst.components.combat:CanTarget(target) and
    not (target:HasTag(inst.belongtowhich) and not target:HasTag("character"))
end

local function fn(inst)
	inst.belonger = 'riven'
	if GetPlayer() and not GetPlayer().mylevel then
		GetPlayer().mylevel = function ( )
			return 1
		end
	end
	inst.fx = nil
	inst:AddTag("scarytoprey")
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 1.5, .75 )
    inst.Transform:SetFourFaced()
    inst.hurttime=0
    if IsDLCEnabled(CAPY_DLC) then
        MakeAmphibiousCharacterPhysics(inst, 50, .5)
        MakeInventoryFloatable(inst, "idle", "idle")
        inst:AddComponent("tiletracker")
        inst.components.tiletracker:SetOnWaterChangeFn(OnWaterChange)
        inst.components.tiletracker:Start()
    else
        MakeCharacterPhysics(inst, 50, .5)
        inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
        inst.Physics:ClearCollisionMask()
        inst.Physics:CollidesWith(COLLISION.WORLD)
        inst.Physics:CollidesWith(COLLISION.OBSTACLES)
        inst.Physics:CollidesWith(COLLISION.CHARACTERS)
    end
    inst.AnimState:SetBank("wilson")
    local str  = ""
    if inst.belongtowhich == TUNING.RIVENBELONG then
    	str = "DEMACIACHAR"
    else
    	str = "NOXUSCHAR"
    end
    local rm=math.random()
    inst.charanm = TUNING.RIVENALLP[math.random(#TUNING.RIVENALLP)]
    while  inst.charanm == nil or not Prefabs[inst.charanm] or (TUNING[str] and TUNING[str][inst.charanm]) do
    	inst.charanm = TUNING.RIVENALLP[math.random(#TUNING.RIVENALLP)]
    end
    if Prefabs[inst.charanm] then
    	setbuild2(inst)	
    else
	    inst.AnimState:SetBuild("wilson")	
    end
    inst.AnimState:PlayAnimation("idle")

    inst.myhat="hat_flower"
    inst.myarmor="armor_sanity"
    inst.myweapon="swap_spear"
    rm=math.random()
    if rm<0.05 then
    	inst.myhat="hat_flower"
	elseif rm<0.1 then
		inst.myhat="hat_earmuffs"
    else
	    inst.AnimState:Show("HAT")
	    inst.AnimState:Show("HAT_HAIR")
	    inst.AnimState:Hide("HAIR_NOHAT")
	    inst.AnimState:Hide("HAIR")
	    if rm<0.2 then
	    	inst.myhat="hat_straw"
	    elseif rm<0.3 then
	    	inst.myhat="hat_top"
	    elseif rm<0.4 then
	    	inst.myhat="hat_football"
	    elseif rm<0.5 then
	    	inst.myhat="hat_bee"
	    elseif rm<0.6 then
	    	inst.myhat="hat_beefalo"
	    elseif rm<0.7 then
	    	inst.myhat="hat_bush"
	    elseif rm<0.8 then
	    	inst.myhat="hat_miner"
	    elseif rm<0.9 then
	    	inst.myhat="hat_feather"
	    else
	    	inst.myhat="hat_slurtle"
	    end
    end
	inst.AnimState:OverrideSymbol("swap_hat", inst.myhat, "swap_hat")
    rm=math.random()
	if rm<0.1 then
		inst.myarmor = "armor_sanity"
	elseif rm<0.2 then
		inst.myarmor = "armor_sweatervest"
	elseif rm<0.3 then
		inst.myarmor = "armor_slurtleshell"
	elseif rm<0.4 then
		inst.myarmor = "armor_wood"
	elseif rm<0.5 then
		inst.myarmor = "armor_marble"
	elseif rm<0.6 then
		inst.myarmor = "armor_slurper"
	elseif rm<0.7 then
		inst.myarmor = "armor_trunkvest_summer"
	elseif rm<0.8 then
		inst.myarmor = "armor_trunkvest_winter"
	else
		inst.myarmor = "armor_grass"
	end
	inst.AnimState:OverrideSymbol("swap_body", inst.myarmor, "swap_body")

    rm=math.random()
	if rm<0.05 then
		inst.myweapon = "swap_spear"
	elseif rm<0.1 then
		inst.myweapon = "swap_axe"
	elseif rm<0.15 then
		inst.myweapon = "swap_batbat"
	elseif rm<0.2 then
		inst.myweapon = "swap_cane"
	elseif rm<0.25 then
		inst.myweapon = "swap_diviningrod"
	elseif rm<0.3 then
		inst.myweapon = "swap_fishingrod"
	elseif rm<0.35 then
		inst.myweapon = "swap_bugnet"
	elseif rm<0.4 then
		inst.myweapon = "swap_ham_bat"
	elseif rm<0.45 then
		inst.myweapon = "swap_shovel"
	elseif rm<0.5 then
		inst.myweapon = "swap_torch"
	elseif rm<0.55 then
		inst.myweapon = "swap_umbrella"
	elseif rm<0.6 then
		inst.myweapon = "swap_spike"
	elseif rm<0.65 then
		inst.myweapon = "swap_pitchfork"
	elseif rm<0.7 then
		inst.myweapon = "swap_nightmaresword"
	elseif rm<0.75 then
		inst.myweapon = "swap_pickaxe"
	elseif rm<0.8 then
		inst.myweapon = "swap_hammer"
	elseif rm<0.9 then
		inst.myweapon = "swap_blowdart"
	else
		inst.myweapon = "swap_staffs"
	end
	if inst.myweapon == "swap_staffs" then
		inst.AnimState:OverrideSymbol("swap_object", inst.myweapon, "redstaff")
	else
		inst.AnimState:OverrideSymbol("swap_object", inst.myweapon, inst.myweapon)
	end
	
    inst.AnimState:Show("ARM_carry") 
    inst.AnimState:Hide("ARM_normal")
	inst.entity:AddSoundEmitter()
	
	inst.onwater=false

    inst.dart=1
    inst:AddComponent("combat")
    inst.components.combat:SetDefaultDamage(40+GetPlayer().mylevel()*1)	
    inst.oldperiod=0.85
    inst.components.combat:SetAttackPeriod(inst.oldperiod)
    if inst.myweapon == "swap_blowdart" or inst.myweapon == "swap_staffs" then
    	inst.dart=0.75
    	inst.components.combat:SetAttackPeriod(inst.oldperiod*2)
    	inst.components.combat:SetRange(8,10)
    else 
    	inst.components.combat:SetRange(1.5)
    end
    inst:AddComponent("eater")
    inst.components.eater:SetOmnivore()
	inst.components.eater:SetCanEatHorrible()
    inst.components.eater.strongstomach = true 
    inst:AddComponent("locomotor")
    inst.walkspeed=TUNING.WILSON_WALK_SPEED or 4
    inst.runspeed= TUNING.WILSON_RUN_SPEED or 6
    inst.walkspeed=inst.walkspeed*0.88
    inst.runspeed=inst.runspeed*0.88
    inst.components.locomotor.walkspeed= inst.walkspeed*inst.dart
    inst.components.locomotor.runspeed = inst.runspeed*inst.dart
	inst.components.locomotor.fasteronroad = true
	inst.components.locomotor:SetTriggersCreep(false)
    inst:SetStateGraph("SGrivenmember")
    local brain = require "brains/rivenmemberbrain"
    inst:SetBrain(brain)
    inst.calculate=3
    inst.renewtask=nil
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(150+GetPlayer().mylevel()*5)
	inst.components.health:StartRegen(2, 5)
	inst.components.health.fire_damage_scale = 1
	if inst.components.health.SetAbsorptionAmount then
	    inst.components.health:SetAbsorptionAmount(.75+GetPlayer().mylevel()*0.005)
	else 
	    inst.components.health.absorb=.75+GetPlayer().mylevel()*0.005
	end
    inst:AddComponent("knownlocations")
    inst:AddComponent("inventory")
	inst:AddComponent("talker")
	inst:AddComponent("follower")
	inst.components.follower.maxfollowtime = TUNING.TOTAL_DAY_TIME*6
    inst.components.combat.hiteffectsymbol = "torso"
    inst.components.combat:SetRetargetFunction(2, RetargetFn)
    inst.components.combat:SetKeepTargetFunction(KeepTargetFn)
    inst:AddComponent("lootdropper")
    if inst.belongtowhich~=TUNING.RIVENBELONG then
    	inst.components.lootdropper:SetChanceLootTable('rivenmember')
    end
    local light = inst.entity:AddLight()
    inst.Light:Enable(false)
    inst.taskitem=nil
    inst.taskicon=nil
    inst:ListenForEvent("daytime", function (global, data)
    	daytimefn(inst)
    	if inst.belongtowhich==TUNING.RIVENBELONG and not inst.taskitem and math.random()<0.15 then
    		createTask(inst)
    	end
	end, GetWorld())
    inst:ListenForEvent("dusktime", function (global, data)
    	dusktimefn(inst)
	end, GetWorld())
    local time = GetClock().phase
    if time=="dusk" or time=="night" then
    	dusktimefn(inst)
    else 
    	daytimefn(inst)
    end
    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(function ()
    	return true
    end)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    if inst.belongtowhich~=TUNING.RIVENBELONG then
    	inst.components.trader.enabled=false
    else
    	inst.components.trader.enabled=true
    end


    inst:AddComponent("inspectable")


    local old=inst.components.inspectable.GetDescription
    inst.components.inspectable.GetDescription=function (viewer)
    	if inst.belongtowhich == TUNING.RIVENBELONG then
    		inst.sg:GoToState("idle")
    		if inst.taskitem then
    			inst.components.talker:Say(string.format("I need a %s,I will give you reward if you can find one ",STRINGS.NAMES[string.upper(inst.taskitem)]))
    		else
    			inst.components.talker:Say(dialog[math.random(#dialog)])
    		end
    		inst.sg:GoToState("talk")
    	end
    	return old(viewer)
    end

	inst.components.inspectable:SetDescription(string.format("%s-%s",inst.belongtowhich,inst.charanm))
	inst.name = string.format("%s-%s",inst.belongtowhich,inst.charanm)
	inst:AddTag(inst.belongtowhich)
	if inst.belongtowhich==TUNING.RIVENBELONG then
		inst:AddTag("companion")
	else
		inst:AddTag("hostile")
	end
	local function onattackother(inst, data)
	   local v = data.target
	   if v and inst.components.combat and v.components.health and not v.components.health:IsDead() 
	   and inst.calculate>0 then
	   		inst.calculate = inst.calculate - 1
	   		if math.random()<0.5 then
	   			inst.hurttime = 0
	   		end
	   end
	end
	inst:ListenForEvent("onattackother", onattackother)
	inst:ListenForEvent("attacked", OnAttacked)
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	showtask( inst )
		inst:ListenForEvent("entitysleep", function ()
			if inst.checking then
				inst.checking:Cancel()
				inst.checking=nil
			end
		    inst.checking = inst:DoPeriodicTask(2,function ()
			    if TUNING.LOLLOAD then
			    	if TUNING.LOLCHAR then
			    		if GetPlayer().prefab~=inst.belonger then
			    			local inneed = string.gsub(inst.prefab, inst.belonger, GetPlayer().prefab)
				    		local result = shitswap(inneed)
				    		result.Transform:SetPosition(inst.Transform:GetWorldPosition())
			    		end
			    	end
				    if inst.checking then
					    inst.checking:Cancel()
					    inst.checking=nil
				    end
				    if inst.belonger~=GetPlayer().prefab then
					    if inst.components.lootdropper then
					    	inst:RemoveComponent("lootdropper")
					    end
					    inst:AddComponent("lootdropper")
					    if inst.components.health then
					    	inst.components.health:Kill()
					    end
				    end
			    end
		    end)
	    end) 
    return inst
end

local function whiter()
	local inst = CreateEntity()
	local rm=math.random()
	if rm<0.25 then
		inst.belongtowhich="noxusmem"
		inst.enemywhich="demaciamem"
	else
		inst.belongtowhich="demaciamem"
		inst.enemywhich="noxusmem"
	end
	fn(inst)
	return inst
end

local function whited()
	local inst = CreateEntity()
	local rm=math.random()
	inst.belongtowhich="demaciamem"
	inst.enemywhich="noxusmem"
	fn(inst)
	return inst
end

local function whiten()
	local inst = CreateEntity()
	local rm=math.random()
	inst.belongtowhich="noxusmem"
	inst.enemywhich="demaciamem"
	fn(inst)
	return inst
end


return Prefab ("rivenmember", whiter, assets),
Prefab ("rivenmemberd", whited, assets),
Prefab ("rivenmembern", whiten, assets)