local assets =
{
	Asset("ANIM", "anim/rivenpackage.zip"),
    Asset( "ATLAS", "images/inventoryimages/rivenpackage.xml" ),
    Asset( "IMAGE", "images/inventoryimages/rivenpackage.tex" ),
}

local function do_unpack(inst)
	if inst.components.rivenpacker:Unpack() then
		inst:Remove()
	end
end	

local function get_name(inst)
	local basename = inst.components.rivenpacker:GetName()
	if basename then
		return basename
	else
		return "unknown package"
	end
end

local function fn(Sim, iteminside)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	MakeInventoryPhysics(inst)
	inst.Transform:SetScale(1.5,1.5,1.5)
	inst.AnimState:SetBank("rivenpackage")
	inst.AnimState:SetBuild("rivenpackage")
	inst.AnimState:PlayAnimation("idle")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.nobounce = false
	inst.components.inventoryitem.atlasname = "images/inventoryimages/rivenpackage.xml"
	inst:AddComponent("inspectable")
	inst:AddComponent("rivenpacker")
	inst:AddComponent("deployable")
	local deployable = inst.components.deployable
	deployable.ondeploy = do_unpack
	inst.displaynamefn = get_name
	return inst
end

return 	Prefab("common/inventory/rivenpackage", fn, assets),
	MakePlacer("common/inventory/rivenpackage_placer", "rivenpackage", "rivenpackage", "idle", false, false, true, 3)

