local assets = 
{
    Asset("ANIM", "anim/rivenq.zip"),
}

local function kill_fx(inst)
    inst:DoTaskInTime(0, function() inst:Remove() end)    
end

local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    anim:SetBank("rivenq")
    anim:SetBuild("rivenq")
    local frozenColor = Vector3(0/255,255/255,0/255)
    local r,g,b = frozenColor.x,frozenColor.y,frozenColor.z
    if not inst.components.highlight then
        inst:AddComponent("highlight")
    end
    inst.components.highlight:SetAddColour(Vector3(r, g, b) )
    return inst
end

local function fn1(Sim)
    local inst = fn(Sim)
    local matran=math.random()
    inst.Transform:SetScale(3, 3, 3)
    if matran<0.5 then 
        inst.AnimState:PlayAnimation("Q1",false)
        inst:DoTaskInTime(0.17, function() inst:Remove() end)  
    else
        inst.AnimState:PlayAnimation("Q2",false)
        inst:DoTaskInTime(0.22, function() inst:Remove() end)  
    end
    return inst
end

local function fn2(Sim)
    local inst = fn(Sim)
    inst.Transform:SetScale(5, 5, 5)
    inst.AnimState:PlayAnimation("Q3",false)
    inst.kill_fx = kill_fx
    inst:DoTaskInTime(0.28, function() inst:Remove() end)  
    return inst
end

local function fn3(Sim)
    local inst = fn1(Sim)
    inst.Transform:SetScale(2, 2, 2)
    return inst
end

local function fn4(Sim)
    local inst = fn2(Sim)
    inst.Transform:SetScale(3, 3, 3)
    return inst
end

return Prefab("rivenq1", fn1, assets),
        Prefab("rivenq2", fn2, assets),
        Prefab("rivenq3", fn3, assets),
        Prefab("rivenq4", fn4, assets)