local assets =
{
	Asset("ANIM", "anim/rivenr.zip"),
}

local function kill_fx(inst)
    inst:DoTaskInTime(0, function() inst:Remove() end)    
end

local function create_rivenr(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    inst.Transform:SetFourFaced()
    anim:SetBank("rivenr")
    anim:SetBuild("rivenr")
    anim:PlayAnimation("idle")
    inst.kill_fx = kill_fx
    MakeCharacterPhysics(inst, 1, .5)
    inst:AddComponent("locomotor")
    inst.components.locomotor.runspeed = 7
    inst:DoTaskInTime(3, function() inst:Remove() end)  
    
    return inst
end

return Prefab( "rivenr", create_rivenr, assets)