local assets=
{ 
    Asset("ANIM", "anim/rivensword.zip"), 
    Asset("ANIM", "anim/swap_rivensword.zip"),  
    Asset("ATLAS", "images/inventoryimages/rivensword.xml"),  
    Asset("IMAGE", "images/inventoryimages/rivensword.tex"),
}

local prefabs = 
{
}


local function addDamage(player,weapon)
    if  weapon and  weapon.components.weapon then
        weapon.components.weapon:SetDamage(30+weapon.gemlevel)
        if weapon.gemlevel >0 then
            weapon.name = string.format(" Doran (+%d)",weapon.gemlevel)
        else
            weapon.name = " Doran "
        end
        weapon.components.inspectable:SetDescription(
            string.format("damage(%d) defend(%d) speed(%d) heal(%d) cd(%d) crit(%d)\n \n \n  \n "
            , 30+weapon.gemlevel
            , weapon.bluegem
            , weapon.yellowgem
            , weapon.greengem
            , weapon.purplegem
            , weapon.orangegem
            ))
    end
end

local function weaponLigth(player,weapon)
    if weapon and weapon.gemlevel >=10 then 
        local light = weapon.entity:AddLight()
        light:SetFalloff(.4)
        light:SetIntensity(.8)
        light:SetRadius(.15+(weapon.gemlevel-10)*0.04)
        light:Enable(true)
        light:SetColour(0/255, 255/255, 0/255) 
    end
end



local function OnEquip(inst, owner) 
    local player=GetPlayer()
    player.setbaseattr(player,player.mylevel()-1,1,inst)
    if player:HasTag("rpre") then
        owner.AnimState:OverrideSymbol("swap_object", "swap_rivensword", "rivensword2")
        inst.components.weapon:SetRange(2)
    else
        owner.AnimState:OverrideSymbol("swap_object", "swap_rivensword", "rivensword1")
        inst.components.weapon:SetRange(nil)
    end    
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
    weaponLigth(owner,inst)
end
local function OnUnequip(inst, owner) 
    local player=GetPlayer()
    player.setbaseattr(player,player.mylevel()-1,0,inst)
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end
local function onfinished(inst)
    inst:Remove() 
end

local function fn(colour)
    local player = GetPlayer()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst.supportfueltype = {
        ["purplegem"] = true,
        ["bluegem"] = true,
        ["gemlevel"] = true,
        ["orangegem"] = true,
        ["yellowgem"] = true,
        ["greengem"] = true,
    }
    inst.addDamage=addDamage
    inst.gemlevel = 0
    inst.purplegem = 0
    inst.bluegem = 0
    inst.orangegem = 0
    inst.yellowgem = 0
    inst.greengem = 0
    anim:SetBank("rivensword")
    anim:SetBuild("rivensword")
    anim:PlayAnimation("idle")
    if IsDLCEnabled and CAPY_DLC and IsDLCEnabled(CAPY_DLC) then
        MakeInventoryFloatable(inst, "idle", "idle")
    end
    inst:AddComponent("weapon") 
    inst.components.weapon:SetDamage(30)  




    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem") 
    inst.components.inventoryitem.imagename = "rivensword" 
    inst.components.inventoryitem.atlasname = "images/inventoryimages/rivensword.xml"
    inst:AddComponent("equippable") 
    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("riven")
    inst.components.inventoryitem.keepondeath = true
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip)
    addDamage(player,inst)
    local function TakeItem(inst)
            addDamage(player,inst)
            player.setbaseattr(player,player.mylevel()-1)
            if inst.gemlevel >0 then
                inst.name=string.format(" Doran (+%d)",inst.gemlevel)
                local hand  = player.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) 
                if inst.gemlevel >=10 and hand and hand==inst then 
                    weaponLigth(player,inst)
                end
            end
    end
    inst.defaultDamage=30
    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "RIVENFUEL"
    inst.components.fueled:InitializeFuelLevel(20000000)
    inst.components.fueled.ontakefuelfn = TakeItem
    inst.components.fueled.accepting = true
    inst.components.fueled:StopConsuming()
    inst:AddTag("rivenweapon")
    inst:AddComponent("tradable")

    local function onpreload(inst, data)
        if not data then
            data={}
        end
        if data.gemlevel then
            inst.gemlevel = data.gemlevel
        else
            inst.gemlevel = 0
        end
        if inst.gemlevel >0 then
            inst.name = string.format(" Doran (+%d)",inst.gemlevel)
        else
            inst.name = " Doran "
        end
        
        if data.purplegem then
            inst.purplegem = data.purplegem
        else
            inst.purplegem = 0
        end

        if data.bluegem then
            inst.bluegem = data.bluegem
        else
            inst.bluegem = 0
        end

        if data.orangegem then
            inst.orangegem = data.orangegem
        else
            inst.orangegem = 0
        end

        if data.yellowgem then
            inst.yellowgem = data.yellowgem
        else
            inst.yellowgem = 0
        end

        if data.greengem then
            inst.greengem = data.greengem
        else
            inst.greengem = 0
        end     

        if inst.purplegem>=10 then 
            inst.supportfueltype["purplegem"] = false
        end
        if inst.bluegem>=10 then 
            inst.supportfueltype["bluegem"] = false
        end
        if inst.orangegem>=10 then 
            inst.supportfueltype["orangegem"] = false
        end
        if inst.yellowgem>=10 then 
            inst.supportfueltype["yellowgem"] = false
        end
        if inst.greengem>=10 then 
            inst.supportfueltype["greengem"] = false
        end
        if inst.gemlevel>=30 then 
            inst.supportfueltype["gemlevel"] = false
        end
        addDamage(player,inst)
    end
    local function onsave(inst, data)
        if inst.gemlevel then
            data.gemlevel=inst.gemlevel
        else
            data.gemlevel=0
        end

        if inst.purplegem then
            data.purplegem=inst.purplegem
        else
            data.purplegem=0
        end

        if inst.bluegem then
            data.bluegem=inst.bluegem
        else
            data.bluegem=0
        end

        if inst.orangegem then
            data.orangegem=inst.orangegem
        else
            data.orangegem=0
        end

        if inst.yellowgem then
            data.yellowgem=inst.yellowgem
        else
            data.yellowgem=0
        end

        if inst.greengem then
            data.greengem=inst.greengem
        else
            data.greengem=0
        end
    end

    inst.OnSave = onsave
    inst.OnPreLoad = onpreload
    return inst
end




return  Prefab("common/inventory/rivensword", fn, assets, prefabs)  