local assets = 
{
    Asset("ANIM", "anim/riventask.zip"),
}

local function onsave(inst, data)
    inst:Remove()
end

local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    anim:SetBank("riventask")
    anim:SetBuild("riventask")
    anim:PlayAnimation("idle")
    inst.OnSave = onsave
    inst.OnPreLoad = onsave
    return inst
end

return Prefab("riventask", fn, assets)