local Screen = require "widgets/screen"
local Button = require "widgets/button"
local AnimButton = require "widgets/animbutton"
local Menu = require "widgets/menu"
local Text = require "widgets/text"
local Image = require "widgets/image"
local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local PopupDialogScreen = require "screens/popupdialog"
local Grid = require "widgets/grid"
local Spinner = require "widgets/spinner"
require "util"
require "strings"
local TextEdit = require "widgets/textedit"
local textfont = UIFONT


local enableDisableOptions = { { text = "hehe", data = false }, { text = "hoho", data = true } }


local RivenScreen = Class(Screen, function(self)

    Screen._ctor(self, "Hehe")
    self.active = true
    SetPause(true,"pause")
    self.proot = self:AddChild(Widget("ROOT"))
    self.proot:SetVAnchor(ANCHOR_MIDDLE)
    self.proot:SetHAnchor(ANCHOR_MIDDLE)
    self.proot:SetPosition(0,0,0)
    self.proot:SetScaleMode(SCALEMODE_PROPORTIONAL)

    local shield = self.proot:AddChild( Image( "images/globalpanels.xml", "panel.tex" ) )
    shield:SetPosition( 0,0,0 )
    shield:SetSize( 800, 800 )  
    
    local player = GetPlayer()

    local diff = "easy"
    if TUNING.RIVEN_ENOMOUS_MONSTER==2 then
        diff = "terror"
    elseif TUNING.RIVEN_ENOMOUS_MONSTER==1 then
        diff = "normal"
    end

    local label = self.proot:AddChild( Text( textfont, 40, string.format("riven[%s]",diff) ))
    label:SetPosition( -20, 240, 0 )
    label:SetRegionSize( 200, 40 )
    label:SetHAlign( ANCHOR_MIDDLE )

    self.grid1 = self.proot:AddChild(Grid())
    self.grid1:InitSize(1, 15, 700, -70)
    self.grid1:SetPosition(-180, 200, 0)
    self.grid1:SetScale(0.9, 0.6, 0.9)
    local spinners1 = {}
    table.insert(spinners1, {"level:", player.mylevel(), "hh" ,false ,nil})
    table.insert(spinners1, {"money:", player.money, "hh" ,false ,nil})
    table.insert(spinners1, {"chop:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"mine:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"plant:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"fish:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"pharmacy:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"cook:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"forging:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"sew:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"breakdown:", '0/100', "level up" ,true ,nil})
    table.insert(spinners1, {"kill:", string.format('%s/%s',player.killmember,player.deathtime), "hh" ,false ,nil})
    
    for k,v in ipairs(spinners1) do self.grid1:AddItem(self:CreateSpinnerGroup(v[1], v[2], v[3], v[4]), 1, k) end

    self.grid2 = self.proot:AddChild(Grid())
    self.grid2:InitSize(1, 15, 700, -70)
    self.grid2:SetPosition(140, 200, 0)
    self.grid2:SetScale(0.9, 0.6, 0.9)
    local spinners2 = {}
    table.insert(spinners2, {"exp:", player.expvaluenum, "hh" ,false ,nil})
    table.insert(spinners2, {"health:", string.format("%.0f/%.0f", player.components.health.currenthealth, player.components.health.maxhealth), "hh" ,false ,nil})
    table.insert(spinners2, {"hunger:", string.format("%.0f/%.0f", player.components.hunger.current, player.components.hunger.max), "hh" ,false ,nil})
    table.insert(spinners2, {"san:", string.format("%.0f/%.0f", player.components.sanity.current, player.components.sanity.max), "hh" ,false ,nil})
    table.insert(spinners2, {"damage:", string.format("%.1f%%", player.components.combat.damagemultiplier*100), "hh" ,false ,nil})
    table.insert(spinners2, {"absorb:", string.format("%.1f%%", player.components.health.absorb*100), "hh" ,false ,nil})
    table.insert(spinners2, {"crit:", string.format("%.1f%%", player.charcrit*100), "hh" ,false ,nil})
    table.insert(spinners2, {"attackspeed:", string.format("%.1f%%", 0.5/player.components.combat.min_attack_period*100)  , "hh" ,false ,nil})
    table.insert(spinners2, {"movespeed:", string.format("%.1f%%", player.runspeedback*100/6), "hh" ,false ,nil})
    table.insert(spinners2, {"cd:", string.format("%.1f%%", player.cdtime*100), "hh" ,false ,nil})
    table.insert(spinners2, {"regen:", string.format("%.1f", player.components.health.regen.amount), "hh" ,false ,nil})
    table.insert(spinners2, {"time:", string.format("%.0f min", player.components.age:GetAge()/60), "hh" ,false ,nil})
    for k,v in ipairs(spinners2) do self.grid2:AddItem(self:CreateSpinnerGroup(v[1], v[2], v[3], v[4]), 1, k) end


    self.menu = self.proot:AddChild(Menu(nil, 200, true))
    self.menu:SetPosition(0, -300 ,0)
    self.menu:SetScale(0.6)
    self.menu:AddItem("close", function() self:Close() end)
end)


function RivenScreen:CreateSpinnerGroup( text, text2 , text3 ,button,fn)
    local label_width = 200
    local group = Widget("SpinnerGroup")
    local label = group:AddChild( Text( textfont, 30, text ) )
    label:SetPosition( 0, 0, 0 )
    label:SetRegionSize( label_width, 30 )
    label:SetHAlign( ANCHOR_LEFT )


    local label2 = group:AddChild( Text( textfont, 30, text2 ) )
    label2:SetPosition( 0, 0, 0 )
    label2:SetRegionSize( label_width, 30 )
    label2:SetHAlign( ANCHOR_MIDDLE )

    if button then
        local label3 = group:AddChild(Menu(nil, 200, true))
        label3:SetPosition( 100, 0, 0 )
        label3:SetScale(0.6)
        label3:SetHRegPoint(ANCHOR_RIGHT)
        label3:AddItem(text3, function() 
            if fn then
                fn()
            end
         end)
    end

    return group
end

function RivenScreen:Close()
    self.active = false
    SetPause(false)
    TheFrontEnd:PopScreen()
end 

function RivenScreen:OnControl(control, down)
    if RivenScreen._base.OnControl(self, control, down) then return true end
    if not down and  control == CONTROL_CANCEL then
        self:Close()
        return true
    end
    return false
end


return RivenScreen