local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local State = GLOBAL.State
local TimeEvent = GLOBAL.TimeEvent
local EventHandler = GLOBAL.EventHandler
local FRAMES = GLOBAL.FRAMES
local Action = GLOBAL.Action
local ActionHandler = GLOBAL.ActionHandler
local EQUIPSLOTS = GLOBAL.EQUIPSLOTS
local TheInput = GLOBAL.TheInput
local IsPaused = GLOBAL.IsPaused
local Vector3 = GLOBAL.Vector3
local ACTIONS = GLOBAL.ACTIONS
local GetPlayer = GLOBAL.GetPlayer
local GetString = GLOBAL.GetString
local Prefabs = GLOBAL.Prefabs
local package =GLOBAL.package
local kleifileexists =GLOBAL.kleifileexists
local select = GLOBAL.select
local RECIPE_GAME_TYPE = GLOBAL.RECIPE_GAME_TYPE

function exists(filepath)
	local filepath = string.gsub(filepath, "^/", "")
	local searchpaths = package.path
    for path in string.gmatch(searchpaths, "([^;]+)") do
        local filename = string.gsub(path, "scripts\\%?%.lua", filepath)
        filename = string.gsub(filename, "\\", "/")
		if not kleifileexists or kleifileexists(filename) then
            return true
        end
    end
	if not kleifileexists or kleifileexists(filepath) then
		return true
	end
	return false
end

function Recipe2(...)
	local b = select(1, ...)
	if b and exists('images/inventoryimages/'..b..'.xml') then
		return Recipe(...)
	elseif b and string.find(b, '_') and exists('images/inventoryimages/'..string.sub(b,0,string.find(b, '_')-1)..'.xml') then
		return Recipe(...)
	else
		return {}
	end
end

function yiyuPostInit()

	--if GetModConfigData("DLC") == true then
	 if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then

		--local fa_Recipe2book = Recipe2("fa_Recipe2book", {Ingredient("twigs", 2),}, RECIPETABS.YIYUTAB, {SCIENCE = 0})
		--fa_Recipe2book.atlas = "images/inventoryimages/darktrident.xml"
		local crystal1 = Ingredient( "crystal", 5)
		crystal1.atlas = "images/inventoryimages/crystal.xml"

		local crystal2 = Ingredient( "crystal", 2)
		crystal2.atlas = "images/inventoryimages/crystal.xml"

		local bonealtar = Recipe2("bonealtar", {Ingredient("goldnugget", 10), Ingredient("livinglog", 4), Ingredient("pigskin", 6)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, "bonealtar_placer" )
		bonealtar.atlas = "images/inventoryimages/bonealtar.xml"

		local yiyubbq = Recipe2("yiyubbq", {Ingredient("cutstone", 2),Ingredient("charcoal", 2),Ingredient("rope", 1)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, "yiyubbq_placer" )
		yiyubbq.atlas = "images/inventoryimages/yiyubbq.xml"

		local yiyubeebox = Recipe2("yiyubeebox", {Ingredient("honeycomb", 1),Ingredient("bee", 5),Ingredient("boards", 4)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, "yiyubeebox_placer" )
		yiyubeebox.atlas = "images/inventoryimages/yiyubeebox.xml"

		local palacelantern = Recipe2("palacelantern", {Ingredient("livinglog", 4), Ingredient("cutstone", 4), Ingredient("purplegem", 1)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, "palacelantern_placer" )
		palacelantern.atlas = "images/inventoryimages/palacelantern.xml"

		local yiyutrap = Recipe2("yiyutrap", {Ingredient("goldnugget", 2),crystal2,Ingredient("houndstooth", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 1} )
		yiyutrap.atlas = "images/inventoryimages/yiyutrap.xml"

		local darktrident = Recipe2("darktrident", {Ingredient("twigs", 2), Ingredient("goldnugget", 1)}, RECIPETABS.YIYUTAB, {SCIENCE = 0})
		darktrident.atlas = "images/inventoryimages/darktrident.xml"

		local darktrident1 = Ingredient( "darktrident", 1)
		darktrident1.atlas = "images/inventoryimages/darktrident.xml"

		local yiyusword = Recipe2("yiyusword", {Ingredient("purplegem", 2), darktrident1, Ingredient("gears", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 1})
		yiyusword.atlas = "images/inventoryimages/yiyusword.xml"

		local yiyuhuan = Recipe2("yiyuhuan", {Ingredient("greengem", 1), darktrident1, Ingredient("purplegem", 4)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyuhuan.atlas = "images/inventoryimages/yiyuhuan.xml"

		local yiyusack = Recipe2("yiyusack", {Ingredient("bearger_fur", 1), Ingredient("gears", 10), Ingredient("purplegem", 3)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyusack.atlas = "images/inventoryimages/yiyusack.xml"

		local yiyuhattop = Recipe2("yiyuhattop", {Ingredient("deerclops_eyeball", 1), Ingredient("walrushat", 1), Ingredient("purplegem", 3)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyuhattop.atlas = "images/inventoryimages/yiyuhattop.xml"

		local magicflute = Recipe2("magicflute", {Ingredient("purplegem", 1), Ingredient("horn", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		magicflute.atlas = "images/inventoryimages/magicflute.xml"

		local snailarmor = Recipe2("snailarmor", {Ingredient("purplegem", 1),Ingredient("pigskin", 4), Ingredient("slurtle_shellpieces", 2) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		snailarmor.atlas = "images/inventoryimages/snailarmor.xml"

		local writingbrush = Recipe2("writingbrush", {Ingredient("greengem", 1),Ingredient("manrabbit_tail", 10), Ingredient("walrus_tusk", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=2})
		writingbrush.atlas = "images/inventoryimages/writingbrush.xml"

		local bluegem = Recipe2("bluegem", {crystal1}, RECIPETABS.YIYUTAB, {SCIENCE=0})

		local turf_yiyua = Recipe2( "turf_yiyua", {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyua.atlas = "images/inventoryimages/turf_yiyua.xml"
		local turf_yiyuc = Recipe2( "turf_yiyuc", {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyuc.atlas = "images/inventoryimages/turf_yiyuc.xml"
		local turf_yiyub = Recipe2( "turf_yiyub", {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyub.atlas = "images/inventoryimages/turf_yiyub.xml"
		local Turf_yiyu1d = Recipe2( "turf_yiyu1d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu1d.atlas = "images/inventoryimages/turf_yiyu1d.xml"
		local Turf_yiyu2d = Recipe2( "turf_yiyu2d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu2d.atlas = "images/inventoryimages/turf_yiyu2d.xml"
		local Turf_yiyu3d = Recipe2( "turf_yiyu3d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu3d.atlas = "images/inventoryimages/turf_yiyu3d.xml"
		local Turf_yiyu4d = Recipe2( "turf_yiyu4d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu4d.atlas = "images/inventoryimages/turf_yiyu4d.xml"
		local Turf_yiyu5d = Recipe2( "turf_yiyu5d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu5d.atlas = "images/inventoryimages/turf_yiyu5d.xml"
		local Turf_yiyu6d = Recipe2( "turf_yiyu6d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu6d.atlas = "images/inventoryimages/turf_yiyu6d.xml"
		local Turf_yiyu7d = Recipe2( "turf_yiyu7d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu7d.atlas = "images/inventoryimages/turf_yiyu7d.xml"
		local Turf_yiyu8d = Recipe2( "turf_yiyu8d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu8d.atlas = "images/inventoryimages/turf_yiyu8d.xml"
		local Turf_yiyu9d = Recipe2( "turf_yiyu9d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu9d.atlas = "images/inventoryimages/turf_yiyu9d.xml"

		--------------------------------------------------------

		elseif not GLOBAL.SaveGameIndex:IsModeShipwrecked() then

		local crystal1 = Ingredient( "crystal", 5)
		crystal1.atlas = "images/inventoryimages/crystal.xml"

		local crystal2 = Ingredient( "crystal", 2)
		crystal2.atlas = "images/inventoryimages/crystal.xml"

		local bonealtar = Recipe2("bonealtar", {Ingredient("goldnugget", 10), Ingredient("livinglog", 4), Ingredient("pigskin", 6)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, nil, "bonealtar_placer" )
		bonealtar.atlas = "images/inventoryimages/bonealtar.xml"

		local yiyubbq = Recipe2("yiyubbq", {Ingredient("cutstone", 2),Ingredient("charcoal", 2),Ingredient("rope", 1)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, nil, "yiyubbq_placer" )
		yiyubbq.atlas = "images/inventoryimages/yiyubbq.xml"

		local yiyubeebox = Recipe2("yiyubeebox", {Ingredient("honeycomb", 1),Ingredient("bee", 5),Ingredient("boards", 4)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, nil, "yiyubeebox_placer" )
		yiyubeebox.atlas = "images/inventoryimages/yiyubeebox.xml"

		local palacelantern = Recipe2("palacelantern", {Ingredient("livinglog", 4), Ingredient("cutstone", 4), Ingredient("purplegem", 1)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, nil, "palacelantern_placer" )
		palacelantern.atlas = "images/inventoryimages/palacelantern.xml"

		local yiyutrap = Recipe2("yiyutrap", {Ingredient("goldnugget", 2),crystal2,Ingredient("houndstooth", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 1} )
		yiyutrap.atlas = "images/inventoryimages/yiyutrap.xml"

		local boatrepairkit = Recipe2("boatrepairkit", {Ingredient("boards", 4), Ingredient("stinger", 4), Ingredient("rope", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, nil, nil, nil, 1 )

		local ryondae_item = Recipe2("ryondae_item", {Ingredient("greengem", 2),Ingredient("livinglog", 4), Ingredient("petals_evil", 9),}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, nil, nil, nil, 1 )
		ryondae_item.atlas = "images/inventoryimages/ryondae.xml"
		ryondae_item.image = "ryondae.tex"

		local darktrident = Recipe2("darktrident", {Ingredient("twigs", 2), Ingredient("goldnugget", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 0})
		darktrident.atlas = "images/inventoryimages/darktrident.xml"

		local darktrident1 = Ingredient( "darktrident", 1)
		darktrident1.atlas = "images/inventoryimages/darktrident.xml"

		local yiyusword = Recipe2("yiyusword", {Ingredient("purplegem", 2), darktrident1, Ingredient("gears", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 1})
		yiyusword.atlas = "images/inventoryimages/yiyusword.xml"

		local yiyuhuan = Recipe2("yiyuhuan", {Ingredient("greengem", 1), darktrident1, Ingredient("purplegem", 4)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyuhuan.atlas = "images/inventoryimages/yiyuhuan.xml"

		local yiyusack = Recipe2("yiyusack", {Ingredient("bearger_fur", 1), Ingredient("gears", 10), Ingredient("purplegem", 3)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyusack.atlas = "images/inventoryimages/yiyusack.xml"

		local yiyuhattop = Recipe2("yiyuhattop", {Ingredient("deerclops_eyeball", 1), Ingredient("walrushat", 1), Ingredient("purplegem", 3)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyuhattop.atlas = "images/inventoryimages/yiyuhattop.xml"

		local magicflute = Recipe2("magicflute", {Ingredient("purplegem", 1), Ingredient("horn", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		magicflute.atlas = "images/inventoryimages/magicflute.xml"

		local destructionflute = Recipe2("destructionflute", {Ingredient("glommerwings", 1), Ingredient("glommerflower", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		destructionflute.atlas = "images/inventoryimages/destructionflute.xml"

		--local firegem = Recipe2("firegem", {Ingredient("redgem", 1), Ingredient("honey", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=0})
		--firegem.atlas = "images/inventoryimages/firegem.xml"

		--local icegem = Recipe2("icegem", {Ingredient("bluegem", 1), Ingredient("honey", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=0})
		--icegem.atlas = "images/inventoryimages/icegem.xml"

		local snailarmor = Recipe2("snailarmor", {Ingredient("purplegem", 1),Ingredient("pigskin", 4), Ingredient("slurtle_shellpieces", 2) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		snailarmor.atlas = "images/inventoryimages/snailarmor.xml"

		local writingbrush = Recipe2("writingbrush", {Ingredient("greengem", 1),Ingredient("manrabbit_tail", 10), Ingredient("walrus_tusk", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=2})
		writingbrush.atlas = "images/inventoryimages/writingbrush.xml"

		local bluegem = Recipe2("bluegem", {crystal1}, RECIPETABS.YIYUTAB, {SCIENCE=0})

		local turf_yiyua = Recipe2( "turf_yiyua", {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyua.atlas = "images/inventoryimages/turf_yiyua.xml"
		local turf_yiyuc = Recipe2( "turf_yiyuc", {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyuc.atlas = "images/inventoryimages/turf_yiyuc.xml"
		local turf_yiyub = Recipe2( "turf_yiyub", {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyub.atlas = "images/inventoryimages/turf_yiyub.xml"
		local Turf_yiyu1d = Recipe2( "turf_yiyu1d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu1d.atlas = "images/inventoryimages/turf_yiyu1d.xml"
		local Turf_yiyu2d = Recipe2( "turf_yiyu2d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu2d.atlas = "images/inventoryimages/turf_yiyu2d.xml"
		local Turf_yiyu3d = Recipe2( "turf_yiyu3d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu3d.atlas = "images/inventoryimages/turf_yiyu3d.xml"
		local Turf_yiyu4d = Recipe2( "turf_yiyu4d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu4d.atlas = "images/inventoryimages/turf_yiyu4d.xml"
		local Turf_yiyu5d = Recipe2( "turf_yiyu5d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu5d.atlas = "images/inventoryimages/turf_yiyu5d.xml"
		local Turf_yiyu6d = Recipe2( "turf_yiyu6d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu6d.atlas = "images/inventoryimages/turf_yiyu6d.xml"
		local Turf_yiyu7d = Recipe2( "turf_yiyu7d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu7d.atlas = "images/inventoryimages/turf_yiyu7d.xml"
		local Turf_yiyu8d = Recipe2( "turf_yiyu8d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu8d.atlas = "images/inventoryimages/turf_yiyu8d.xml"
		local Turf_yiyu9d = Recipe2( "turf_yiyu9d",  {crystal2, Ingredient("beefalowool", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu9d.atlas = "images/inventoryimages/turf_yiyu9d.xml"

		--------------------------------------------------------

		elseif GLOBAL.SaveGameIndex:IsModeShipwrecked() then

		local darktrident1 = Ingredient( "darktrident", 1)
		darktrident1.atlas = "images/inventoryimages/darktrident.xml"

		local crystal1 = Ingredient( "crystal", 5)
		crystal1.atlas = "images/inventoryimages/crystal.xml"

		local crystal2 = Ingredient( "crystal", 2)
		crystal2.atlas = "images/inventoryimages/crystal.xml"

		local bonealtar = Recipe2("bonealtar", {Ingredient("dubloon", 6), Ingredient("livinglog", 4), Ingredient("pigskin", 4)}, RECIPETABS.YIYUTAB, TECH.SCIENCE_ONE,RECIPE_GAME_TYPE.SHIPWRECKED, "bonealtar_placer" )
		bonealtar.atlas = "images/inventoryimages/bonealtar.xml"

		local yiyubbq = Recipe2("yiyubbq", {Ingredient("cutstone", 2),Ingredient("charcoal", 2),Ingredient("rope", 1)}, RECIPETABS.YIYUTAB, TECH.SCIENCE_ONE,RECIPE_GAME_TYPE.SHIPWRECKED, "yiyubbq_placer" )
		yiyubbq.atlas = "images/inventoryimages/yiyubbq.xml"

		local yiyubeebox = Recipe2("yiyubeebox", {Ingredient("honeycomb", 1),Ingredient("bee", 5),Ingredient("boards", 4)}, RECIPETABS.YIYUTAB, TECH.SCIENCE_ONE,RECIPE_GAME_TYPE.SHIPWRECKED, "yiyubeebox_placer" )
		yiyubeebox.atlas = "images/inventoryimages/yiyubeebox.xml"

		local palacelantern = Recipe2("palacelantern", {Ingredient("livinglog", 3), Ingredient("cutstone", 4), Ingredient("purplegem", 1)}, RECIPETABS.YIYUTAB, TECH.SCIENCE_ONE,RECIPE_GAME_TYPE.SHIPWRECKED, "palacelantern_placer" )
		palacelantern.atlas = "images/inventoryimages/palacelantern.xml"

		local ryondae_item = Recipe2("ryondae_item", {Ingredient("purplegem", 1),Ingredient("livinglog", 4), Ingredient("petals_evil", 9),}, RECIPETABS.YIYUTAB, {SCIENCE = 1}, nil, nil, nil, 1 )
		ryondae_item.atlas = "images/inventoryimages/ryondae.xml"
		ryondae_item.image = "ryondae.tex"

		local yiyutrap = Recipe2("yiyutrap", {Ingredient("goldnugget", 2),crystal2,Ingredient("houndstooth", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 1} )
		yiyutrap.atlas = "images/inventoryimages/yiyutrap.xml"

		local darktrident = Recipe2("darktrident", {Ingredient("twigs", 2), Ingredient("goldnugget", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 0})
		darktrident.atlas = "images/inventoryimages/darktrident.xml"

		local yiyusword = Recipe2("yiyusword", {Ingredient("purplegem", 1), darktrident1, Ingredient("gears", 2)}, RECIPETABS.YIYUTAB, {SCIENCE = 1})
		yiyusword.atlas = "images/inventoryimages/yiyusword.xml"

		local yiyuhuan = Recipe2("yiyuhuan", {Ingredient("purplegem", 3), darktrident1, Ingredient("gears", 4)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyuhuan.atlas = "images/inventoryimages/yiyuhuan.xml"

		local yiyusack = Recipe2("yiyusack", {Ingredient("seashell", 20), Ingredient("blubber", 10), Ingredient("shark_gills", 5)}, RECIPETABS.YIYUTAB, {SCIENCE=2})
		yiyusack.atlas = "images/inventoryimages/yiyusack.xml"

		local yiyuhattop = Recipe2("yiyuhattop", {Ingredient("magic_seal", 1), Ingredient("tigereye", 2), Ingredient("doydoyfeather", 8)}, RECIPETABS.YIYUTAB, {SCIENCE = 2})
		yiyuhattop.atlas = "images/inventoryimages/yiyuhattop.xml"

		local magicflute = Recipe2("magicflute", {Ingredient("purplegem", 1), Ingredient("ox_horn", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		magicflute.atlas = "images/inventoryimages/magicflute.xml"

		local destructionflute = Recipe2("destructionflute", {crystal1, Ingredient("coconade", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		destructionflute.atlas = "images/inventoryimages/destructionflute.xml"

		--local firegem = Recipe2("firegem", {Ingredient("redgem", 1), Ingredient("honey", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=0})
		--firegem.atlas = "images/inventoryimages/firegem.xml"

		--local icegem = Recipe2("icegem", {Ingredient("bluegem", 1), Ingredient("honey", 1) }, RECIPETABS.YIYUTAB, {SCIENCE=0})
		--icegem.atlas = "images/inventoryimages/icegem.xml"

		local snailarmor = Recipe2("snailarmor", {Ingredient("purplegem", 1),Ingredient("pigskin", 4), Ingredient("seashell", 10) }, RECIPETABS.YIYUTAB, {SCIENCE=1})
		snailarmor.atlas = "images/inventoryimages/snailarmor.xml"

		local writingbrush = Recipe2("writingbrush", {Ingredient("purplegem", 4),Ingredient("beardhair", 15), Ingredient("bamboo", 20) }, RECIPETABS.YIYUTAB, {SCIENCE=2})
		writingbrush.atlas = "images/inventoryimages/writingbrush.xml"

		local bluegem = Recipe2("bluegem", {crystal1}, RECIPETABS.YIYUTAB, {SCIENCE=0})

		local turf_yiyua = Recipe2( "turf_yiyua", {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyua.atlas = "images/inventoryimages/turf_yiyua.xml"
		local turf_yiyuc = Recipe2( "turf_yiyuc", {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyuc.atlas = "images/inventoryimages/turf_yiyuc.xml"
		local turf_yiyub = Recipe2( "turf_yiyub", {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		turf_yiyub.atlas = "images/inventoryimages/turf_yiyub.xml"
		local Turf_yiyu1d = Recipe2( "turf_yiyu1d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu1d.atlas = "images/inventoryimages/turf_yiyu1d.xml"
		local Turf_yiyu2d = Recipe2( "turf_yiyu2d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu2d.atlas = "images/inventoryimages/turf_yiyu2d.xml"
		local Turf_yiyu3d = Recipe2( "turf_yiyu3d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu3d.atlas = "images/inventoryimages/turf_yiyu3d.xml"
		local Turf_yiyu4d = Recipe2( "turf_yiyu4d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu4d.atlas = "images/inventoryimages/turf_yiyu4d.xml"
		local Turf_yiyu5d = Recipe2( "turf_yiyu5d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu5d.atlas = "images/inventoryimages/turf_yiyu5d.xml"
		local Turf_yiyu6d = Recipe2( "turf_yiyu6d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu6d.atlas = "images/inventoryimages/turf_yiyu6d.xml"
		local Turf_yiyu7d = Recipe2( "turf_yiyu7d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu7d.atlas = "images/inventoryimages/turf_yiyu7d.xml"
		local Turf_yiyu8d = Recipe2( "turf_yiyu8d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu8d.atlas = "images/inventoryimages/turf_yiyu8d.xml"
		local Turf_yiyu9d = Recipe2( "turf_yiyu9d",  {crystal2, Ingredient("limestone", 2), Ingredient("goldnugget", 1) }, RECIPETABS.YIYUTAB, {SCIENCE = 2}, nil, nil, nil, 1 )
		Turf_yiyu9d.atlas = "images/inventoryimages/turf_yiyu9d.xml"
			
	end
end