ServerRoot "%QSPATH%/apache"

#Listen 12.34.56.78:80
Listen 80

LoadModule access_compat_module modules/mod_access_compat.so
LoadModule actions_module modules/mod_actions.so
LoadModule alias_module modules/mod_alias.so
LoadModule allowmethods_module modules/mod_allowmethods.so
LoadModule asis_module modules/mod_asis.so
LoadModule auth_basic_module modules/mod_auth_basic.so
LoadModule authn_core_module modules/mod_authn_core.so
LoadModule authn_file_module modules/mod_authn_file.so
LoadModule authz_core_module modules/mod_authz_core.so
LoadModule authz_groupfile_module modules/mod_authz_groupfile.so
LoadModule authz_host_module modules/mod_authz_host.so
LoadModule authz_user_module modules/mod_authz_user.so
LoadModule cgi_module modules/mod_cgi.so
LoadModule dav_lock_module modules/mod_dav_lock.so
LoadModule dir_module modules/mod_dir.so
LoadModule env_module modules/mod_env.so
LoadModule headers_module modules/mod_headers.so
LoadModule include_module modules/mod_include.so
LoadModule isapi_module modules/mod_isapi.so
LoadModule log_config_module modules/mod_log_config.so
LoadModule cache_disk_module modules/mod_cache_disk.so
LoadModule mime_module modules/mod_mime.so
LoadModule rewrite_module modules/mod_rewrite.so
LoadModule setenvif_module modules/mod_setenvif.so
LoadModule socache_shmcb_module modules/mod_socache_shmcb.so
LoadModule status_module modules/mod_status.so 

<IfModule unixd_module>

User daemon
Group daemon

</IfModule>

ServerAdmin postmaster@localhost

ServerName localhost:80

<Directory />
    AllowOverride none
    Require all denied
</Directory>

DocumentRoot "%QSPATH%/htdocs"
<Directory "%QSPATH%/htdocs">
    
    Options Indexes FollowSymLinks Includes ExecCGI

    AllowOverride All

    Require all granted
</Directory>

<IfModule dir_module>
    DirectoryIndex index.php index.html index.htm 
</IfModule>

<Files ".ht*">
    Require all denied
</Files>

ErrorLog "logs/error.log"
# ErrorLog "|bin/rotatelogs.exe -l logs/error-%Y-%m-%d.log 10M"

LogLevel warn

<IfModule log_config_module>
    LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"" combined
    # LogFormat "%h %l %u %t \"%r\" %>s %b" common

    <IfModule logio_module>
      # You need to enable mod_logio.c to use %I and %O
      LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" %I %O" combinedio
    </IfModule>

    # CustomLog "logs/access.log" combined
	# CustomLog "|bin/rotatelogs.exe -l logs/access.log 100M" common
</IfModule>

<IfModule alias_module>

    # ScriptAlias /cgi-bin/ "%QSPATH%/cgi-bin/"

</IfModule>

<IfModule cgid_module>
    #
    # ScriptSock: On threaded servers, designate the path to the UNIX
    # socket used to communicate with the CGI daemon of mod_cgid.
    #
    #Scriptsock cgisock
</IfModule>

<IfModule mime_module>
    TypesConfig conf/mime.types

    #AddType application/x-gzip .tgz
    #AddEncoding x-compress .Z
    #AddEncoding x-gzip .gz .tgz
    AddType application/x-compress .Z
    AddType application/x-gzip .gz .tgz

    AddHandler cgi-script .cgi .pl .asp

    AddType text/html .shtml
    AddOutputFilter INCLUDES .shtml
</IfModule>


<IfModule mime_magic_module>
    MIMEMagicFile "conf/magic"
</IfModule>


# Server-pool management (MPM specific)

<IfModule !mpm_netware_module>
    PidFile "logs/httpd.pid"
</IfModule>

<IfModule mpm_prefork_module>
    # StartServers             5
    # MinSpareServers          5
    # MaxSpareServers         10
    # MaxRequestWorkers      250
    # MaxClients 			500
    # MaxConnectionsPerChild   0   
    
	StartServers         5
	MinSpareServers      5
	MaxSpareServers      10
	ServerLimit          1500
	MaxClients           1000
	MaxRequestsPerChild  0 
</IfModule>
<IfModule mpm_worker_module>
    StartServers             3
    MinSpareThreads         75
    MaxSpareThreads        250 
    ThreadsPerChild         25
    MaxRequestWorkers      400
    MaxConnectionsPerChild   0
	ServerLimit          1500
	MaxClients           1000
</IfModule>
<IfModule mpm_event_module>
    StartServers             3
    MinSpareThreads         75
    MaxSpareThreads        250
    ThreadsPerChild         25
    MaxRequestWorkers      400
    MaxConnectionsPerChild   0
</IfModule>
<IfModule mpm_netware_module>
    ThreadStackSize      65536
    StartThreads           250
    MinSpareThreads         25
    MaxSpareThreads        250
    MaxThreads            1000
    MaxConnectionsPerChild   0
</IfModule>
<IfModule mpm_mpmt_os2_module>
    StartServers             2
    MinSpareThreads          5
    MaxSpareThreads         10
    MaxConnectionsPerChild   0
</IfModule>
<IfModule mpm_winnt_module>
    ThreadsPerChild        1500
    MaxConnectionsPerChild   0
#	ServerLimit          1500
#	MaxClients           1000
</IfModule>
<IfModule !mpm_netware_module>
    MaxMemFree            2048
</IfModule>
<IfModule mpm_netware_module>
    MaxMemFree             100
</IfModule>

Timeout 300

KeepAlive On

MaxKeepAliveRequests 100

KeepAliveTimeout 5

UseCanonicalName Off

AccessFileName .htaccess

ServerTokens Full

ServerSignature On

HostnameLookups Off


LoadFile "%QSPATH%/php/php5ts.dll"
LoadModule php5_module "%QSPATH%/php/php5apache2_4.dll"

<FilesMatch "\.php$">
    SetHandler application/x-httpd-php
</FilesMatch>
<FilesMatch "\.phps$">
    SetHandler application/x-httpd-php-source
</FilesMatch>

<IfModule php5_module>
    PHPINIDir "%QSPATH%/php"
</IfModule>
<IfModule mime_module>
    AddType text/html .php .phps
</IfModule>

<IfModule alias_module>
    Alias /phpmyadmin "%QSPATH%/phpMyAdmin/"
	
    <Directory "%QSPATH%/phpMyAdmin">
        AllowOverride AuthConfig
        Require all granted
    </Directory>

    Alias /encode "%QSPATH%/encode/"
	
    <Directory "%QSPATH%/encode">
        AllowOverride AuthConfig
        Require all granted
    </Directory>
	
    Alias /record "D:/record/"	
    <Directory "D:/encode">
        AllowOverride AuthConfig
        Require all granted
    </Directory>
</IfModule>

AcceptFilter http none
