<?php  
class smallPic{
    public $dstW, $dstH;
	
    //初始化，指定要生成的图片的宽度、高度
    function __construct($width,$height){
		$this->dstW=$width;
		$this->dstH=$height;
    }


    public function makeNewPicture($filePath,$newPath){
	
		$info=GetImageSize($filePath);
		//echo $info[2];
		switch($info[2]){                                   //获取图像类型，方便下面产生新图像蓝本使用
			case 1:
			$img=ImageCreateFromGif($filePath);
				break;
			case 2:
			$img=ImageCreateFromJpeg($filePath);
				break;
			case 3:
			$img=ImageCreateFromPng($filePath);
				break;
			case 6:
			$img=imagecreatefrombmp($filePath);
				break;
		}
	
		$wRatio=$info[0]/$this->dstW;               //此处计算宽度比例
		$hRatio=$info[1]/$this->dstH;               //此处计算高度比例
		if($wRatio<$hRatio){                        //为保证图像不变形，此处按照原图比例计算新图像的高度和宽度【最大值均为在初始化对象的时候指定值】
			$this->dstW=$info[0]/$hRatio;
		}else{
			$this->dstH=$info[1]/$wRatio;
		}
	
		$srcW=ImageSX($img);
		$srcH=ImageSY($img);
	
		if(function_exists("imagecopyresampled")){          //检查函数是否存在
			$newImg = ImageCreateTrueColor($this->dstW, $this->dstH);
			ImageCopyResampled($newImg, $img, 0, 0, 0, 0, $this->dstW, $this->dstH, $srcW, $srcH);
		}else{
			$newImg=ImageCreate($this->dstW,$this->dstH);
			ImageCopyResized($newImg, $img, 0, 0, 0, 0, $this->dstW, $this->dstH, $srcW, $srcH);
		}
		$namelen = strlen($filePath);
		
		//$smallFilename = substr($filePath,0,-4) . "_s" . ".gif";
		$smallFilename = $newPath;
		//Imagegif ($newImg,$smallFilename);     //生成新的图片
		imagejpeg($newImg,$smallFilename,90);
		ImageDestroy($newImg);                                        //销毁对象
		ImageDestroy($img);
		return $smallFilename;
    }
}

	function imagecreatefrombmp($fname) {
		$buf=@file_get_contents($fname);
		
		if(strlen($buf)<54) return false;
		
		$file_header=unpack("sbfType/LbfSize/sbfReserved1/sbfReserved2/LbfOffBits",substr($buf,0,14));
		
		if($file_header["bfType"]!=19778) return false;
		$info_header=unpack("LbiSize/lbiWidth/lbiHeight/sbiPlanes/sbiBitCountLbiCompression/LbiSizeImage/lbiXPelsPerMeter/lbiYPelsPerMeter/LbiClrUsed/LbiClrImportant",substr($buf,14,40));
		if($info_header["biBitCountLbiCompression"]==2) return false;  
		$line_len=round($info_header["biWidth"]*$info_header["biBitCountLbiCompression"]/8);
		$x=$line_len%4;
		if($x>0) $line_len+=4-$x;
			
		$img=imagecreatetruecolor($info_header["biWidth"],$info_header["biHeight"]);
		   switch($info_header["biBitCountLbiCompression"]){
		   case 4:
		   $colorset=unpack("L*",substr($buf,54,64));
		   for($y=0;$y<$info_header["biHeight"];$y++){
			 $colors=array();
			 $y_pos=$y*$line_len+$file_header["bfOffBits"];
			 for($x=0;$x<$info_header["biWidth"];$x++){
			 if($x%2)
			   $colors[]=$colorset[(ord($buf[$y_pos+($x+1)/2])&0xf)+1];
			 else  
			   $colors[]=$colorset[((ord($buf[$y_pos+$x/2+1])>>4)&0xf)+1];
			 }
			 imagesetstyle($img,$colors);
			 imageline($img,0,$info_header["biHeight"]-$y-1,$info_header["biWidth"],$info_header["biHeight"]-$y-1,IMG_COLOR_STYLED);
		   }
		   break;
		   case 8:
		   $colorset=unpack("L*",substr($buf,54,1024));
		   for($y=0;$y<$info_header["biHeight"];$y++){
			 $colors=array();
			 $y_pos=$y*$line_len+$file_header["bfOffBits"];
			 for($x=0;$x<$info_header["biWidth"];$x++){
			 $colors[]=$colorset[ord($buf[$y_pos+$x])+1];
			 }
			 imagesetstyle($img,$colors);
			 imageline($img,0,$info_header["biHeight"]-$y-1,$info_header["biWidth"],$info_header["biHeight"]-$y-1,IMG_COLOR_STYLED);
		   }
		   break;
		   case 16:
		   for($y=0;$y<$info_header["biHeight"];$y++){
		   $colors=array();
		   $y_pos=$y*$line_len+$file_header["bfOffBits"];
		   for($x=0;$x<$info_header["biWidth"];$x++){
			 $i=$x*2;
			 $color=ord($buf[$y_pos+$i])|(ord($buf[$y_pos+$i+1])<<8);
			 $colors[]=imagecolorallocate($img,(($color>>10)&0x1f)*0xff/0x1f,(($color>>5)&0x1f)*0xff/0x1f,($color&0x1f)*0xff/0x1f);
		   }
		   imagesetstyle($img,$colors);
		   imageline($img,0,$info_header["biHeight"]-$y-1,$info_header["biWidth"],$info_header["biHeight"]-$y-1,IMG_COLOR_STYLED);
		   }
		   break;
		   case 24:
		   for($y=0;$y<$info_header["biHeight"];$y++){
			 $colors=array();
			 $y_pos=$y*$line_len+$file_header["bfOffBits"];
			 for($x=0;$x<$info_header["biWidth"];$x++){
			 $i=$x*3;
			 $colors[]=imagecolorallocate($img,ord($buf[$y_pos+$i+2]),ord($buf[$y_pos+$i+1]),ord($buf[$y_pos+$i]));
			 }
			 imagesetstyle($img,$colors);
			 imageline($img,0,$info_header["biHeight"]-$y-1,$info_header["biWidth"],$info_header["biHeight"]-$y-1,IMG_COLOR_STYLED);
		   }
		   break;
		   default:
		   return false;
		   break;
		}
		return $img;
	}


?>