jQuery.cookie=function(name,value,options){
if(typeof value!='undefined'){
options=options||{};
if(value===null){
value='';
options.expires=-1;}
var expires='';
if(options.expires&&(typeof options.expires=='number'||options.expires.toUTCString)){
var date;
if(typeof options.expires=='number'){
date=new Date();
date.setTime(date.getTime()+(options.expires*24*60*60*1000));}else{
date=options.expires;}
expires='; expires='+date.toUTCString();}
var path=options.path?'; path='+options.path:'';
var domain=options.domain?'; domain='+options.domain:'';
var secure=options.secure?'; secure':'';
document.cookie=[name,'=',encodeURIComponent(value),expires,path,domain,secure].join('');}else{
var cookieValue=null;
if(document.cookie&&document.cookie!=''){
var cookies=document.cookie.split(';');
for(var i=0;i<cookies.length;i++){
var cookie=jQuery.trim(cookies[i]);
if(cookie.substring(0,name.length+1)==(name+'=')){
cookieValue=decodeURIComponent(cookie.substring(name.length+1));
break;}}}
return cookieValue;}};(function($){
$.extend($.fn,{
validate:function(options){
if(!this.length){
if(options&&options.debug&&window.console){
console.warn("Nothing selected, can't validate, returning nothing.");}
return;}
var validator=$.data(this[0],"validator");
if(validator){
return validator;}
this.attr("novalidate","novalidate");
validator=new $.validator(options,this[0]);
$.data(this[0],"validator",validator);
if(validator.settings.onsubmit){
this.validateDelegate(":submit","click",function(event){
if(validator.settings.submitHandler){
validator.submitButton=event.target;}
if($(event.target).hasClass("cancel")){
validator.cancelSubmit=true;}
if($(event.target).attr("formnovalidate")!==undefined){
validator.cancelSubmit=true;}});
this.submit(function(event){
if(validator.settings.debug){
event.preventDefault();}
function handle(){
var hidden;
if(validator.settings.submitHandler){
if(validator.submitButton){
hidden=$("<input type='hidden'/>").attr("name",validator.submitButton.name).val($(validator.submitButton).val()).appendTo(validator.currentForm);}
validator.settings.submitHandler.call(validator,validator.currentForm,event);
if(validator.submitButton){
hidden.remove();}
return false;}
return true;}
if(validator.cancelSubmit){
validator.cancelSubmit=false;
return handle();}
if(validator.form()){
if(validator.pendingRequest){
validator.formSubmitted=true;
return false;}
return handle();}else{
validator.focusInvalid();
return false;}});}
return validator;},
valid:function(){
if($(this[0]).is("form")){
return this.validate().form();}else{
var valid=true;
var validator=$(this[0].form).validate();
this.each(function(){
valid=valid&&validator.element(this);});
return valid;}},
removeAttrs:function(attributes){
var result={},
$element=this;
$.each(attributes.split(/\s/),function(index,value){
result[value]=$element.attr(value);
$element.removeAttr(value);});
return result;},
rules:function(command,argument){
var element=this[0];
if(command){
var settings=$.data(element.form,"validator").settings;
var staticRules=settings.rules;
var existingRules=$.validator.staticRules(element);
switch(command){
case "add":
$.extend(existingRules,$.validator.normalizeRule(argument));
delete existingRules.messages;
staticRules[element.name]=existingRules;
if(argument.messages){
settings.messages[element.name]=$.extend(settings.messages[element.name],argument.messages);}
break;
case "remove":
if(!argument){
delete staticRules[element.name];
return existingRules;}
var filtered={};
$.each(argument.split(/\s/),function(index,method){
filtered[method]=existingRules[method];
delete existingRules[method];});
return filtered;}}
var data=$.validator.normalizeRules(
$.extend({},
$.validator.classRules(element),
$.validator.attributeRules(element),
$.validator.dataRules(element),
$.validator.staticRules(element)),element);
if(data.required){
var param=data.required;
delete data.required;
data=$.extend({required:param},data);}
return data;}});
$.extend($.expr[":"],{
blank:function(a){return !$.trim(""+$(a).val());},
filled:function(a){return !!$.trim(""+$(a).val());},
unchecked:function(a){return !$(a).prop("checked");}});
$.validator=function(options,form){
this.settings=$.extend(true,{},$.validator.defaults,options);
this.currentForm=form;
this.init();};
$.validator.format=function(source,params){
if(arguments.length===1){
return function(){
var args=$.makeArray(arguments);
args.unshift(source);
return $.validator.format.apply(this,args);};}
if(arguments.length>2&&params.constructor !==Array){
params=$.makeArray(arguments).slice(1);}
if(params.constructor !==Array){
params=[params];}
$.each(params,function(i,n){
source=source.replace(new RegExp("\\{"+i+"\\}","g"),function(){
return n;});});
return source;};
$.extend($.validator,{
defaults:{
messages:{},
groups:{},
rules:{},
errorClass:"error",
validClass:"valid",
errorElement:"label",
focusInvalid:true,
errorContainer:$([]),
errorLabelContainer:$([]),
onsubmit:true,
ignore:":hidden",
ignoreTitle:false,
onfocusin:function(element,event){
this.lastActive=element;
if(this.settings.focusCleanup&&!this.blockFocusCleanup){
if(this.settings.unhighlight){
this.settings.unhighlight.call(this,element,this.settings.errorClass,this.settings.validClass);}
this.addWrapper(this.errorsFor(element)).hide();}},
onfocusout:function(element,event){
if(!this.checkable(element)&&(element.name in this.submitted||!this.optional(element))){
this.element(element);}},
onkeyup:function(element,event){
if(event.which===9&&this.elementValue(element)===""){
return;}else if(element.name in this.submitted||element===this.lastElement){
this.element(element);}},
onclick:function(element,event){
if(element.name in this.submitted){
this.element(element);}
else if(element.parentNode.name in this.submitted){
this.element(element.parentNode);}},
highlight:function(element,errorClass,validClass){
if(element.type==="radio"){
this.findByName(element.name).addClass(errorClass).removeClass(validClass);}else{
$(element).addClass(errorClass).removeClass(validClass);}},
unhighlight:function(element,errorClass,validClass){
if(element.type==="radio"){
this.findByName(element.name).removeClass(errorClass).addClass(validClass);}else{
$(element).removeClass(errorClass).addClass(validClass);}}},
setDefaults:function(settings){
$.extend($.validator.defaults,settings);},
messages:{
required:"This field is required.",
remote:"Please fix this field.",
email:"Please enter a valid email address.",
url:"Please enter a valid URL.",
date:"Please enter a valid date.",
dateISO:"Please enter a valid date (ISO).",
number:"Please enter a valid number.",
digits:"Please enter only digits.",
creditcard:"Please enter a valid credit card number.",
equalTo:"Please enter the same value again.",
maxlength:$.validator.format("Please enter no more than {0} characters."),
minlength:$.validator.format("Please enter at least {0} characters."),
rangelength:$.validator.format("Please enter a value between {0} and {1} characters long."),
range:$.validator.format("Please enter a value between {0} and {1}."),
max:$.validator.format("Please enter a value less than or equal to {0}."),
min:$.validator.format("Please enter a value greater than or equal to {0}.")},
autoCreateRanges:false,
prototype:{
init:function(){
this.labelContainer=$(this.settings.errorLabelContainer);
this.errorContext=this.labelContainer.length&&this.labelContainer||$(this.currentForm);
this.containers=$(this.settings.errorContainer).add(this.settings.errorLabelContainer);
this.submitted={};
this.valueCache={};
this.pendingRequest=0;
this.pending={};
this.invalid={};
this.reset();
var groups=(this.groups={});
$.each(this.settings.groups,function(key,value){
if(typeof value==="string"){
value=value.split(/\s/);}
$.each(value,function(index,name){
groups[name]=key;});});
var rules=this.settings.rules;
$.each(rules,function(key,value){
rules[key]=$.validator.normalizeRule(value);});
function delegate(event){
var validator=$.data(this[0].form,"validator"),
eventType="on"+event.type.replace(/^validate/,"");
if(validator.settings[eventType]){
validator.settings[eventType].call(validator,this[0],event);}}
$(this.currentForm)
.validateDelegate(":text, [type='password'], [type='file'], select, textarea, "+
"[type='number'], [type='search'] ,[type='tel'], [type='url'], "+
"[type='email'], [type='datetime'], [type='date'], [type='month'], "+
"[type='week'], [type='time'], [type='datetime-local'], "+
"[type='range'], [type='color'] ",
"focusin focusout keyup",delegate)
.validateDelegate("[type='radio'], [type='checkbox'], select, option","click",delegate);
if(this.settings.invalidHandler){
$(this.currentForm).bind("invalid-form.validate",this.settings.invalidHandler);}},
form:function(){
this.checkForm();
$.extend(this.submitted,this.errorMap);
this.invalid=$.extend({},this.errorMap);
if(!this.valid()){
$(this.currentForm).triggerHandler("invalid-form",[this]);}
this.showErrors();
return this.valid();},
checkForm:function(){
this.prepareForm();
for(var i=0,elements=(this.currentElements=this.elements());elements[i];i++){
this.check(elements[i]);}
return this.valid();},
element:function(element){
element=this.validationTargetFor(this.clean(element));
this.lastElement=element;
this.prepareElement(element);
this.currentElements=$(element);
var result=this.check(element)!==false;
if(result){
delete this.invalid[element.name];}else{
this.invalid[element.name]=true;}
if(!this.numberOfInvalids()){
this.toHide=this.toHide.add(this.containers);}
this.showErrors();
return result;},
showErrors:function(errors){
if(errors){
$.extend(this.errorMap,errors);
this.errorList=[];
for(var name in errors){
this.errorList.push({
message:errors[name],
element:this.findByName(name)[0]});}
this.successList=$.grep(this.successList,function(element){
return !(element.name in errors);});}
if(this.settings.showErrors){
this.settings.showErrors.call(this,this.errorMap,this.errorList);}else{
this.defaultShowErrors();}},
resetForm:function(){
if($.fn.resetForm){
$(this.currentForm).resetForm();}
this.submitted={};
this.lastElement=null;
this.prepareForm();
this.hideErrors();
this.elements().removeClass(this.settings.errorClass).removeData("previousValue");},
numberOfInvalids:function(){
return this.objectLength(this.invalid);},
objectLength:function(obj){
var count=0;
for(var i in obj){
count++;}
return count;},
hideErrors:function(){
this.addWrapper(this.toHide).hide();},
valid:function(){
return this.size()===0;},
size:function(){
return this.errorList.length;},
focusInvalid:function(){
if(this.settings.focusInvalid){
try{
$(this.findLastActive()||this.errorList.length&&this.errorList[0].element||[])
.filter(":visible")
.focus()
.trigger("focusin");}catch(e){}}},
findLastActive:function(){
var lastActive=this.lastActive;
return lastActive&&$.grep(this.errorList,function(n){
return n.element.name===lastActive.name;}).length===1&&lastActive;},
elements:function(){
var validator=this,
rulesCache={};
return $(this.currentForm)
.find("input, select, textarea")
.not(":submit, :reset, :image, [disabled]")
.not(this.settings.ignore)
.filter(function(){
if(!this.name&&validator.settings.debug&&window.console){
console.error("%o has no name assigned",this);}
if(this.name in rulesCache||!validator.objectLength($(this).rules())){
return false;}
rulesCache[this.name]=true;
return true;});},
clean:function(selector){
return $(selector)[0];},
errors:function(){
var errorClass=this.settings.errorClass.replace(" ",".");
return $(this.settings.errorElement+"."+errorClass,this.errorContext);},
reset:function(){
this.successList=[];
this.errorList=[];
this.errorMap={};
this.toShow=$([]);
this.toHide=$([]);
this.currentElements=$([]);},
prepareForm:function(){
this.reset();
this.toHide=this.errors().add(this.containers);},
prepareElement:function(element){
this.reset();
this.toHide=this.errorsFor(element);},
elementValue:function(element){
var type=$(element).attr("type"),
val=$(element).val();
if(type==="radio"||type==="checkbox"){
return $("input[name='"+$(element).attr("name")+"']:checked").val();}
if(typeof val==="string"){
return val.replace(/\r/g,"");}
return val;},
check:function(element){
element=this.validationTargetFor(this.clean(element));
var rules=$(element).rules();
var dependencyMismatch=false;
var val=this.elementValue(element);
var result;
for(var method in rules){
var rule={method:method,parameters:rules[method]};
try{
result=$.validator.methods[method].call(this,val,element,rule.parameters);
if(result==="dependency-mismatch"){
dependencyMismatch=true;
continue;}
dependencyMismatch=false;
if(result==="pending"){
this.toHide=this.toHide.not(this.errorsFor(element));
return;}
if(!result){
this.formatAndAdd(element,rule);
return false;}}catch(e){
if(this.settings.debug&&window.console){
console.log("Exception occurred when checking element "+element.id+", check the '"+rule.method+"' method.",e);}
throw e;}}
if(dependencyMismatch){
return;}
if(this.objectLength(rules)){
this.successList.push(element);}
return true;},
customDataMessage:function(element,method){
return $(element).data("msg-"+method.toLowerCase())||(element.attributes&&$(element).attr("data-msg-"+method.toLowerCase()));},
customMessage:function(name,method){
var m=this.settings.messages[name];
return m&&(m.constructor===String?m:m[method]);},
findDefined:function(){
for(var i=0;i<arguments.length;i++){
if(arguments[i]!==undefined){
return arguments[i];}}
return undefined;},
defaultMessage:function(element,method){
return this.findDefined(
this.customMessage(element.name,method),
this.customDataMessage(element,method),!this.settings.ignoreTitle&&element.title||undefined,
$.validator.messages[method],
"<strong>Warning: No message defined for "+element.name+"</strong>");},
formatAndAdd:function(element,rule){
var message=this.defaultMessage(element,rule.method),
theregex=/\$?\{(\d+)\}/g;
if(typeof message==="function"){
message=message.call(this,rule.parameters,element);}else if(theregex.test(message)){
message=$.validator.format(message.replace(theregex,"{$1}"),rule.parameters);}
this.errorList.push({
message:message,
element:element});
this.errorMap[element.name]=message;
this.submitted[element.name]=message;},
addWrapper:function(toToggle){
if(this.settings.wrapper){
toToggle=toToggle.add(toToggle.parent(this.settings.wrapper));}
return toToggle;},
defaultShowErrors:function(){
var i,elements;
for(i=0;this.errorList[i];i++){
var error=this.errorList[i];
if(this.settings.highlight){
this.settings.highlight.call(this,error.element,this.settings.errorClass,this.settings.validClass);}
this.showLabel(error.element,error.message);}
if(this.errorList.length){
this.toShow=this.toShow.add(this.containers);}
if(this.settings.success){
for(i=0;this.successList[i];i++){
this.showLabel(this.successList[i]);}}
if(this.settings.unhighlight){
for(i=0,elements=this.validElements();elements[i];i++){
this.settings.unhighlight.call(this,elements[i],this.settings.errorClass,this.settings.validClass);}}
this.toHide=this.toHide.not(this.toShow);
this.hideErrors();
this.addWrapper(this.toShow).show();},
validElements:function(){
return this.currentElements.not(this.invalidElements());},
invalidElements:function(){
return $(this.errorList).map(function(){
return this.element;});},
showLabel:function(element,message){
var label=this.errorsFor(element);
if(label.length){
label.removeClass(this.settings.validClass).addClass(this.settings.errorClass);
label.html(message);}else{
label=$("<"+this.settings.errorElement+">")
.attr("for",this.idOrName(element))
.addClass(this.settings.errorClass)
.html(message||"");
if(this.settings.wrapper){
label=label.hide().show().wrap("<"+this.settings.wrapper+"/>").parent();}
if(!this.labelContainer.append(label).length){
if(this.settings.errorPlacement){
this.settings.errorPlacement(label,$(element));}else{
label.insertAfter(element);}}}
if(!message&&this.settings.success){
label.text("");
if(typeof this.settings.success==="string"){
label.addClass(this.settings.success);}else{
this.settings.success(label,element);}}
this.toShow=this.toShow.add(label);},
errorsFor:function(element){
var name=this.idOrName(element);
return this.errors().filter(function(){
return $(this).attr("for")===name;});},
idOrName:function(element){
return this.groups[element.name]||(this.checkable(element)?element.name:element.id||element.name);},
validationTargetFor:function(element){
if(this.checkable(element)){
element=this.findByName(element.name).not(this.settings.ignore)[0];}
return element;},
checkable:function(element){
return(/radio|checkbox/i).test(element.type);},
findByName:function(name){
return $(this.currentForm).find("[name='"+name+"']");},
getLength:function(value,element){
switch(element.nodeName.toLowerCase()){
case "select":
return $("option:selected",element).length;
case "input":
if(this.checkable(element)){
return this.findByName(element.name).filter(":checked").length;}}
return value.length;},
depend:function(param,element){
return this.dependTypes[typeof param]?this.dependTypes[typeof param](param,element):true;},
dependTypes:{
"boolean":function(param,element){
return param;},
"string":function(param,element){
return !!$(param,element.form).length;},
"function":function(param,element){
return param(element);}},
optional:function(element){
var val=this.elementValue(element);
return !$.validator.methods.required.call(this,val,element)&&"dependency-mismatch";},
startRequest:function(element){
if(!this.pending[element.name]){
this.pendingRequest++;
this.pending[element.name]=true;}},
stopRequest:function(element,valid){
this.pendingRequest--;
if(this.pendingRequest<0){
this.pendingRequest=0;}
delete this.pending[element.name];
if(valid&&this.pendingRequest===0&&this.formSubmitted&&this.form()){
$(this.currentForm).submit();
this.formSubmitted=false;}else if(!valid&&this.pendingRequest===0&&this.formSubmitted){
$(this.currentForm).triggerHandler("invalid-form",[this]);
this.formSubmitted=false;}},
previousValue:function(element){
return $.data(element,"previousValue")||$.data(element,"previousValue",{
old:null,
valid:true,
message:this.defaultMessage(element,"remote")});}},
classRuleSettings:{
required:{required:true},
email:{email:true},
url:{url:true},
date:{date:true},
dateISO:{dateISO:true},
number:{number:true},
digits:{digits:true},
creditcard:{creditcard:true}},
addClassRules:function(className,rules){
if(className.constructor===String){
this.classRuleSettings[className]=rules;}else{
$.extend(this.classRuleSettings,className);}},
classRules:function(element){
var rules={};
var classes=$(element).attr("class");
if(classes){
$.each(classes.split(" "),function(){
if(this in $.validator.classRuleSettings){
$.extend(rules,$.validator.classRuleSettings[this]);}});}
return rules;},
attributeRules:function(element){
var rules={};
var $element=$(element);
var type=$element[0].getAttribute("type");
for(var method in $.validator.methods){
var value;
if(method==="required"){
value=$element.get(0).getAttribute(method);
if(value===""){
value=true;}
value=!!value;}else{
value=$element.attr(method);}
if(/min|max/.test(method )&&(type ===null ||/number|range|text/.test(type))){
value=Number(value);}
if(value){
rules[method]=value;}else if(type===method&&type!=='range'){
rules[method]=true;}}
if(rules.maxlength&&/-1|2147483647|524288/.test(rules.maxlength)){
delete rules.maxlength;}
return rules;},
dataRules:function(element){
var method,value,
rules={},$element=$(element);
for(method in $.validator.methods){
value=$element.data("rule-"+method.toLowerCase());
if(value!==undefined){
rules[method]=value;}}
return rules;},
staticRules:function(element){
var rules={};
var validator=$.data(element.form,"validator");
if(validator.settings.rules){
rules=$.validator.normalizeRule(validator.settings.rules[element.name])||{};}
return rules;},
normalizeRules:function(rules,element){
$.each(rules,function(prop,val){
if(val===false){
delete rules[prop];
return;}
if(val.param||val.depends){
var keepRule=true;
switch(typeof val.depends){
case "string":
keepRule=!!$(val.depends,element.form).length;
break;
case "function":
keepRule=val.depends.call(element,element);
break;}
if(keepRule){
rules[prop]=val.param!==undefined?val.param:true;}else{
delete rules[prop];}}});
$.each(rules,function(rule,parameter){
rules[rule]=$.isFunction(parameter)?parameter(element):parameter;});
$.each(['minlength','maxlength'],function(){
if(rules[this]){
rules[this]=Number(rules[this]);}});
$.each(['rangelength','range'],function(){
var parts;
if(rules[this]){
if($.isArray(rules[this])){
rules[this]=[Number(rules[this][0]),Number(rules[this][1])];}else if(typeof rules[this]==="string"){
parts=rules[this].split(/[\s,]+/);
rules[this]=[Number(parts[0]),Number(parts[1])];}}});
if($.validator.autoCreateRanges){
if(rules.min&&rules.max){
rules.range=[rules.min,rules.max];
delete rules.min;
delete rules.max;}
if(rules.minlength&&rules.maxlength){
rules.rangelength=[rules.minlength,rules.maxlength];
delete rules.minlength;
delete rules.maxlength;}}
return rules;},
normalizeRule:function(data){
if(typeof data==="string"){
var transformed={};
$.each(data.split(/\s/),function(){
transformed[this]=true;});
data=transformed;}
return data;},
addMethod:function(name,method,message){
$.validator.methods[name]=method;
$.validator.messages[name]=message!==undefined?message:$.validator.messages[name];
if(method.length<3){
$.validator.addClassRules(name,$.validator.normalizeRule(name));}},
methods:{
required:function(value,element,param){
if(!this.depend(param,element)){
return "dependency-mismatch";}
if(element.nodeName.toLowerCase()==="select"){
var val=$(element).val();
return val&&val.length>0;}
if(this.checkable(element)){
return this.getLength(value,element)>0;}
return $.trim(value).length>0;},
email:function(value,element){
return this.optional(element)||/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i.test(value);},
url:function(value,element){
return this.optional(element)||/^(https?|s?ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value);},
date:function(value,element){
return this.optional(element)||!/Invalid|NaN/.test(new Date(value).toString());},
dateISO:function(value,element){
return this.optional(element)||/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/.test(value);},
number:function(value,element){
return this.optional(element)||/^-?(?:\d+|\d{1,3}(?:,\d{3})+)?(?:\.\d+)?$/.test(value);},
digits:function(value,element){
return this.optional(element)||/^\d+$/.test(value);},
creditcard:function(value,element){
if(this.optional(element)){
return "dependency-mismatch";}
if(/[^0-9 \-]+/.test(value)){
return false;}
var nCheck=0,
nDigit=0,
bEven=false;
value=value.replace(/\D/g,"");
for(var n=value.length-1;n>=0;n--){
var cDigit=value.charAt(n);
nDigit=parseInt(cDigit,10);
if(bEven){
if((nDigit*=2)>9){
nDigit-=9;}}
nCheck+=nDigit;
bEven=!bEven;}
return(nCheck%10)===0;},
minlength:function(value,element,param){
var length=$.isArray(value)?value.length:this.getLength($.trim(value),element);
return this.optional(element)||length>=param;},
maxlength:function(value,element,param){
var length=$.isArray(value)?value.length:this.getLength($.trim(value),element);
return this.optional(element)||length<=param;},
rangelength:function(value,element,param){
var length=$.isArray(value)?value.length:this.getLength($.trim(value),element);
return this.optional(element)||(length>=param[0]&&length<=param[1]);},
min:function(value,element,param){
return this.optional(element)||value>=param;},
max:function(value,element,param){
return this.optional(element)||value<=param;},
range:function(value,element,param){
return this.optional(element)||(value>=param[0]&&value<=param[1]);},
equalTo:function(value,element,param){
var target=$(param);
if(this.settings.onfocusout){
target.unbind(".validate-equalTo").bind("blur.validate-equalTo",function(){
$(element).valid();});}
return value===target.val();},
remote:function(value,element,param){
if(this.optional(element)){
return "dependency-mismatch";}
var previous=this.previousValue(element);
if(!this.settings.messages[element.name]){
this.settings.messages[element.name]={};}
previous.originalMessage=this.settings.messages[element.name].remote;
this.settings.messages[element.name].remote=previous.message;
param=typeof param==="string"&&{url:param}||param;
if(previous.old===value){
return previous.valid;}
previous.old=value;
var validator=this;
this.startRequest(element);
var data={};
data[element.name]=value;
$.ajax($.extend(true,{
url:param,
mode:"abort",
port:"validate"+element.name,
dataType:"json",
data:data,
success:function(response){
validator.settings.messages[element.name].remote=previous.originalMessage;
var valid=response===true||response==="true";
if(valid){
var submitted=validator.formSubmitted;
validator.prepareElement(element);
validator.formSubmitted=submitted;
validator.successList.push(element);
delete validator.invalid[element.name];
validator.showErrors();}else{
var errors={};
var message=response||validator.defaultMessage(element,"remote");
errors[element.name]=previous.message=$.isFunction(message)?message(value):message;
validator.invalid[element.name]=true;
validator.showErrors(errors);}
previous.valid=valid;
validator.stopRequest(element,valid);}},param));
return "pending";}}});
$.format=$.validator.format;}(jQuery));(function($){
var pendingRequests={};
if($.ajaxPrefilter){
$.ajaxPrefilter(function(settings,_,xhr){
var port=settings.port;
if(settings.mode==="abort"){
if(pendingRequests[port]){
pendingRequests[port].abort();}
pendingRequests[port]=xhr;}});}else{
var ajax=$.ajax;
$.ajax=function(settings){
var mode=("mode" in settings?settings:$.ajaxSettings).mode,
port=("port" in settings?settings:$.ajaxSettings).port;
if(mode==="abort"){
if(pendingRequests[port]){
pendingRequests[port].abort();}
pendingRequests[port]=ajax.apply(this,arguments);
return pendingRequests[port];}
return ajax.apply(this,arguments);};}}(jQuery));(function($){
$.extend($.fn,{
validateDelegate:function(delegate,type,handler){
return this.bind(type,function(event){
var target=$(event.target);
if(target.is(delegate)){
return handler.apply(target,arguments);}});}});}(jQuery));(function(factory){
if(typeof define==='function'&&define.amd){
define(['jquery'],factory);}else if(typeof exports==='object'){
module.exports=factory;}else{
factory(jQuery);}}(function($){
$.fn.bgiframe=function(s){
s=$.extend({
top:'auto',
left:'auto',
width:'auto',
height:'auto',
opacity:true,
src:'javascript:false;',
conditional:/MSIE 6\.0/.test(navigator.userAgent)},s);
if(!$.isFunction(s.conditional)){
var condition=s.conditional;
s.conditional=function(){return condition;};}
var $iframe=$('<iframe class="bgiframe"frameborder="0"tabindex="-1"src="'+s.src+'"'+
'style="display:block;position:absolute;z-index:-1;"/>');
return this.each(function(){
var $this=$(this);
if(s.conditional(this)===false){return;}
var existing=$this.children('iframe.bgiframe');
var $el=existing.length===0?$iframe.clone():existing;
$el.css({
'top':s.top=='auto'?((parseInt($this.css('borderTopWidth'),10)||0)*-1)+'px':prop(s.top),
'left':s.left=='auto'?((parseInt($this.css('borderLeftWidth'),10)||0)*-1)+'px':prop(s.left),
'width':s.width=='auto'?(this.offsetWidth+'px'):prop(s.width),
'height':s.height=='auto'?(this.offsetHeight+'px'):prop(s.height),
'opacity':s.opacity===true?0:undefined});
if(existing.length===0){
$this.prepend($el);}});};
$.fn.bgIframe=$.fn.bgiframe;
function prop(n){
return n&&n.constructor===Number?n+'px':n;}}));;(function($){
var b64="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",
a256='',
r64=[256],
r256=[256],
i=0;
var UTF8={
encode:function(strUni){
var strUtf=strUni.replace(/[\u0080-\u07ff]/g,
function(c){
var cc=c.charCodeAt(0);
return String.fromCharCode(0xc0|cc>>6,0x80|cc&0x3f);})
.replace(/[\u0800-\uffff]/g,
function(c){
var cc=c.charCodeAt(0);
return String.fromCharCode(0xe0|cc>>12,0x80|cc>>6&0x3F,0x80|cc&0x3f);});
return strUtf;},
decode:function(strUtf){
var strUni=strUtf.replace(/[\u00e0-\u00ef][\u0080-\u00bf][\u0080-\u00bf]/g,
function(c){
var cc=((c.charCodeAt(0)&0x0f)<<12)|((c.charCodeAt(1)&0x3f)<<6)|(c.charCodeAt(2)&0x3f);
return String.fromCharCode(cc);})
.replace(/[\u00c0-\u00df][\u0080-\u00bf]/g,
function(c){
var cc=(c.charCodeAt(0)&0x1f)<<6|c.charCodeAt(1)&0x3f;
return String.fromCharCode(cc);});
return strUni;}};
while(i<256){
var c=String.fromCharCode(i);
a256+=c;
r256[i]=i;
r64[i]=b64.indexOf(c);++i;}
function code(s,discard,alpha,beta,w1,w2){
s=String(s);
var buffer=0,
i=0,
length=s.length,
result='',
bitsInBuffer=0;
while(i<length){
var c=s.charCodeAt(i);
c=c<256?alpha[c]:-1;
buffer=(buffer<<w1)+c;
bitsInBuffer+=w1;
while(bitsInBuffer>=w2){
bitsInBuffer-=w2;
var tmp=buffer>>bitsInBuffer;
result+=beta.charAt(tmp);
buffer^=tmp<<bitsInBuffer;}++i;}
if(!discard&&bitsInBuffer>0)result+=beta.charAt(buffer<<(w2-bitsInBuffer));
return result;}
var Plugin=$.base64=function(dir,input,encode){
return input?Plugin[dir](input,encode):dir?null:this;};
Plugin.btoa=Plugin.encode=function(plain,utf8encode){
plain=Plugin.raw===false||Plugin.utf8encode||utf8encode?UTF8.encode(plain):plain;
plain=code(plain,false,r256,b64,8,6);
return plain+'===='.slice((plain.length%4)||4);};
Plugin.atob=Plugin.decode=function(coded,utf8decode){
coded=String(coded).split('=');
var i=coded.length;
do{--i;
coded[i]=code(coded[i],true,r64,a256,6,8);}while(i>0);
coded=coded.join('');
return Plugin.raw===false||Plugin.utf8decode||utf8decode?UTF8.decode(coded):coded;};}(jQuery));(function($){
var opt;
$.fn.jqprint=function(options){
opt=$.extend({},$.fn.jqprint.defaults,options);
var $element=(this instanceof jQuery)?this:$(this);
if(opt.operaSupport&&$.browser.opera){
var tab=window.open("","jqPrint-preview");
tab.document.open();
var doc=tab.document;}
else{
var $iframe=$("<iframe  />");
if(!opt.debug){$iframe.css({position:"absolute",width:"0px",height:"0px",left:"-600px",top:"-600px"});}
$iframe.appendTo("body");
var doc=$iframe[0].contentWindow.document;}
if(opt.importCSS){
if($("link[media=print]").length>0){
$("link[media=print]").each(function(){
doc.write("<link type='text/css' rel='stylesheet' href='"+$(this).attr("href")+"' media='print' />");});}
else{
$("link").each(function(){
doc.write("<link type='text/css' rel='stylesheet' href='"+$(this).attr("href")+"' />");});}}
if(opt.printContainer){doc.write($element.outer());}
else{$element.each(function(){doc.write($(this).html());});}
doc.close();(opt.operaSupport&&$.browser.opera?tab:$iframe[0].contentWindow).focus();
setTimeout(function(){(opt.operaSupport&&$.browser.opera?tab:$iframe[0].contentWindow).print();if(tab){tab.close();}},1000);}
$.fn.jqprint.defaults={
debug:true,
importCSS:true,
printContainer:true,
operaSupport:true};
jQuery.fn.outer=function(){
return $($('<div></div>').html(this.clone())).html();}})(jQuery);;
if(typeof JSON!=='object'){
JSON={};};(function(){
'use strict';
function f(n){
return n<10?'0'+n:n;};
if(typeof Date.prototype.toJSON!=='function'){
Date.prototype.toJSON=function(){
return isFinite(this.valueOf())?this.getUTCFullYear()+'-'+
f(this.getUTCMonth()+1)+'-'+
f(this.getUTCDate())+'T'+
f(this.getUTCHours())+':'+
f(this.getUTCMinutes())+':'+
f(this.getUTCSeconds())+'Z':null;};
String.prototype.toJSON=
Number.prototype.toJSON=
Boolean.prototype.toJSON=function(){
return this.valueOf();};};
var cx,
escapable,
gap,
indent,
meta,
rep;
function quote(string){
escapable.lastIndex=0;
return escapable.test(string)?'"'+string.replace(escapable,function(a){
var c=meta[a];
return typeof c==='string'?c:'\\u'+('0000'+a.charCodeAt(0).toString(16)).slice(-4);})+'"':'"'+string+'"';};
function str(key,holder){
var i,
k,
v,
length,
mind=gap,
partial,
value=holder[key];
if(value&&typeof value==='object'&&
typeof value.toJSON==='function'){
value=value.toJSON(key);}
if(typeof rep==='function'){
value=rep.call(holder,key,value);}
switch(typeof value){
case 'string':
return quote(value);
case 'number':
return isFinite(value)?String(value):'null';
case 'boolean':
case 'null':
return String(value);
case 'object':
if(!value){
return 'null';}
gap+=indent;
partial=[];
if(Object.prototype.toString.apply(value)==='[object Array]'){
length=value.length;
for(i=0;i<length;i+=1){
partial[i]=str(i,value)||'null';}
v=partial.length===0?'[]':gap?'[\n'+gap+partial.join(',\n'+gap)+'\n'+mind+']':'['+partial.join(',')+']';
gap=mind;
return v;}
if(rep&&typeof rep==='object'){
length=rep.length;
for(i=0;i<length;i+=1){
if(typeof rep[i]==='string'){
k=rep[i];
v=str(k,value);
if(v){
partial.push(quote(k)+(gap?': ':':')+v);}}}}else{
for(k in value){
if(Object.prototype.hasOwnProperty.call(value,k)){
v=str(k,value);
if(v){
partial.push(quote(k)+(gap?': ':':')+v);}}}}
v=partial.length===0?'{}':gap?'{\n'+gap+partial.join(',\n'+gap)+'\n'+mind+'}':'{'+partial.join(',')+'}';
gap=mind;
return v;}};
if(typeof JSON.stringify!=='function'){
escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
meta={
'\b':'\\b',
'\t':'\\t',
'\n':'\\n',
'\f':'\\f',
'\r':'\\r',
'"':'\\"',
'\\':'\\\\'};
JSON.stringify=function(value,replacer,space){
var i;
gap='';
indent='';
if(typeof space==='number'){
for(i=0;i<space;i+=1){
indent+=' ';}}else if(typeof space==='string'){
indent=space;}
rep=replacer;
if(replacer&&typeof replacer!=='function'&&(typeof replacer!=='object'||
typeof replacer.length!=='number')){
throw new Error('JSON.stringify');}
return str('',{'':value});};};
if(typeof JSON.parse!=='function'){
cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
JSON.parse=function(text,reviver){
var j;
function walk(holder,key){
var k,v,value=holder[key];
if(value&&typeof value==='object'){
for(k in value){
if(Object.prototype.hasOwnProperty.call(value,k)){
v=walk(value,k);
if(v!==undefined){
value[k]=v;}else{
delete value[k];}}}}
return reviver.call(holder,key,value);}
text=String(text);
cx.lastIndex=0;
if(cx.test(text)){
text=text.replace(cx,function(a){
return '\\u'+('0000'+a.charCodeAt(0).toString(16)).slice(-4);});}
if(/^[\],:{}\s]*$/
.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,'@')
.replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,']')
.replace(/(?:^|:|,)(?:\s*\[)+/g,''))){
j=eval('('+text+')');
return typeof reviver==='function'?walk({'':j},''):j;}
throw new SyntaxError('JSON.parse');};}}());(function($){
var rotateLeft=function(lValue,iShiftBits){
return(lValue<<iShiftBits)|(lValue>>>(32-iShiftBits));}
var addUnsigned=function(lX,lY){
var lX4,lY4,lX8,lY8,lResult;
lX8=(lX&0x80000000);
lY8=(lY&0x80000000);
lX4=(lX&0x40000000);
lY4=(lY&0x40000000);
lResult=(lX&0x3FFFFFFF)+(lY&0x3FFFFFFF);
if(lX4&lY4)return(lResult^0x80000000^lX8^lY8);
if(lX4|lY4){
if(lResult&0x40000000)return(lResult^0xC0000000^lX8^lY8);
else return(lResult^0x40000000^lX8^lY8);}else{
return(lResult^lX8^lY8);}}
var F=function(x,y,z){
return(x&y)|((~x)&z);}
var G=function(x,y,z){
return(x&z)|(y&(~z));}
var H=function(x,y,z){
return(x^y^z);}
var I=function(x,y,z){
return(y^(x|(~z)));}
var FF=function(a,b,c,d,x,s,ac){
a=addUnsigned(a,addUnsigned(addUnsigned(F(b,c,d),x),ac));
return addUnsigned(rotateLeft(a,s),b);};
var GG=function(a,b,c,d,x,s,ac){
a=addUnsigned(a,addUnsigned(addUnsigned(G(b,c,d),x),ac));
return addUnsigned(rotateLeft(a,s),b);};
var HH=function(a,b,c,d,x,s,ac){
a=addUnsigned(a,addUnsigned(addUnsigned(H(b,c,d),x),ac));
return addUnsigned(rotateLeft(a,s),b);};
var II=function(a,b,c,d,x,s,ac){
a=addUnsigned(a,addUnsigned(addUnsigned(I(b,c,d),x),ac));
return addUnsigned(rotateLeft(a,s),b);};
var convertToWordArray=function(string){
var lWordCount;
var lMessageLength=string.length;
var lNumberOfWordsTempOne=lMessageLength+8;
var lNumberOfWordsTempTwo=(lNumberOfWordsTempOne-(lNumberOfWordsTempOne%64))/64;
var lNumberOfWords=(lNumberOfWordsTempTwo+1)*16;
var lWordArray=Array(lNumberOfWords-1);
var lBytePosition=0;
var lByteCount=0;
while(lByteCount<lMessageLength){
lWordCount=(lByteCount-(lByteCount%4))/4;
lBytePosition=(lByteCount%4)*8;
lWordArray[lWordCount]=(lWordArray[lWordCount]|(string.charCodeAt(lByteCount)<<lBytePosition));
lByteCount++;}
lWordCount=(lByteCount-(lByteCount%4))/4;
lBytePosition=(lByteCount%4)*8;
lWordArray[lWordCount]=lWordArray[lWordCount]|(0x80<<lBytePosition);
lWordArray[lNumberOfWords-2]=lMessageLength<<3;
lWordArray[lNumberOfWords-1]=lMessageLength>>>29;
return lWordArray;};
var wordToHex=function(lValue){
var WordToHexValue="",WordToHexValueTemp="",lByte,lCount;
for(lCount=0;lCount<=3;lCount++){
lByte=(lValue>>>(lCount*8))&255;
WordToHexValueTemp="0"+lByte.toString(16);
WordToHexValue=WordToHexValue+WordToHexValueTemp.substr(WordToHexValueTemp.length-2,2);}
return WordToHexValue;};
var uTF8Encode=function(string){
string=string.replace(/\x0d\x0a/g,"\x0a");
var output="";
for(var n=0;n<string.length;n++){
var c=string.charCodeAt(n);
if(c<128){
output+=String.fromCharCode(c);}else if((c>127)&&(c<2048)){
output+=String.fromCharCode((c>>6)|192);
output+=String.fromCharCode((c&63)|128);}else{
output+=String.fromCharCode((c>>12)|224);
output+=String.fromCharCode(((c>>6)&63)|128);
output+=String.fromCharCode((c&63)|128);}}
return output;};
$.extend({
md5:function(string){
var x=Array();
var k,AA,BB,CC,DD,a,b,c,d;
var S11=7,S12=12,S13=17,S14=22;
var S21=5,S22=9,S23=14,S24=20;
var S31=4,S32=11,S33=16,S34=23;
var S41=6,S42=10,S43=15,S44=21;
string=uTF8Encode(string);
x=convertToWordArray(string);
a=0x67452301;b=0xEFCDAB89;c=0x98BADCFE;d=0x10325476;
for(k=0;k<x.length;k+=16){
AA=a;BB=b;CC=c;DD=d;
a=FF(a,b,c,d,x[k+0],S11,0xD76AA478);
d=FF(d,a,b,c,x[k+1],S12,0xE8C7B756);
c=FF(c,d,a,b,x[k+2],S13,0x242070DB);
b=FF(b,c,d,a,x[k+3],S14,0xC1BDCEEE);
a=FF(a,b,c,d,x[k+4],S11,0xF57C0FAF);
d=FF(d,a,b,c,x[k+5],S12,0x4787C62A);
c=FF(c,d,a,b,x[k+6],S13,0xA8304613);
b=FF(b,c,d,a,x[k+7],S14,0xFD469501);
a=FF(a,b,c,d,x[k+8],S11,0x698098D8);
d=FF(d,a,b,c,x[k+9],S12,0x8B44F7AF);
c=FF(c,d,a,b,x[k+10],S13,0xFFFF5BB1);
b=FF(b,c,d,a,x[k+11],S14,0x895CD7BE);
a=FF(a,b,c,d,x[k+12],S11,0x6B901122);
d=FF(d,a,b,c,x[k+13],S12,0xFD987193);
c=FF(c,d,a,b,x[k+14],S13,0xA679438E);
b=FF(b,c,d,a,x[k+15],S14,0x49B40821);
a=GG(a,b,c,d,x[k+1],S21,0xF61E2562);
d=GG(d,a,b,c,x[k+6],S22,0xC040B340);
c=GG(c,d,a,b,x[k+11],S23,0x265E5A51);
b=GG(b,c,d,a,x[k+0],S24,0xE9B6C7AA);
a=GG(a,b,c,d,x[k+5],S21,0xD62F105D);
d=GG(d,a,b,c,x[k+10],S22,0x2441453);
c=GG(c,d,a,b,x[k+15],S23,0xD8A1E681);
b=GG(b,c,d,a,x[k+4],S24,0xE7D3FBC8);
a=GG(a,b,c,d,x[k+9],S21,0x21E1CDE6);
d=GG(d,a,b,c,x[k+14],S22,0xC33707D6);
c=GG(c,d,a,b,x[k+3],S23,0xF4D50D87);
b=GG(b,c,d,a,x[k+8],S24,0x455A14ED);
a=GG(a,b,c,d,x[k+13],S21,0xA9E3E905);
d=GG(d,a,b,c,x[k+2],S22,0xFCEFA3F8);
c=GG(c,d,a,b,x[k+7],S23,0x676F02D9);
b=GG(b,c,d,a,x[k+12],S24,0x8D2A4C8A);
a=HH(a,b,c,d,x[k+5],S31,0xFFFA3942);
d=HH(d,a,b,c,x[k+8],S32,0x8771F681);
c=HH(c,d,a,b,x[k+11],S33,0x6D9D6122);
b=HH(b,c,d,a,x[k+14],S34,0xFDE5380C);
a=HH(a,b,c,d,x[k+1],S31,0xA4BEEA44);
d=HH(d,a,b,c,x[k+4],S32,0x4BDECFA9);
c=HH(c,d,a,b,x[k+7],S33,0xF6BB4B60);
b=HH(b,c,d,a,x[k+10],S34,0xBEBFBC70);
a=HH(a,b,c,d,x[k+13],S31,0x289B7EC6);
d=HH(d,a,b,c,x[k+0],S32,0xEAA127FA);
c=HH(c,d,a,b,x[k+3],S33,0xD4EF3085);
b=HH(b,c,d,a,x[k+6],S34,0x4881D05);
a=HH(a,b,c,d,x[k+9],S31,0xD9D4D039);
d=HH(d,a,b,c,x[k+12],S32,0xE6DB99E5);
c=HH(c,d,a,b,x[k+15],S33,0x1FA27CF8);
b=HH(b,c,d,a,x[k+2],S34,0xC4AC5665);
a=II(a,b,c,d,x[k+0],S41,0xF4292244);
d=II(d,a,b,c,x[k+7],S42,0x432AFF97);
c=II(c,d,a,b,x[k+14],S43,0xAB9423A7);
b=II(b,c,d,a,x[k+5],S44,0xFC93A039);
a=II(a,b,c,d,x[k+12],S41,0x655B59C3);
d=II(d,a,b,c,x[k+3],S42,0x8F0CCC92);
c=II(c,d,a,b,x[k+10],S43,0xFFEFF47D);
b=II(b,c,d,a,x[k+1],S44,0x85845DD1);
a=II(a,b,c,d,x[k+8],S41,0x6FA87E4F);
d=II(d,a,b,c,x[k+15],S42,0xFE2CE6E0);
c=II(c,d,a,b,x[k+6],S43,0xA3014314);
b=II(b,c,d,a,x[k+13],S44,0x4E0811A1);
a=II(a,b,c,d,x[k+4],S41,0xF7537E82);
d=II(d,a,b,c,x[k+11],S42,0xBD3AF235);
c=II(c,d,a,b,x[k+2],S43,0x2AD7D2BB);
b=II(b,c,d,a,x[k+9],S44,0xEB86D391);
a=addUnsigned(a,AA);
b=addUnsigned(b,BB);
c=addUnsigned(c,CC);
d=addUnsigned(d,DD);}
var tempValue=wordToHex(a)+wordToHex(b)+wordToHex(c)+wordToHex(d);
return tempValue.toLowerCase();}});})(jQuery);
jQuery.extend({
createUploadIframe:function(id,uri){
var frameId='jUploadFrame'+id;
var iframeHtml='<iframe id="'+frameId+'" name="'+frameId+'" style="position:absolute; top:-9999px; left:-9999px"';
if(window.ActiveXObject){
if(typeof uri=='boolean'){
iframeHtml+=' src="'+'javascript:false'+'"';}
else if(typeof uri=='string'){
iframeHtml+=' src="'+uri+'"';}}
iframeHtml+=' />';
jQuery(iframeHtml).appendTo(document.body);
return jQuery('#'+frameId).get(0);},
createUploadForm:function(id,fileElementId,data){
var formId='jUploadForm'+id;
var fileId='jUploadFile'+id;
var form=jQuery('<form  action="" method="POST" name="'+formId+'" id="'+formId+'" enctype="multipart/form-data"></form>');
if(data){
for(var i in data){
jQuery('<input type="hidden" name="'+i+'" value="'+data[i]+'" />').appendTo(form);}}
var oldElement=jQuery('#'+fileElementId);
var newElement=jQuery(oldElement).clone();
jQuery(oldElement).attr('id',fileId);
jQuery(oldElement).before(newElement);
jQuery(oldElement).appendTo(form);
jQuery(form).css('position','absolute');
jQuery(form).css('top','-1200px');
jQuery(form).css('left','-1200px');
jQuery(form).appendTo('body');
return form;},
ajaxFileUpload:function(s){
s=jQuery.extend({},jQuery.ajaxSettings,s);
var id=new Date().getTime()
var form=jQuery.createUploadForm(id,s.fileElementId,(typeof(s.data)=='undefined'?false:s.data));
var io=jQuery.createUploadIframe(id,s.secureuri);
var frameId='jUploadFrame'+id;
var formId='jUploadForm'+id;
if(s.global&&!jQuery.active++){
jQuery.event.trigger("ajaxStart");}
var requestDone=false;
var xml={}
if(s.global)
jQuery.event.trigger("ajaxSend",[xml,s]);
var uploadCallback=function(isTimeout){
var io=document.getElementById(frameId);
try{
if(io.contentWindow){
xml.responseText=io.contentWindow.document.body?io.contentWindow.document.body.innerHTML:null;
xml.responseXML=io.contentWindow.document.XMLDocument?io.contentWindow.document.XMLDocument:io.contentWindow.document;}else if(io.contentDocument){
xml.responseText=io.contentDocument.document.body?io.contentDocument.document.body.innerHTML:null;
xml.responseXML=io.contentDocument.document.XMLDocument?io.contentDocument.document.XMLDocument:io.contentDocument.document;}}catch(e){
jQuery.handleError(s,xml,null,e);}
if(xml||isTimeout=="timeout"){
requestDone=true;
var status;
try{
status=isTimeout!="timeout"?"success":"error";
if(status!="error"){
var data=jQuery.uploadHttpData(xml,s.dataType);
if(s.success)
s.success(data,status);
if(s.global)
jQuery.event.trigger("ajaxSuccess",[xml,s]);}else
jQuery.handleError(s,xml,status);}catch(e){
status="error";
jQuery.handleError(s,xml,status,e);}
if(s.global)
jQuery.event.trigger("ajaxComplete",[xml,s]);
if(s.global&&!--jQuery.active)
jQuery.event.trigger("ajaxStop");
if(s.complete)
s.complete(xml,status);
jQuery(io).unbind();
setTimeout(function(){
try{
jQuery(io).remove();
jQuery(form).remove();}catch(e){
jQuery.handleError(s,xml,null,e);}},100);
xml=null;}}
if(s.timeout>0){
setTimeout(function(){
if(!requestDone)
uploadCallback("timeout");},s.timeout);}
try{
var form=jQuery('#'+formId);
jQuery(form).attr('action',s.url);
jQuery(form).attr('method','POST');
jQuery(form).attr('target',frameId);
if(form.encoding){
jQuery(form).attr('encoding','multipart/form-data');}else{
jQuery(form).attr('enctype','multipart/form-data');}
jQuery(form).submit();}catch(e){
jQuery.handleError(s,xml,null,e);}
jQuery('#'+frameId).load(uploadCallback);
return{abort:function(){}};},
uploadHttpData:function(r,type){
var data=!type;
data=type=="xml"||data?r.responseXML:r.responseText;
if(type=="script")
jQuery.globalEval(data);
if(type=="json")
eval("data = "+data);
if(type=="html")
jQuery("<div>").html(data).evalScripts();
return data;}});(function($){
$.fn.multiSelect=function(opts){
opts=$.extend({},$.fn.multiSelect.defaults,opts);
return this.each(function(){
return new MultiSelect(this,opts);});};
$.fn.multiSelect.defaults={
showHeader:true,
maxHeight:175,
minWidth:135,
conWidth:0,
multiColumns:1,
checkAllText:_l.s15,
unCheckAllText:_l.s16,
noneSelectedText:_l.s17,
selectedText:_l.s18,
selectedList:0,
position:'bottom',
shadow:false,
fadeSpeed:200,
disabled:false,
state:'closed',
multiple:true,
onCheck:function(){},
onOpen:function(){},
onCheckAll:function(){},
onUncheckAll:function(){},
onOptgroupToggle:function(){}};
var multiselectID=0;
var MultiSelect=function(select,o){
var $select=$original=$(select),
$options,$optionsli,$header,$labels,
html=[],
optgroups=[],
isDisabled=$select.is(':disabled'),
id=select.id||'ui-multiselect-'+multiselectID++;
html.push('<a id="'+id+'" class="ui-multiselect '+(isDisabled||o.disabled?' ui-multiselect-disabled':'')+'">');
html.push('<span class="ui-a-left"></span><input id="rd'+select.id+'" readonly="readonly" type="text"  value="'+o.noneSelectedText+'" title="'+select.title+'" /><span class="ui-a-right"></span></a>');
html.push('<div class="ui-multiselect-options'+(o.shadow?' ui-multiselect-shadow':'')+'">');
if(o.showHeader&&o.multiple){
html.push('<div class="ui-multiselect-header clearfix">');
html.push('<ul class="">');
html.push('<li style="width:60px"><a class="ui-multiselect-all" href=""><span class="icon-check"></span>'+o.checkAllText+'</a></li>');
html.push('<li style="width:60px"><a class="ui-multiselect-none" href=""><span class="icon-closethick"></span>'+o.unCheckAllText+'</a></li>');
html.push('<li style="width:20px;float:right; text-align:right;" class="ui-multiselect-close"><a href="" class="ui-multiselect-close icon-circle-close"></a></li>');
html.push('</ul>');
html.push('</div>');}
html.push('<ul class="ui-multiselect-checkboxes">');
if(isDisabled){
$select.removeAttr("disabled");}
var selectsize=($select.find('option').size());
if(selectsize<40){
o.maxHeight=Math.ceil(selectsize/3)*28+10;}else{
o.maxHeight=10*28+10;}
$select.find('option').each(function(i){
var $this=$(this),
title=$this.html(),
value=this.value,
inputID=this.id||"ui-multiselect-"+id+"-option-"+i,
$parent=$this.parent(),
hasOptGroup=$parent.is('optgroup'),
isDisabled=$this.is(':disabled'),
labelClasses=['ui-corner-all'];
if(hasOptGroup){
var label=$parent.attr('label');
if($.inArray(label,optgroups)===-1){
html.push('<li class="ui-multiselect-optgroup-label"><a href="#">'+label+'</a></li>');
optgroups.push(label);}}
if(value.length>0){
if(isDisabled){
labelClasses.push('ui-multiselect-disabled');}
html.push('<li class="'+(isDisabled?'ui-multiselect-disabled':'')+'">');
html.push('<label style="position:relative;" for="'+inputID+'" class="'+labelClasses.join(' ')+'"><input style="width:20px; position:absolute; left: 101px; top: 1px;" id="'+inputID+'" type="'+(o.multiple?'checkbox':'radio')+'" name="'+select.name+'" value="'+value+'" title="'+title+'"');
if($this.is(':selected')){
html.push(' checked="checked"');}
if(isDisabled){
html.push(' disabled="disabled"');}
html.push(' /><div style="overflow:hidden" title='+title+'>'+title+'</div></label></li>');}});
html.push('</ul></div>');
$select=$select.after(html.join('')).next('a.ui-multiselect');
$options=$select.next('div.ui-multiselect-options');
$header=$options.find('div.ui-multiselect-header');
$optionsli=$options.find("ul:last").find('li').not('.ui-multiselect-optgroup-label');
$labels=$options.find('label').not('.ui-multiselect-disabled');
var iconWidth=20;
inputWidth=($original.outerWidth()>o.minWidth?o.minWidth:$original.outerWidth()),
totalWidth=inputWidth+iconWidth;
if(/\d/.test(o.minWidth)&&totalWidth<o.minWidth){
inputWidth=o.minWidth-iconWidth;
totalWidth=o.minWidth;}
var paddingWidth=parseInt($select.find("input").css("padding-left"))+parseInt($select.find("input").css("padding-right"));
$select.width(totalWidth).find('input').width(inputWidth-paddingWidth);
if(o.showHeader){
$header.find('a').click(function(e){
var $this=$(this);
if($this.hasClass('ui-multiselect-close')){
$options.trigger('close');}else{
var checkAll=$this.hasClass('ui-multiselect-all');
$options.trigger('toggleChecked',[(checkAll?true:false)]);
o[checkAll?'onCheckAll':'onUncheckAll']['call'](this);}
e.preventDefault();});}
var updateSelected=function(){
var $inputs=$labels.find('input'),
$checked=$inputs.filter(':checked'),
value='',
numChecked=$checked.length;
if(numChecked===0){
value=o.noneSelectedText;}else{
if($.isFunction(o.selectedText)){
value=o.selectedText.call(this,numChecked,$inputs.length,$checked.get());}else if(/\d/.test(o.selectedList)&&o.selectedList>0&&numChecked<=o.selectedList){
value=$checked.map(function(){
return this.title;}).get().join(', ');}else{
value=o.selectedText.replace('#',numChecked).replace('#',$inputs.length);}}
$select.find('input').val(value);
return value;};
$select.bind({
click:function(){
$options.trigger('toggle');},
keypress:function(e){
switch(e.keyCode){
case 27:
case 38:
$options.trigger('close');
break;
case 40:
case 0:
$options.trigger('toggle');
break;}},
mouseenter:function(){
if(!$select.hasClass('ui-multiselect-disabled')){
$(this).addClass('ui-multiselect-hover');}},
mouseleave:function(){
$(this).removeClass('ui-multiselect-hover');}});
$options.bind({
'close':function(e,others){
others=others||false;
if(others===true){
$('div.ui-multiselect-options')
.filter(':visible')
.fadeOut(o.fadeSpeed)
.prev('a.ui-multiselect')
.removeClass('ui-multiselect-active')
.trigger('mouseout');}else{
$select.removeClass('ui-multiselect-active').trigger('mouseout');
$options.fadeOut(o.fadeSpeed);}},
'open':function(e,closeOthers){
if($select.hasClass('ui-multiselect-disabled')){
return;}
var offset=$select.position(),
$container=$options.find('ul:last'),
top,width;
var absoffset=$select.offset();
$select.addClass('ui-multiselect-active');
if(closeOthers||typeof closeOthers==='undefined'){
$options.trigger('close',[true]);}
if(o.position==='middle'){
top=(offset.top+($select.height()/2)-($options.outerHeight()/2));}else if(o.position==='top'){
top=(offset.top-$options.outerHeight()+1);}else{
top=(offset.top+$select.outerHeight()+1);}
if(o.conWidth==0){
width=$select.width()-parseInt($options.css('padding-left'),10)-parseInt($options.css('padding-right'),10);}else{
width=o.conWidth;}
var oLeft;
var WinWidth=$(window).width();
if((absoffset.left+width)<WinWidth){
oLeft=offset.left;}else if((absoffset.left+width)>=WinWidth){
oLeft=offset.left-(width-o.minWidth);}
$labels.filter('label:first').trigger('mouseenter').trigger('focus');
$options.css({
position:'absolute',
top:top+'px',
left:oLeft+'px',
width:width+'px'}).show();
$container.scrollTop(0);
if(o.maxHeight){
$container.css('height',o.maxHeight);
$conOffset=$container.offset();
$windowHeight=$(window).height();
if($conOffset.top+o.maxHeight+36>$windowHeight){
$container.parent().css('top',(parseInt($container.parent().css('top'))-($conOffset.top+o.maxHeight-$windowHeight))+'px');}}
if(o.multiColumns!=1){
var www=(width-30)/o.multiColumns;
$optionsli.css({
width:www+'px',
height:'24px',
float:'left'});}else{
$optionsli.css({
clear:'both'})}
o.onOpen.call($options[0]);},
'toggle':function(){
$options.trigger($(this).is(':hidden')?'open':'close');},
'traverse':function(e,start,keycode){
var $start=$(start),
moveToLast=(keycode===38||keycode===37)?true:false,
$next=$start.parent()[moveToLast?'prevAll':'nextAll']('li:not(.ui-multiselect-disabled, .ui-multiselect-optgroup-label)')[moveToLast?'last':'first']();
if(!$next.length){
var $container=$options.find("ul:last");
$options.find('label')[moveToLast?'last':'first']().trigger('mouseover');
$container.scrollTop(moveToLast?$container.height():0);}else{
$next.find('label').trigger('mouseenter');}},
'toggleChecked':function(e,flag,group){
var $inputs=(group&&group.length)?group:$labels.find('input');
$inputs.not(':disabled').attr('checked',flag);
updateSelected();}}).find('li.ui-multiselect-optgroup-label a')
.click(function(e){
var $checkboxes=$(this).parent().nextUntil('li.ui-multiselect-optgroup-label').find('input');
$options.trigger('toggleChecked',[($checkboxes.filter(':checked').length===$checkboxes.length)?false:true,$checkboxes]);
o.onOptgroupToggle.call(this,$checkboxes.get());
e.preventDefault();});
$labels.bind({
mouseenter:function(){
$labels.removeClass('ui-multiselect-options-hover');
$(this).addClass('ui-multiselect-options-hover');},
keyup:function(e){
switch(e.keyCode){
case 27:
$options.trigger('close');
break;
case 38:
case 40:
case 37:
case 39:
$options.trigger('traverse',[this,e.keyCode]);
break;
case 13:
e.preventDefault();
$(this).click();
break;}}})
.find('input')
.bind('click',function(e){
o.onCheck.call(this);
updateSelected();})
.bind('autoclick',function(e){
o.onCheck.call(this);
updateSelected();});
$original.remove();
if($.fn.bgiframe){
$options.bgiframe();}
if(o.state==='open'){
$options.trigger('open',[false]);}
$select.find('input')[0].defaultValue=updateSelected();
return $select;};
$(document).bind('click',function(e){
var $target=$(e.target);
if(!$target.closest('div.ui-multiselect-options').length&&!$target.parent().hasClass('ui-multiselect')){
$('div.ui-multiselect-options').trigger('close',[true]);}});})(jQuery);

