<?php
require_once "../include/common.inc.php";
/*
 * 系统信息查看
 */
$memcachestate = array('pid' => 'memcache服务器的进程ID',
    'uptime' => '服务器已经运行的秒数',
    'time' => '服务器当前的unix时间戳',
    'version' => 'memcache版本',
    'pointer_size' => '当前操作系统的指针大小（32位系统一般是32bit）',
    'rusage_user' => '进程的累计用户时间',
    'rusage_system' => '进程的累计系统时间',
    'curr_items' => '服务器当前存储的items数量',
    'total_items' => '从服务器启动以后存储的items总数量',
    'bytes' => '当前服务器存储items占用的字节数',
    'curr_connections' => '当前打开着的连接数',
    'total_connections' => '从服务器启动以后曾经打开过的连接数',
    'connection_structures' => '服务器分配的连接构造数',
    'cmd_get' => 'get命令（获取）总请求次数',
    'cmd_set' => 'set命令（保存）总请求次数',
    'get_hits' => '总命中次数',
    'get_misses' => '总未命中次数',
    'evictions' => '为获取空闲内存而删除的items数（分配给memcache的空间用满后需要删除旧的items来得到空间分配给新的items）',
    'bytes_read' => '总读取字节数（请求字节数）',
    'bytes_written' => '总发送字节数（结果字节数）',
    'limit_maxbytes' => '分配给memcache的内存大小（字节）',
    'cmd_touch' => '执行touch次数，touch可以刷新过期时间',
    'cas_badval' => '使用擦拭次数',
    'reclaimed' => 'memcached 启动至今有多少次在存储数据的时候使用了过期数据的空间',
    'accepting_conns' => '正在接受的连接数',
    'threads' => '当前线程数');

?>
<div class='pageContent' selector='h1' layoutH='0'>
    <table class="list" width="100%">
        <thead>
        <tr>
            <th colspan="2">服务器特征</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td width="150">服务器时间</td>
            <td><?php echo gmdate("y年m月d日 h:i:s", time()); ?>&nbsp;(格林威治标准时间)&nbsp;&nbsp;<?php echo gmdate("y年n月j日 h:i:s", time() + 8 * 3600) ?>&nbsp;(北京时间)</td>
        </tr>
        <tr>
            <td>服务器域名</td>
            <td><?php echo("<a href=\"http://{$_SERVER["SERVER_NAME"]}\"  title=访问此域名 target=_blank>{$_SERVER["SERVER_NAME"]}</a>"); ?></td>
        </tr>
        <tr>
            <td>服务器ip地址</td>
            <td><?=gethostbyname($_SERVER["SERVER_NAME"])?></td>
        </tr>
        <tr>
            <td>服务器操作系统</td>
            <td><?php $os = explode(" ", php_uname());
echo $os[0];
echo "&nbsp;&nbsp;";
if ($os[0] == "windows") {
    echo "主机名称：" . $os[2];
} else {
    echo "内核版本：" . $os[2];
}
?></td>
        </tr>
        <tr>
            <td>服务器运行时间</td>
            <td><?=$sysinfo['uptime'] ? $sysinfo['uptime'] : "对不起windows系统不支持"?></td>
        </tr>
        <tr>
            <td>服务器操作系统文字编码</td>
            <td><?php echo($_SERVER["HTTP_ACCEPT_LANGUAGE"]); ?></td>
        </tr>
        <tr>
            <td>服务器解译引擎</td>
            <td><?php echo($_SERVER["SERVER_SOFTWARE"]); ?></td>
        </tr>
        <tr>
            <td>web服务端口</td>
            <td><?php echo($_SERVER["SERVER_PORT"]); ?></td>
        </tr>
        <tr>
            <td>服务器管理员</td>
            <td><a href="mailto:<?php echo $_SERVER['SERVER_ADMIN']; ?>"><?php echo $_SERVER['SERVER_ADMIN']; ?></a></td>
        </tr>
        <tr>
            <td>本文件路径</td>
            <td><?php echo($_SERVER["SCRIPT_FILENAME"]); ?></td>
        </tr>
        <tr>
            <td>服务端剩余空间</td>
            <td><?=qsFun::showGMK(disk_free_space('.'))?></td>
        </tr>
        <tr>
            <td>系统当前用户名</td>
            <td><?php echo @get_current_user(); ?></td>
        </tr>
        </tbody>
    </table>    
    <br><br>

    <table class="list" width="100%">
        <thead><tr><th colspan="3">memcache状态</th></tr>
            <tr><th>名称</th><th>值</th><th>注释</th></tr>
        </thead>
        <tbody>
<?php
foreach ($memcache->getStats() as $k => $v) {
    if ($k == 'uptime') {
        $v = qsTime::showTimeStr($v);
    } elseif ($k == 'time') {
        $v = date("Y-m-d h:i:s", $v);
    } elseif (!in_array($k, array('pid', 'version', 'libevent'))) {
        $v = qsFun::showGMK($v);
    }
    echo "<tr><td>$k</td><td> $v </td><td>{$memcachestate[$k]}</td>";
}
?>        
        </tbody>    
    </table>
<?php
//phpinfo();
qsFun::_die();
?>
    
</div>
