<?php 
/**
 * 扩展类，tpl1中使用，替代FF语句
 * 使用方法 C->v('id')   C为固定实例名 getid为类中定义的一个函数
 */
class extclass{
	private $db; 
	private $query; //数据库查询结果集
	private $line;  //数据库查询的当前行
	
	//下一行动作,由tpl1自动调用
	public function fetch(){
		$this->db->fetch_array($this->query);
	}
	
	//判断是否到结尾 
	public function eof(){
		return !$line;
	}
	
	///////////////////////////////////////////////////////////////////////////////
	public $title="月平均气温";      //报表标题
	public $subtitle="来源:网上";   //报表副标题
	public $ytitle="单位（元）";      //报表单位标题
	public $tipSuffix="元";   //提示单位的后缀
	
	
	//数据初始化功能
	public function init(){
		global $sqs_db;
		$this->db = $sqs_db;
		$this->query = $this->db->query("SELECT b.username,count(*), sum(totalmoney), sum(pronum), sum(totalmoney), sum(pronum) FROM `order` a, user b WHERE a.operator=b.id group by a.operator");		
	}
	
	//数据调用完毕的清理动作，可以不需要，也可以在获取数据之后做清理动作，比如，导出数据后，将导出的数据做已导出标记
	public function deinit(){
	}	
	
	//数据获取
	public function v($s){
		return $line[$s];
	}
	
	public function chart1(){
		$r = array(
			'title' => '月平均气温',
			'subtitle' => '来源:网上',
			'ytitle' => '单位（元）',
			'tipsuffix' => '元',
			'categories' => array('新订单','已发货','已签收','退货','取消'),
			/*'series' => array(
				array('张三',101,102,103,104,105),
				array('李四',111,122,153,164,135),
				array('王五',121,132,143,154,145),
				array('赵六',131,142,133,144,155),
				array('横七',141,152,123,134,165),
				array('竖八',151,162,113,114,175)				
			)*/			
		);
		$series=array();
		while($l = $this->db->fetch_array($this->query)){
			$s = array();
			foreach ($l as $v) { $s[] = $v; }
			$series[] = $s; 
		}
		$r['series']=$series;
		
		return $r;
	}
}
?>